/*
 * Decompiled with CFR 0.152.
 */
package net.formicary.remoterun.embed;

import com.google.protobuf.MessageLite;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.cert.X509Certificate;
import net.formicary.remoterun.common.KeyStoreUtil;
import net.formicary.remoterun.common.NettyLoggingHandler;
import net.formicary.remoterun.common.RemoteRunException;
import net.formicary.remoterun.common.proto.RemoteRun;
import net.formicary.remoterun.embed.AgentConnection;
import net.formicary.remoterun.embed.ConnectionState;
import net.formicary.remoterun.embed.ServerTrustManager;
import net.formicary.remoterun.embed.callback.AgentConnectionCallback;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.LengthFieldPrepender;
import org.jboss.netty.handler.codec.protobuf.ProtobufDecoder;
import org.jboss.netty.handler.codec.protobuf.ProtobufEncoder;
import org.jboss.netty.handler.ssl.SslHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteRunMaster
extends SimpleChannelHandler
implements ChannelFutureListener {
    private static final Logger log = LoggerFactory.getLogger(RemoteRunMaster.class);
    private static final AtomicLong NEXT_REQUEST_ID = new AtomicLong();
    private final Set<AgentConnection> agentConnections = new CopyOnWriteArraySet<AgentConnection>();
    private final ServerBootstrap bootstrap;
    private AgentConnectionCallback callback;

    public RemoteRunMaster() {
        this(null);
    }

    public RemoteRunMaster(AgentConnectionCallback callback) {
        this(Executors.newCachedThreadPool(), Executors.newCachedThreadPool(), callback);
    }

    public RemoteRunMaster(Executor bossExecutor, Executor workerExecutor, AgentConnectionCallback callback) {
        this.callback = callback;
        NioServerSocketChannelFactory factory = new NioServerSocketChannelFactory(bossExecutor, workerExecutor);
        this.bootstrap = new ServerBootstrap((ChannelFactory)factory);
        this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                return Channels.pipeline((ChannelHandler[])new ChannelHandler[]{new SslHandler(RemoteRunMaster.createSslEngine()), new LengthFieldBasedFrameDecoder(0x100000, 0, 4, 0, 4), new LengthFieldPrepender(4), new ProtobufDecoder((MessageLite)RemoteRun.AgentToMaster.getDefaultInstance()), new ProtobufEncoder(), new NettyLoggingHandler(), RemoteRunMaster.this});
            }
        });
        this.bootstrap.setOption("child.tcpNoDelay", (Object)true);
        this.bootstrap.setOption("child.keepAlive", (Object)true);
    }

    public static long getNextRequestId() {
        return NEXT_REQUEST_ID.getAndIncrement();
    }

    public AgentConnectionCallback getCallback() {
        return this.callback;
    }

    public void setCallback(AgentConnectionCallback callback) {
        this.callback = callback;
    }

    public static SSLEngine createSslEngine() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.1");
            KeyManager[] keyManagers = KeyStoreUtil.createKeyStore((String)"JKS", (String)"ssl/server-keystore.jks", (String)"123456");
            TrustManager[] trustManagers = KeyStoreUtil.createTrustStore((String)"JKS", (String)"ssl/ca-truststore.jks", (String)"123456");
            trustManagers[0] = new ServerTrustManager((X509TrustManager)trustManagers[0]);
            sslContext.init(keyManagers, trustManagers, null);
            SSLEngine sslEngine = sslContext.createSSLEngine();
            sslEngine.setNeedClientAuth(true);
            sslEngine.setUseClientMode(false);
            return sslEngine;
        }
        catch (Exception e) {
            throw new RemoteRunException("Failed to create server SSLEngine", (Throwable)e);
        }
    }

    public InetSocketAddress bind(InetSocketAddress address) {
        Channel channel = this.bootstrap.bind((SocketAddress)address);
        log.info("Listening for connections on " + channel.getLocalAddress());
        return (InetSocketAddress)channel.getLocalAddress();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        ctx.sendUpstream((ChannelEvent)e);
        ctx.getChannel().close();
        log.info("Exception caught, closing channel to agent from " + ctx.getChannel().getRemoteAddress().toString(), e.getCause());
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent message) throws Exception {
        AgentConnection agent = (AgentConnection)ctx.getChannel().getAttachment();
        RemoteRun.AgentToMaster agentToMaster = (RemoteRun.AgentToMaster)message.getMessage();
        if (agentToMaster.hasAgentInfo()) {
            agent.setAgentInfo(agentToMaster.getAgentInfo());
            agent.setConnectionState(ConnectionState.CONNECTED);
            String description = agent.getChannel().getRemoteAddress() + " (" + RemoteRunMaster.getPeerDn(message.getChannel()) + ")";
            log.info("Agent connection complete from " + description);
            log.debug("Agent information: {}", (Object)agentToMaster.getAgentInfo());
            if (this.callback != null) {
                try {
                    this.callback.agentConnected(agent);
                }
                catch (Exception e) {
                    log.error("Failed to process connected callback, closing connection to " + description, (Throwable)e);
                    agent.shutdown();
                }
            }
        }
        try {
            agent.messageReceived(agent, agentToMaster);
            if (this.callback != null) {
                this.callback.messageReceived(agent, agentToMaster);
            }
        }
        catch (Exception e) {
            String description = message.getChannel().getRemoteAddress() + " (" + RemoteRunMaster.getPeerDn(message.getChannel()) + ")";
            log.error("Failed to process " + agentToMaster.getMessageType() + " message, closing connection to " + description, (Throwable)e);
            message.getChannel().close();
        }
        ctx.sendUpstream((ChannelEvent)message);
    }

    private static final String getPeerDn(Channel channel) {
        String peerDn;
        try {
            SSLEngine engine = ((SslHandler)channel.getPipeline().get(SslHandler.class)).getEngine();
            X509Certificate peerCertificate = engine.getSession().getPeerCertificateChain()[0];
            peerDn = peerCertificate.getSubjectDN().toString();
        }
        catch (SSLPeerUnverifiedException e1) {
            log.trace("Unable to extract peer certificate DN", (Throwable)e1);
            peerDn = "unknown";
        }
        return peerDn;
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        AgentConnection connection = new AgentConnection(ctx.getChannel());
        ctx.getChannel().setAttachment((Object)connection);
        this.agentConnections.add(connection);
        SslHandler sslHandler = (SslHandler)ctx.getPipeline().get(SslHandler.class);
        sslHandler.handshake().addListener((ChannelFutureListener)this);
        log.info("Agent connected from " + ctx.getChannel().getRemoteAddress().toString() + " (" + this.agentConnections.size() + " open connections)");
        ctx.sendUpstream((ChannelEvent)e);
    }

    public void operationComplete(ChannelFuture future) throws Exception {
        if (future.isSuccess()) {
            AgentConnection connection = (AgentConnection)future.getChannel().getAttachment();
            connection.setConnectionState(ConnectionState.PENDING_AGENTINFO);
            SSLEngine engine = ((SslHandler)future.getChannel().getPipeline().get(SslHandler.class)).getEngine();
            X509Certificate peerCertificate = engine.getSession().getPeerCertificateChain()[0];
            String description = future.getChannel().getRemoteAddress() + " (" + peerCertificate.getSubjectDN().toString() + ")";
            log.info("Agent connected (pending receipt of env info etc) from " + description);
        } else {
            future.getChannel().close();
        }
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        AgentConnection connection = (AgentConnection)ctx.getChannel().getAttachment();
        connection.setConnectionState(ConnectionState.CLOSED);
        this.agentConnections.remove(connection);
        ctx.sendUpstream((ChannelEvent)e);
        log.info("Agent disconnected from " + ctx.getChannel().getRemoteAddress().toString() + " (" + this.agentConnections.size() + " open connections)");
        if (this.callback != null) {
            this.callback.agentDisconnected(connection);
        }
    }

    public Set<AgentConnection> getAgentConnections() {
        return this.agentConnections;
    }

    public void shutdown() {
        for (AgentConnection agentConnection : this.agentConnections) {
            agentConnection.shutdown();
        }
        this.bootstrap.shutdown();
    }

    public Collection<AgentConnection> getConnectedClients() {
        ArrayList<AgentConnection> result = new ArrayList<AgentConnection>();
        for (AgentConnection agentConnection : this.agentConnections) {
            if (agentConnection.getConnectionState() != ConnectionState.CONNECTED) continue;
            result.add(agentConnection);
        }
        return result;
    }

    public String toString() {
        return "RemoteRunMaster{agentConnections=" + this.agentConnections + ", bootstrap=" + this.bootstrap + ", callback=" + this.callback + '}';
    }
}

