/*
 * Decompiled with CFR 0.152.
 */
package net.formicary.remoterun.embed.request;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import net.formicary.remoterun.common.proto.RemoteRun;
import net.formicary.remoterun.embed.AgentConnection;
import net.formicary.remoterun.embed.DecodingBuffer;
import net.formicary.remoterun.embed.RemoteRunMaster;
import net.formicary.remoterun.embed.callback.TextOutputCallback;
import net.formicary.remoterun.embed.request.AgentRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextOutputRequest
implements AgentRequest {
    public static final int DEFAULT_MAX_LINE_LENGTH = 4096;
    private static final Logger log = LoggerFactory.getLogger(TextOutputRequest.class);
    private final TextOutputCallback callback;
    private final CountDownLatch completionLatch = new CountDownLatch(1);
    private final RemoteRun.MasterToAgent request;
    private final DecodingBuffer stdOutBuffer;
    private final DecodingBuffer stdErrBuffer;

    public TextOutputRequest(RemoteRun.MasterToAgent.Builder requestBuilder, TextOutputCallback callback) {
        this(requestBuilder, 4096, StandardCharsets.UTF_8, callback);
    }

    public TextOutputRequest(RemoteRun.MasterToAgent.Builder requestBuilder, int maxLineLength, TextOutputCallback callback) {
        this(requestBuilder, maxLineLength, StandardCharsets.UTF_8, callback);
    }

    public TextOutputRequest(RemoteRun.MasterToAgent.Builder requestBuilder, int maxLineLength, Charset charset, TextOutputCallback callback) {
        this.callback = callback;
        this.request = requestBuilder.setRequestId(RemoteRunMaster.getNextRequestId()).build();
        this.stdOutBuffer = new DecodingBuffer(new DecodingBuffer.DataCallback(){

            @Override
            public void lineRead(String line) {
                TextOutputRequest.this.callback.onStdOut(line);
            }
        }, charset, maxLineLength);
        this.stdErrBuffer = new DecodingBuffer(new DecodingBuffer.DataCallback(){

            @Override
            public void lineRead(String line) {
                TextOutputRequest.this.callback.onStdErr(line);
            }
        }, charset, maxLineLength);
    }

    @Override
    public RemoteRun.MasterToAgent getMessage() {
        return this.request;
    }

    public RemoteRun.MasterToAgent getRequest() {
        return this.request;
    }

    @Override
    public CountDownLatch getCompletionLatch() {
        return this.completionLatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void receivedMessage(AgentConnection agent, RemoteRun.AgentToMaster message) {
        byte[] fragment = message.hasFragment() ? message.getFragment().toByteArray() : null;
        switch (message.getMessageType()) {
            case STDOUT_FRAGMENT: {
                this.stdOutBuffer.write(fragment);
                break;
            }
            case STDERR_FRAGMENT: {
                this.stdErrBuffer.write(fragment);
                break;
            }
            case EXITED: {
                try {
                    this.callback.onExit(message.getExitCode(), message.hasExitReason() ? message.getExitReason() : null);
                    break;
                }
                catch (Exception e) {
                    log.error("Call to onExit failed", (Throwable)e);
                    break;
                }
                finally {
                    this.completionLatch.countDown();
                }
            }
        }
    }
}

