/*
 * Decompiled with CFR 0.152.
 */
package net.formicary.remoterun.embed;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;

public class DecodingBuffer {
    private static final int DEFAULT_MAX_LINE_LENGTH = 1024;
    private final DataCallback callback;
    private final CharBuffer charBuffer;
    private final ByteBuffer byteBuffer;
    private final CharsetDecoder charsetDecoder;
    private long count = 0L;
    private char lastChar = '\u0000';

    public DecodingBuffer(DataCallback callback) {
        this(callback, StandardCharsets.UTF_8, 1024);
    }

    public DecodingBuffer(DataCallback callback, int maxLineLength) {
        this(callback, StandardCharsets.UTF_8, maxLineLength);
    }

    public DecodingBuffer(DataCallback callback, Charset charset, int maxLineLength) {
        this.charsetDecoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.charBuffer = CharBuffer.allocate(maxLineLength);
        this.byteBuffer = ByteBuffer.allocate(maxLineLength);
        this.callback = callback;
    }

    public long getCount() {
        return this.count;
    }

    public void write(byte[] fragment) {
        this.write(fragment, 0, fragment.length);
    }

    public void write(byte[] fragment, int offset, int length) {
        int written = 0;
        while (written != length) {
            String line;
            int writeSize = Math.min(this.byteBuffer.remaining(), length - written);
            this.byteBuffer.put(fragment, offset + written, writeSize);
            written += writeSize;
            this.decode(false);
            if (this.byteBuffer.remaining() == 0) {
                throw new BufferOverflowException();
            }
            while ((line = this.readLine()) != null) {
                this.callback.lineRead(line);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decode(boolean endOfInput) {
        this.byteBuffer.flip();
        try {
            this.charsetDecoder.decode(this.byteBuffer, this.charBuffer, endOfInput);
        }
        finally {
            this.byteBuffer.compact();
        }
    }

    private String readLine() {
        String line = null;
        this.charBuffer.flip();
        for (int i = 0; i < this.charBuffer.remaining(); ++i) {
            char c = this.charBuffer.charAt(i);
            if (this.lastChar == '\r' && c == '\n') {
                this.charBuffer.position(i + 1);
                ++this.count;
            } else if (c == '\r' || c == '\n') {
                line = this.charBuffer.subSequence(0, i).toString();
                this.charBuffer.position(i + 1);
                this.count += (long)(i + 1);
            }
            this.lastChar = c;
            if (line != null) break;
        }
        if (this.charBuffer.position() == 0 && this.charBuffer.limit() == this.charBuffer.capacity()) {
            line = this.charBuffer.toString();
            this.count += (long)this.charBuffer.limit();
            this.charBuffer.limit(0);
        }
        this.charBuffer.compact();
        return line;
    }

    public void close() {
        this.decode(true);
        if (this.charBuffer.position() > 0) {
            this.charBuffer.flip();
            this.callback.lineRead(this.charBuffer.toString());
            this.count += (long)this.charBuffer.limit();
            this.charBuffer.compact();
        }
    }

    public static interface DataCallback {
        public void lineRead(String var1);
    }
}

