/*
 * Decompiled with CFR 0.152.
 */
package net.formicary.remoterun.common;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.formicary.remoterun.common.IoUtils;
import org.jboss.netty.util.CharsetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileReceiver
implements Runnable,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(FileReceiver.class);
    private final Path root;
    private final PipedOutputStream pipedOutputStream;
    private final ZipInputStream zipInputStream;
    private boolean closed = false;
    private boolean finished = false;
    private Throwable failure;
    private String failureMessage;
    private final PipedInputStream pipedInputStream;

    public FileReceiver(Path root) {
        this.root = root;
        this.pipedOutputStream = new PipedOutputStream();
        try {
            this.pipedInputStream = new PipedInputStream(this.pipedOutputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to hook up piped input/output streams", e);
        }
        this.zipInputStream = new ZipInputStream(this.pipedInputStream);
    }

    public PipedOutputStream getPipedOutputStream() {
        return this.pipedOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ZipEntry entry = null;
        try {
            while ((entry = this.zipInputStream.getNextEntry()) != null) {
                int bytesWritten;
                byte[] extraBytes = entry.getExtra();
                Set<PosixFilePermission> permissions = extraBytes == null ? null : PosixFilePermissions.fromString(new String(extraBytes, extraBytes.length - 9, 9, CharsetUtil.UTF_8));
                Path newPath = this.root.resolve(entry.getName()).toAbsolutePath();
                if (entry.isDirectory()) {
                    if (Files.isDirectory(newPath, new LinkOption[0])) {
                        log.debug("Directory {} already exists", (Object)newPath);
                        continue;
                    }
                    this.createDirectoriesWithPermissions(permissions, newPath);
                    continue;
                }
                Path parentPath = newPath.getParent();
                if (!Files.exists(parentPath, new LinkOption[0])) {
                    this.createDirectoriesWithPermissions(permissions, parentPath);
                }
                try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(newPath, new OpenOption[0]));){
                    bytesWritten = IoUtils.copy(this.zipInputStream, outputStream);
                }
                if (permissions != null) {
                    Files.setPosixFilePermissions(newPath, permissions);
                }
                log.debug("Written {} bytes to file {} with permissions={}", new Object[]{bytesWritten, newPath, extraBytes == null ? null : new String(extraBytes, CharsetUtil.UTF_8)});
            }
            log.debug("Finished receiving");
        }
        catch (Exception e) {
            this.failureMessage = entry == null ? "Failed whilst reading zip" : "Failed whilst reading " + entry.getName();
            this.failure = e;
            log.warn(this.failureMessage, (Throwable)e);
        }
        try {
            byte[] buffer = new byte[1024];
            int read = 0;
            while (read != -1) {
                read = this.pipedInputStream.read(buffer);
            }
        }
        catch (Exception e) {
            log.trace("Ignoring error reading last of stream", (Throwable)e);
        }
        IoUtils.closeQuietly(this);
        this.finished = true;
        FileReceiver fileReceiver = this;
        synchronized (fileReceiver) {
            this.notifyAll();
        }
    }

    private void createDirectoriesWithPermissions(Set<PosixFilePermission> permissions, Path newPath) throws IOException {
        if (permissions == null) {
            Files.createDirectories(newPath, new FileAttribute[0]);
        } else {
            Files.createDirectories(newPath, PosixFilePermissions.asFileAttribute(permissions));
        }
        log.debug("Created directory {}", (Object)newPath);
    }

    public synchronized void waitUntilFinishedUninterruptably() {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                log.debug("Ignoring interruption", (Throwable)e);
            }
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean success() {
        return this.failure == null;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public Throwable getFailure() {
        return this.failure;
    }

    public Path getRoot() {
        return this.root;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            IoUtils.closeQuietly(this.zipInputStream);
            IoUtils.closeQuietly(this.pipedOutputStream);
            this.closed = true;
        }
    }
}

