/*
 * Decompiled with CFR 0.152.
 */
package net.formicary.remoterun.common;

import net.formicary.remoterun.common.proto.RemoteRun;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.DownstreamMessageEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.logging.LoggingHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyLoggingHandler
extends LoggingHandler {
    private static final Logger log = LoggerFactory.getLogger(NettyLoggingHandler.class);

    public void log(ChannelEvent e) {
        if (e instanceof MessageEvent) {
            Object message = ((MessageEvent)e).getMessage();
            if (message instanceof RemoteRun.AgentToMaster) {
                log.debug("{} {}: {}", new Object[]{e.getChannel().toString(), e instanceof DownstreamMessageEvent ? "WRITE" : "RECEIVED", this.toString((RemoteRun.AgentToMaster)message)});
            } else if (message instanceof RemoteRun.MasterToAgent) {
                log.debug("{} {}: {}", new Object[]{e.getChannel().toString(), e instanceof DownstreamMessageEvent ? "WRITE" : "RECEIVED", this.toString((RemoteRun.MasterToAgent)message)});
            } else {
                log.debug("{}", (Object)e);
            }
        }
    }

    private String toString(RemoteRun.AgentToMaster message) {
        StringBuilder sb = new StringBuilder();
        sb.append("messageType=").append((Object)message.getMessageType());
        if (message.hasRequestId()) {
            sb.append(" requestId=").append(message.getRequestId());
        }
        if (message.hasFragment()) {
            sb.append(" fragment=[").append(message.getFragment().size()).append(" bytes]");
        }
        if (message.hasExitCode()) {
            sb.append(" exitCode=").append(message.getExitCode());
        }
        if (message.hasExitReason()) {
            sb.append(" exitReason=").append(message.getExitReason());
        }
        if (message.hasAgentInfo()) {
            RemoteRun.AgentToMaster.AgentInfo a = message.getAgentInfo();
            sb.append(" agentInfo=[").append("hostname=").append(a.getHostname()).append(", ip=").append(this.ipToString(a.getIpAddress().toByteArray())).append(", ").append(a.getEnvironmentCount()).append(" environment variables]");
        }
        return sb.toString();
    }

    private String ipToString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            byte next = bytes[i];
            if (i > 0) {
                sb.append('.');
            }
            sb.append(next & 0xFF);
        }
        return sb.toString();
    }

    private String toString(RemoteRun.MasterToAgent message) {
        StringBuilder sb = new StringBuilder();
        sb.append("messageType=").append((Object)message.getMessageType());
        if (message.hasRequestId()) {
            sb.append(" requestId=").append(message.getRequestId());
        }
        if (message.hasRunCommand()) {
            sb.append(" runCommand=").append(message.getRunCommand());
        }
        if (message.hasFragment()) {
            sb.append(" fragment=[").append(message.getFragment().size()).append(" bytes]");
        }
        if (message.hasDataSuccess()) {
            sb.append(" dataSuccess=").append(message.getDataSuccess());
        }
        if (message.hasPath()) {
            sb.append(" path=").append(message.getPath());
        }
        return sb.toString();
    }
}

