/*
 * Decompiled with CFR 0.152.
 */
package net.formicary.remoterun.common;

import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import net.formicary.remoterun.common.IoUtils;
import net.formicary.remoterun.common.RemoteRunException;

public abstract class KeyStoreUtil {
    private KeyStoreUtil() {
    }

    public static KeyManager[] createKeyStore(String defaultKeyStoreType, String defaultKeyStore, String defaultKeyStorePassword) {
        KeyManager[] keyManagerArray;
        String keyStoreFile = System.getProperty("javax.net.ssl.keyStore", defaultKeyStore);
        String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", defaultKeyStoreType);
        String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword", defaultKeyStorePassword);
        FileInputStream in = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            in = new FileInputStream(keyStoreFile);
            keyStore.load(in, keyStorePassword.toCharArray());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("PKIX", "SunJSSE");
            keyManagerFactory.init(keyStore, keyStorePassword.toCharArray());
            keyManagerArray = keyManagerFactory.getKeyManagers();
        }
        catch (Exception e) {
            try {
                throw new RemoteRunException("Failed to create keyStore from " + keyStoreFile, e);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(in);
        return keyManagerArray;
    }

    public static TrustManager[] createTrustStore(String defaultTrustStoreType, String defaultTrustStore, String defaultTrustStorePassword) {
        TrustManager[] trustManagerArray;
        String trustStoreFile = System.getProperty("javax.net.ssl.trustStore", defaultTrustStore);
        String trustStoreType = System.getProperty("javax.net.ssl.trustStoreType", defaultTrustStoreType);
        String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword", defaultTrustStorePassword);
        FileInputStream in = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(trustStoreType);
            in = new FileInputStream(trustStoreFile);
            keyStore.load(in, trustStorePassword.toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX", "SunJSSE");
            trustManagerFactory.init(keyStore);
            trustManagerArray = trustManagerFactory.getTrustManagers();
        }
        catch (Exception e) {
            try {
                throw new RemoteRunException("Failed to create trustStore from " + trustStoreFile, e);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(in);
        return trustManagerArray;
    }
}

