/*
 * Decompiled with CFR 0.152.
 */
package net.formicary.remoterun.common;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoUtils {
    private static final Logger log = LoggerFactory.getLogger(IoUtils.class);
    private static final int BUFFER_SIZE = 1024;

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                log.trace("Failed to close closeable " + closeable, (Throwable)e);
            }
        }
    }

    public static int copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int count;
        int total = 0;
        byte[] buffer = new byte[1024];
        while ((count = inputStream.read(buffer, 0, 1024)) != -1) {
            outputStream.write(buffer, 0, count);
            total += count;
        }
        return total;
    }
}

