/*
 * Decompiled with CFR 0.152.
 */
package net.formicary.remoterun.common;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jboss.netty.util.CharsetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStreamer
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(FileStreamer.class);
    private static final String IS_DIRECTORY = "isDirectory";
    private static final String LAST_MODIFIED = "lastModifiedTime";
    private static final int MAX_FRAGMENT_SIZE = 1000000;
    private final Path path;
    private final FileStreamerCallback callback;
    private final ZipOutputStream zipOutput;
    private boolean finished = false;

    public FileStreamer(Path path, final FileStreamerCallback callback) {
        this.path = path.toAbsolutePath();
        this.callback = callback;
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                this.write(new byte[]{(byte)(b & 0xFF)}, 0, 1);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                callback.writeDataChunk(b, off, len);
            }

            @Override
            public void close() throws IOException {
                log.debug("Closed");
            }
        }, 1000000);
        this.zipOutput = new ZipOutputStream(bufferedOutputStream);
    }

    private synchronized void finish(boolean success, String errorMessage, Throwable cause) {
        if (this.finished) {
            log.warn("Trying to call finished again, despite previous call, ignoring: " + errorMessage, cause);
        } else {
            this.finished = true;
            try {
                this.zipOutput.close();
            }
            catch (Exception e) {
                if (success) {
                    success = false;
                    errorMessage = "Failed to close output";
                    cause = e;
                }
                log.debug("Failed to close output when finishing file streaming of " + this.path, (Throwable)e);
            }
            this.callback.finished(success, errorMessage, cause);
        }
    }

    @Override
    public void run() {
        try {
            this.send(this.path, this.path.getParent(), this.zipOutput);
            this.finish(true, null, null);
        }
        catch (Exception e) {
            this.finish(false, "Failed to compress and send " + this.path.toString(), e);
        }
    }

    private void send(Path path, Path relativeTo, ZipOutputStream zipOutput) throws IOException {
        Map<String, Object> attributes = Files.readAttributes(path, "isDirectory,lastModifiedTime", LinkOption.NOFOLLOW_LINKS);
        boolean isDirectory = Boolean.TRUE.equals(attributes.get(IS_DIRECTORY));
        FileTime lastModifiedTime = (FileTime)attributes.get(LAST_MODIFIED);
        String relativePath = relativeTo.relativize(path).toString();
        ZipEntry entry = new ZipEntry(isDirectory ? relativePath + '/' : relativePath);
        if (path.getFileSystem().supportedFileAttributeViews().contains("posix")) {
            PosixFileAttributeView view = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
            PosixFileAttributes posix = view.readAttributes();
            entry.setExtra((posix.owner().getName() + ' ' + posix.group().getName() + ' ' + PosixFilePermissions.toString(posix.permissions())).getBytes(CharsetUtil.UTF_8));
        }
        entry.setTime(lastModifiedTime.toMillis());
        if (!Files.isSameFile(path, relativeTo)) {
            zipOutput.putNextEntry(entry);
        }
        if (isDirectory) {
            try (DirectoryStream<Path> dir = Files.newDirectoryStream(path);){
                for (Path child : dir) {
                    this.send(child, relativeTo, zipOutput);
                }
            }
        } else {
            Files.copy(path, zipOutput);
        }
    }

    public static interface FileStreamerCallback {
        public void writeDataChunk(byte[] var1, int var2, int var3);

        public void finished(boolean var1, String var2, Throwable var3);
    }
}

