/*
 * Decompiled with CFR 0.152.
 */
package net.formicary.remoterun.agent.process;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.formicary.remoterun.agent.process.InputWriter;
import net.formicary.remoterun.agent.process.OutputReader;
import net.formicary.remoterun.agent.process.ReadCallback;
import net.formicary.remoterun.common.proto.RemoteRun;

public class ProcessHelper {
    private final long serverId;
    private final Process process;
    private final OutputReader stdout;
    private final OutputReader stderr;
    private final InputWriter stdin;
    private final ReadCallback callback;
    private boolean finished = false;

    public ProcessHelper(long serverId, String cmd, List<String> argsList, ReadCallback callback) throws IOException {
        this.serverId = serverId;
        this.callback = callback;
        ArrayList<String> command = new ArrayList<String>(argsList.size());
        command.add(cmd);
        command.addAll(argsList);
        String[] cmdArray = command.toArray(new String[command.size()]);
        this.process = Runtime.getRuntime().exec(cmdArray);
        ReadCallback wrapper = new ReadCallback(){

            @Override
            public void dataAvailable(ByteBuffer buffer, long serverId, RemoteRun.AgentToMaster.MessageType type) {
                ProcessHelper.this.callback.dataAvailable(buffer, serverId, type);
            }

            @Override
            public synchronized void finished(long serverId) {
                if (!ProcessHelper.this.finished && ProcessHelper.this.stdout.isFinished() && ProcessHelper.this.stderr.isFinished()) {
                    ProcessHelper.this.finished = true;
                    ProcessHelper.this.stdin.shutdown();
                    ProcessHelper.this.callback.finished(serverId);
                }
            }
        };
        this.stdout = new OutputReader(this.process.getInputStream(), serverId, RemoteRun.AgentToMaster.MessageType.STDOUT_FRAGMENT, wrapper);
        this.stderr = new OutputReader(this.process.getErrorStream(), serverId, RemoteRun.AgentToMaster.MessageType.STDERR_FRAGMENT, wrapper);
        this.stdin = new InputWriter(this.process.getOutputStream(), serverId);
    }

    public void start() {
        this.stdout.start();
        this.stderr.start();
        this.stdin.start();
    }

    public long getServerId() {
        return this.serverId;
    }

    public Process getProcess() {
        return this.process;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void writeStdIn(byte[] data) {
        this.stdin.write(data);
    }

    public void closeStdIn() {
        this.stdin.shutdown();
    }
}

