/*
 * Decompiled with CFR 0.152.
 */
package net.formicary.remoterun.agent.process;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.LinkedBlockingQueue;
import net.formicary.remoterun.common.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputWriter
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(InputWriter.class);
    private final LinkedBlockingQueue<byte[]> toWrite = new LinkedBlockingQueue();
    private final OutputStream stream;
    private boolean finished = false;

    public InputWriter(OutputStream stream, long serverId) {
        this.stream = stream;
        this.setName("Process " + serverId + " STDIN writer");
    }

    @Override
    public void run() {
        while (!this.finished) {
            try {
                byte[] next = this.toWrite.take();
                this.stream.write(next);
                this.stream.flush();
            }
            catch (InterruptedException ignored) {
            }
            catch (IOException e) {
                log.warn("Failed to write to stream, ignoring", (Throwable)e);
            }
        }
        IoUtils.closeQuietly((Closeable)this.stream);
    }

    public void write(byte[] data) {
        while (true) {
            try {
                this.toWrite.put(data);
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void shutdown() {
        this.finished = true;
        this.interrupt();
    }
}

