/*
 * Decompiled with CFR 0.152.
 */
package net.formicary.remoterun.agent;

import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import java.lang.management.ManagementFactory;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PreDestroy;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import net.formicary.remoterun.agent.ProcessHandler;
import net.formicary.remoterun.agent.SentFileHandler;
import net.formicary.remoterun.common.FileStreamer;
import net.formicary.remoterun.common.KeyStoreUtil;
import net.formicary.remoterun.common.NettyLoggingHandler;
import net.formicary.remoterun.common.RemoteRunException;
import net.formicary.remoterun.common.proto.RemoteRun;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.LengthFieldPrepender;
import org.jboss.netty.handler.codec.protobuf.ProtobufDecoder;
import org.jboss.netty.handler.codec.protobuf.ProtobufEncoder;
import org.jboss.netty.handler.ssl.SslHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteRunAgent
extends SimpleChannelHandler
implements ChannelFutureListener {
    private static final Logger log = LoggerFactory.getLogger(RemoteRunAgent.class);
    private static final int RECONNECT_DELAY = 10000;
    private final ProcessHandler processHandler = new ProcessHandler();
    private final SentFileHandler sentFileHandler = new SentFileHandler();
    private final Executor writePool;
    private final ClientBootstrap bootstrap;
    private final ReentrantLock writeLock = new ReentrantLock(true);
    private InetSocketAddress address;
    private boolean shutdown = false;
    private Channel channel;
    private ChannelFuture handshakeFuture;
    private Timer timer;
    private ChannelFuture lastWriteFuture;
    private RemoteRun.AgentToMaster.AgentInfo agentInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteRunAgent(Executor bossExecutor, Executor workerExecutor, Executor writePool) {
        this.writePool = writePool;
        this.bootstrap = new ClientBootstrap((ChannelFactory)new NioClientSocketChannelFactory(bossExecutor, workerExecutor));
        boolean success = false;
        try {
            this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

                public ChannelPipeline getPipeline() throws Exception {
                    return Channels.pipeline((ChannelHandler[])new ChannelHandler[]{new SslHandler(RemoteRunAgent.createSslEngine()), new LengthFieldBasedFrameDecoder(0x100000, 0, 4, 0, 4), new LengthFieldPrepender(4), new ProtobufDecoder((MessageLite)RemoteRun.MasterToAgent.getDefaultInstance()), new ProtobufEncoder(), new NettyLoggingHandler(), RemoteRunAgent.this});
                }
            });
            this.bootstrap.setOption("tcpNoDelay", (Object)true);
            this.bootstrap.setOption("keepAlive", (Object)true);
            success = true;
        }
        finally {
            if (!success) {
                this.bootstrap.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String hostname = args.length >= 1 ? args[0] : "127.0.0.1";
        int port = args.length >= 2 ? Integer.parseInt(args[1]) : 1081;
        InetSocketAddress serverAddress = new InetSocketAddress(hostname, port);
        ExecutorService tp1 = Executors.newCachedThreadPool();
        ExecutorService tp2 = Executors.newFixedThreadPool(1);
        RemoteRunAgent agent = null;
        boolean success = false;
        try {
            agent = new RemoteRunAgent(tp1, tp1, tp2);
            agent.connect(serverAddress);
            success = true;
        }
        finally {
            if (!success) {
                tp1.shutdown();
                tp2.shutdown();
                if (agent != null) {
                    agent.shutdown();
                }
            }
        }
    }

    public static SSLEngine createSslEngine() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.1");
            KeyManager[] keyManagers = KeyStoreUtil.createKeyStore((String)"JKS", (String)"ssl/agent1-keystore.jks", (String)"123456");
            TrustManager[] trustManagers = KeyStoreUtil.createTrustStore((String)"JKS", (String)"ssl/ca-truststore.jks", (String)"123456");
            sslContext.init(keyManagers, trustManagers, null);
            SSLEngine sslEngine = sslContext.createSSLEngine();
            sslEngine.setUseClientMode(true);
            return sslEngine;
        }
        catch (Exception e) {
            throw new RemoteRunException("Failed to create agent SSLEngine", (Throwable)e);
        }
    }

    public ChannelFuture connect(InetSocketAddress address) {
        this.address = address;
        RemoteRun.AgentToMaster.AgentInfo.Builder builder = RemoteRun.AgentToMaster.AgentInfo.newBuilder();
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            builder.setIpAddress(ByteString.copyFrom((byte[])localHost.getAddress()));
            builder.setHostname(localHost.getHostName());
        }
        catch (UnknownHostException e) {
            log.debug("Unable to resolve local hostname to IP", (Throwable)e);
        }
        Map<String, String> environment = System.getenv();
        for (Map.Entry<String, String> entry : environment.entrySet()) {
            builder.addEnvironment(RemoteRun.StringStringKeyValuePair.newBuilder().setKey(entry.getKey()).setValue(entry.getValue()).build());
        }
        Properties properties = System.getProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            builder.addSystemProperty(RemoteRun.StringStringKeyValuePair.newBuilder().setKey((String)entry.getKey()).setValue((String)entry.getValue()).build());
        }
        this.agentInfo = builder.build();
        ChannelFuture connect = this.bootstrap.connect((SocketAddress)address);
        this.channel = connect.getChannel();
        return connect;
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        log.info("Connected to " + ctx.getChannel().getRemoteAddress());
        this.channel = ctx.getChannel();
        SslHandler sslHandler = (SslHandler)ctx.getPipeline().get(SslHandler.class);
        this.handshakeFuture = sslHandler.handshake();
        this.handshakeFuture.addListener((ChannelFutureListener)this);
        super.channelConnected(ctx, e);
    }

    public void operationComplete(ChannelFuture future) throws Exception {
        if (future.isSuccess()) {
            this.handshakeFuture = null;
            log.info("Agent SSL handshake completed, connected to " + future.getChannel().getRemoteAddress());
            this.write(RemoteRun.AgentToMaster.newBuilder().setMessageType(RemoteRun.AgentToMaster.MessageType.AGENT_INFO).setAgentInfo(this.agentInfo).build());
        } else {
            future.getChannel().close();
        }
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.getChannel().close();
        ctx.sendUpstream((ChannelEvent)e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (e.getCause() != null && ConnectException.class.equals(e.getCause().getClass()) && e.getCause().getMessage() != null && e.getCause().getMessage().startsWith("Connection refused: ")) {
            log.info(e.getCause().getMessage());
        } else {
            log.info("Exception caught, closing channel to server" + (ctx.getChannel().getRemoteAddress() == null ? "" : " at " + ctx.getChannel().getRemoteAddress()), e.getCause());
        }
        ctx.sendUpstream((ChannelEvent)e);
        ctx.getChannel().close();
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        final RemoteRun.MasterToAgent message = (RemoteRun.MasterToAgent)e.getMessage();
        RemoteRun.MasterToAgent.MessageType type = message.getMessageType();
        if (type == RemoteRun.MasterToAgent.MessageType.REQUEST_DATA) {
            final long requestId = message.getRequestId();
            this.writePool.execute((Runnable)new FileStreamer(Paths.get(message.getPath(), new String[0]), new FileStreamer.FileStreamerCallback(){

                public void writeDataChunk(byte[] data, int offset, int length) {
                    RemoteRunAgent.this.write(RemoteRun.AgentToMaster.newBuilder().setMessageType(RemoteRun.AgentToMaster.MessageType.REQUESTED_DATA).setRequestId(requestId).setFragment(ByteString.copyFrom((byte[])data, (int)offset, (int)length)).build());
                }

                public void finished(boolean success, String errorMessage, Throwable cause) {
                    RemoteRun.AgentToMaster.Builder builder = RemoteRun.AgentToMaster.newBuilder().setMessageType(RemoteRun.AgentToMaster.MessageType.REQUESTED_DATA).setRequestId(requestId);
                    if (success) {
                        builder.setExitCode(0);
                    } else {
                        builder.setExitCode(1).setExitReason(errorMessage + ": " + cause.toString());
                    }
                    RemoteRunAgent.this.write(builder.build());
                }
            }));
        } else if (type == RemoteRun.MasterToAgent.MessageType.RUN_COMMAND || type == RemoteRun.MasterToAgent.MessageType.STDIN_FRAGMENT || type == RemoteRun.MasterToAgent.MessageType.CLOSE_STDIN) {
            this.writePool.execute(new Runnable(){

                @Override
                public void run() {
                    RemoteRunAgent.this.processHandler.handle(message, RemoteRunAgent.this);
                }
            });
        } else if (type == RemoteRun.MasterToAgent.MessageType.SEND_DATA_NOTIFICATION || type == RemoteRun.MasterToAgent.MessageType.SEND_DATA_FRAGMENT) {
            this.writePool.execute(new Runnable(){

                @Override
                public void run() {
                    RemoteRunAgent.this.sentFileHandler.handle(message, RemoteRunAgent.this);
                }
            });
        }
        ctx.sendUpstream((ChannelEvent)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(RemoteRun.AgentToMaster message) {
        this.writeLock.lock();
        try {
            if (this.lastWriteFuture != null) {
                this.lastWriteFuture.awaitUninterruptibly();
            }
            if (this.channel != null) {
                this.lastWriteFuture = this.channel.write((Object)message);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.writeLock.lock();
        try {
            if (ctx.getChannel().getRemoteAddress() != null) {
                log.info("Disconnected from " + ctx.getChannel().getRemoteAddress());
            }
            this.channel = null;
        }
        finally {
            this.writeLock.unlock();
        }
        ctx.sendUpstream((ChannelEvent)e);
        if (!this.shutdown) {
            this.timer = new Timer();
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    RemoteRunAgent.this.connect(RemoteRunAgent.this.address);
                    RemoteRunAgent.this.timer.cancel();
                }
            }, 10000L);
        }
    }

    @PreDestroy
    public void shutdown() {
        this.shutdown = true;
        this.bootstrap.shutdown();
    }

    static {
        try {
            System.setProperty("remoterun.agent.name", ManagementFactory.getRuntimeMXBean().getName());
        }
        catch (Exception e) {
            log.trace("Failed to set remoterun.agent.name system property to ManagementFactory.getRuntimeMXBean().getName()", (Throwable)e);
        }
    }
}

