/*
 * Decompiled with CFR 0.152.
 */
package net.formicary.remoterun.agent.process;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.ByteBuffer;
import net.formicary.remoterun.agent.process.ReadCallback;
import net.formicary.remoterun.common.IoUtils;
import net.formicary.remoterun.common.proto.RemoteRun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputReader
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(OutputReader.class);
    private static final int BUFFER_SIZE = 0x100000;
    private final ByteBuffer buffer = ByteBuffer.wrap(new byte[0x100000]);
    private final InputStream stream;
    private final long serverId;
    private final RemoteRun.AgentToMaster.MessageType type;
    private final ReadCallback callback;
    private boolean finished = false;
    private Throwable error;

    public OutputReader(InputStream stream, long serverId, RemoteRun.AgentToMaster.MessageType type, ReadCallback callback) {
        this.stream = stream;
        this.serverId = serverId;
        this.type = type;
        this.callback = callback;
        this.setName("Process " + serverId + " " + type.name().substring(0, 6) + " reader");
    }

    public long getServerId() {
        return this.serverId;
    }

    public RemoteRun.AgentToMaster.MessageType getType() {
        return this.type;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public Throwable getError() {
        return this.error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int bytesRead;
            while (!this.finished && (bytesRead = this.stream.read(this.buffer.array(), this.buffer.position(), this.buffer.remaining())) != -1) {
                this.buffer.position(this.buffer.position() + bytesRead);
                if (this.buffer.position() <= 0) continue;
                this.buffer.flip();
                this.callback.dataAvailable(this.buffer, this.serverId, this.type);
                this.buffer.compact();
            }
            this.finished = true;
        }
        catch (Exception e) {
            this.finished = true;
            this.error = e;
            log.warn("Failed whilst reading stream", (Throwable)e);
        }
        finally {
            IoUtils.closeQuietly((Closeable)this.stream);
            this.callback.finished(this.serverId);
        }
    }
}

