/*
 * Decompiled with CFR 0.152.
 */
package net.formicary.remoterun.agent;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.Map;
import java.util.TreeMap;
import net.formicary.remoterun.agent.RemoteRunAgent;
import net.formicary.remoterun.common.FileReceiver;
import net.formicary.remoterun.common.IoUtils;
import net.formicary.remoterun.common.proto.RemoteRun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentFileHandler {
    private static final Logger log = LoggerFactory.getLogger(SentFileHandler.class);
    private final Map<Long, ReceivingFile> inProgress = new TreeMap<Long, ReceivingFile>();

    public void handle(RemoteRun.MasterToAgent message, RemoteRunAgent agent) {
        log.debug("Handle " + message.getMessageType());
        ReceivingFile receivingFile = null;
        if (message.getMessageType() == RemoteRun.MasterToAgent.MessageType.SEND_DATA_NOTIFICATION) {
            receivingFile = new ReceivingFile(message.getPath());
            this.inProgress.put(message.getRequestId(), receivingFile);
            try {
                receivingFile.receiver = new FileReceiver(Paths.get(message.getPath(), new String[0]));
                new Thread((Runnable)receivingFile.receiver).start();
            }
            catch (Exception e) {
                receivingFile.fail("Failed to create FileReceiver", e, 2);
            }
        } else if (message.getMessageType() == RemoteRun.MasterToAgent.MessageType.SEND_DATA_FRAGMENT) {
            receivingFile = this.inProgress.get(message.getRequestId());
            if (message.hasFragment() && !receivingFile.finished) {
                try {
                    message.getFragment().writeTo((OutputStream)receivingFile.receiver.getPipedOutputStream());
                }
                catch (IOException e) {
                    receivingFile.fail("Failed whilst writing to " + receivingFile.path, e, 3);
                }
            }
            if (message.hasDataSuccess() && !receivingFile.finished) {
                try {
                    if (message.getDataSuccess() && receivingFile.receiver.success()) {
                        receivingFile.succeed();
                    } else if (message.getDataSuccess()) {
                        receivingFile.fail(receivingFile.receiver.getFailureMessage(), receivingFile.receiver.getFailure(), 5);
                    } else {
                        receivingFile.fail("Server failed to stream file", null, 4);
                    }
                }
                catch (Exception e) {
                    receivingFile.fail("Failed to close piped output stream", e, 1);
                }
            }
        }
        if (receivingFile != null && !receivingFile.sentResponse && receivingFile.finished) {
            receivingFile.sentResponse = true;
            IoUtils.closeQuietly((Closeable)receivingFile.receiver.getPipedOutputStream());
            receivingFile.receiver.waitUntilFinishedUninterruptably();
            try {
                receivingFile.receiver.close();
            }
            catch (IOException e) {
                log.trace("Failed to close receiver", (Throwable)e);
            }
            RemoteRun.AgentToMaster.Builder builder = RemoteRun.AgentToMaster.newBuilder().setRequestId(message.getRequestId()).setMessageType(RemoteRun.AgentToMaster.MessageType.RECEIVED_DATA);
            builder = receivingFile.success ? builder.setExitCode(0) : builder.setExitCode(receivingFile.exitCode).setExitReason(receivingFile.failureMessage);
            agent.write(builder.build());
        }
    }

    private static final class ReceivingFile {
        private final String path;
        private boolean sentResponse = false;
        private int exitCode = 0;
        private boolean finished;
        private boolean success;
        private String failureMessage;
        public FileReceiver receiver;

        public ReceivingFile(String path) {
            this.path = path;
        }

        public void succeed() {
            this.finished = true;
            this.success = true;
        }

        public void fail(String message, Throwable throwable, int exitCode) {
            this.finished = true;
            this.success = false;
            this.failureMessage = throwable == null ? message : message + " : " + throwable.toString();
            log.warn("Failed to unpack " + this.path, throwable);
            this.exitCode = exitCode;
        }
    }
}

