/*
 * Decompiled with CFR 0.152.
 */
package net.formicary.remoterun.agent;

import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import net.formicary.remoterun.agent.RemoteRunAgent;
import net.formicary.remoterun.agent.process.ProcessHelper;
import net.formicary.remoterun.agent.process.ReadCallback;
import net.formicary.remoterun.common.proto.RemoteRun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessHandler
implements ReadCallback {
    private static final Logger log = LoggerFactory.getLogger(ProcessHandler.class);
    private final Map<Long, ProcessHelper> processes = Collections.synchronizedMap(new TreeMap());
    private RemoteRunAgent messageWriter;

    public void handle(RemoteRun.MasterToAgent message, RemoteRunAgent messageWriter) {
        this.messageWriter = messageWriter;
        long requestId = message.getRequestId();
        if (RemoteRun.MasterToAgent.MessageType.RUN_COMMAND == message.getMessageType()) {
            RemoteRun.MasterToAgent.RunCommand runCommand = message.getRunCommand();
            try {
                log.info("Starting process: {}", (Object)message);
                ProcessHelper processHelper = new ProcessHelper(requestId, runCommand.getCmd(), runCommand.getArgsList(), this);
                this.processes.put(requestId, processHelper);
                messageWriter.write(RemoteRun.AgentToMaster.newBuilder().setMessageType(RemoteRun.AgentToMaster.MessageType.STARTED).setRequestId(requestId).build());
                processHelper.start();
            }
            catch (Exception e1) {
                log.info("Failed to start process " + runCommand, (Throwable)e1);
                messageWriter.write(RemoteRun.AgentToMaster.newBuilder().setMessageType(RemoteRun.AgentToMaster.MessageType.EXITED).setRequestId(requestId).setExitCode(-1).setExitReason(e1.getClass().getName() + ": " + e1.getMessage()).build());
            }
        } else if (RemoteRun.MasterToAgent.MessageType.STDIN_FRAGMENT == message.getMessageType()) {
            ProcessHelper processHelper = this.processes.get(requestId);
            if (processHelper == null) {
                log.warn("Ignoring STDIN fragment for invalid request ID " + requestId);
            } else {
                processHelper.writeStdIn(message.getFragment().toByteArray());
            }
        } else if (RemoteRun.MasterToAgent.MessageType.CLOSE_STDIN == message.getMessageType()) {
            ProcessHelper processHelper = this.processes.get(requestId);
            if (processHelper == null) {
                log.warn("Ignoring CLOSE_STDIN request for invalid request ID " + requestId);
            } else {
                processHelper.closeStdIn();
            }
        }
    }

    @Override
    public void dataAvailable(ByteBuffer buffer, long serverId, RemoteRun.AgentToMaster.MessageType type) {
        this.messageWriter.write(RemoteRun.AgentToMaster.newBuilder().setMessageType(type).setRequestId(serverId).setFragment(ByteString.copyFrom((ByteBuffer)buffer)).build());
    }

    @Override
    public void finished(long serverId) {
        ProcessHelper process;
        ProcessHelper processHelper = this.processes.get(serverId);
        if (processHelper != null && processHelper.isFinished() && (process = this.processes.remove(serverId)) != null) {
            RemoteRun.AgentToMaster.Builder msgBuilder = RemoteRun.AgentToMaster.newBuilder().setMessageType(RemoteRun.AgentToMaster.MessageType.EXITED).setRequestId(serverId);
            try {
                int exitCode = processHelper.getProcess().waitFor();
                log.info("Process exited: requestId={} exitCode={}", (Object)serverId, (Object)exitCode);
                msgBuilder.setExitCode(exitCode);
            }
            catch (InterruptedException e) {
                log.error("Interrupted whilst waiting for process exit code: requestId=" + serverId, (Throwable)e);
            }
            this.messageWriter.write(msgBuilder.build());
        }
    }
}

