package net.folivo.trixnity.clientserverapi.model.authentication

import io.ktor.resources.*
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import net.folivo.trixnity.core.HttpMethod
import net.folivo.trixnity.core.HttpMethodType.POST
import net.folivo.trixnity.core.MatrixEndpoint
import net.folivo.trixnity.core.model.UserId

/**
 * @see <a href="https://spec.matrix.org/v1.3/client-server-api/#post_matrixclientv3logout">matrix spec</a>
 */
@Serializable
@Resource("/_matrix/client/v3/logout")
@HttpMethod(POST)
data class Logout(
    @SerialName("user_id") val asUserId: UserId? = null,
) : MatrixEndpoint<Unit, Unit>