package net.folivo.trixnity.client.store.repository.room

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.reflect.KClass

@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class OlmSessionDao_Impl(
  __db: RoomDatabase,
) : OlmSessionDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfRoomOlmSession: EntityInsertAdapter<RoomOlmSession>
  init {
    this.__db = __db
    this.__insertAdapterOfRoomOlmSession = object : EntityInsertAdapter<RoomOlmSession>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `OlmSession` (`senderKey`,`value`) VALUES (?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: RoomOlmSession) {
        statement.bindText(1, entity.senderKey)
        statement.bindText(2, entity.value)
      }
    }
  }

  public override suspend fun insert(entity: RoomOlmSession): Unit = performSuspending(__db, false,
      true) { _connection ->
    __insertAdapterOfRoomOlmSession.insert(_connection, entity)
  }

  public override suspend fun `get`(senderKey: String): RoomOlmSession? {
    val _sql: String = "SELECT * FROM OlmSession WHERE senderKey = ? LIMIT 1"
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, senderKey)
        val _columnIndexOfSenderKey: Int = getColumnIndexOrThrow(_stmt, "senderKey")
        val _columnIndexOfValue: Int = getColumnIndexOrThrow(_stmt, "value")
        val _result: RoomOlmSession?
        if (_stmt.step()) {
          val _tmpSenderKey: String
          _tmpSenderKey = _stmt.getText(_columnIndexOfSenderKey)
          val _tmpValue: String
          _tmpValue = _stmt.getText(_columnIndexOfValue)
          _result = RoomOlmSession(_tmpSenderKey,_tmpValue)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(senderKey: String) {
    val _sql: String = "DELETE FROM OlmSession WHERE senderKey = ?"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, senderKey)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteAll() {
    val _sql: String = "DELETE FROM OlmSession"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
