package net.folivo.trixnity.client.store.repository.room

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import kotlin.Boolean
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import net.folivo.trixnity.core.model.RoomId

@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class InboundMegolmSessionDao_Impl(
  __db: RoomDatabase,
) : InboundMegolmSessionDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfRoomInboundMegolmSession:
      EntityInsertAdapter<RoomInboundMegolmSession>
  init {
    this.__db = __db
    this.__insertAdapterOfRoomInboundMegolmSession = object :
        EntityInsertAdapter<RoomInboundMegolmSession>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `InboundMegolmSession` (`senderKey`,`sessionId`,`roomId`,`firstKnownIndex`,`hasBeenBackedUp`,`isTrusted`,`senderSigningKey`,`forwardingCurve25519KeyChain`,`pickled`) VALUES (?,?,?,?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: RoomInboundMegolmSession) {
        statement.bindText(1, entity.senderKey)
        statement.bindText(2, entity.sessionId)
        val _tmp: String? = RoomIdConverter.to(entity.roomId)
        if (_tmp == null) {
          statement.bindNull(3)
        } else {
          statement.bindText(3, _tmp)
        }
        statement.bindLong(4, entity.firstKnownIndex)
        val _tmp_1: Int = if (entity.hasBeenBackedUp) 1 else 0
        statement.bindLong(5, _tmp_1.toLong())
        val _tmp_2: Int = if (entity.isTrusted) 1 else 0
        statement.bindLong(6, _tmp_2.toLong())
        statement.bindText(7, entity.senderSigningKey)
        statement.bindText(8, entity.forwardingCurve25519KeyChain)
        statement.bindText(9, entity.pickled)
      }
    }
  }

  public override suspend fun insert(entity: RoomInboundMegolmSession): Unit =
      performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfRoomInboundMegolmSession.insert(_connection, entity)
  }

  public override suspend fun `get`(sessionId: String, roomId: RoomId): RoomInboundMegolmSession? {
    val _sql: String =
        "SELECT * FROM InboundMegolmSession WHERE sessionId = ? AND roomId = ? LIMIT 1"
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, sessionId)
        _argIndex = 2
        val _tmp: String? = RoomIdConverter.to(roomId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        val _columnIndexOfSenderKey: Int = getColumnIndexOrThrow(_stmt, "senderKey")
        val _columnIndexOfSessionId: Int = getColumnIndexOrThrow(_stmt, "sessionId")
        val _columnIndexOfRoomId: Int = getColumnIndexOrThrow(_stmt, "roomId")
        val _columnIndexOfFirstKnownIndex: Int = getColumnIndexOrThrow(_stmt, "firstKnownIndex")
        val _columnIndexOfHasBeenBackedUp: Int = getColumnIndexOrThrow(_stmt, "hasBeenBackedUp")
        val _columnIndexOfIsTrusted: Int = getColumnIndexOrThrow(_stmt, "isTrusted")
        val _columnIndexOfSenderSigningKey: Int = getColumnIndexOrThrow(_stmt, "senderSigningKey")
        val _columnIndexOfForwardingCurve25519KeyChain: Int = getColumnIndexOrThrow(_stmt,
            "forwardingCurve25519KeyChain")
        val _columnIndexOfPickled: Int = getColumnIndexOrThrow(_stmt, "pickled")
        val _result: RoomInboundMegolmSession?
        if (_stmt.step()) {
          val _tmpSenderKey: String
          _tmpSenderKey = _stmt.getText(_columnIndexOfSenderKey)
          val _tmpSessionId: String
          _tmpSessionId = _stmt.getText(_columnIndexOfSessionId)
          val _tmpRoomId: RoomId
          val _tmp_1: String?
          if (_stmt.isNull(_columnIndexOfRoomId)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getText(_columnIndexOfRoomId)
          }
          val _tmp_2: RoomId? = RoomIdConverter.from(_tmp_1)
          if (_tmp_2 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.RoomId', but it was NULL.")
          } else {
            _tmpRoomId = _tmp_2
          }
          val _tmpFirstKnownIndex: Long
          _tmpFirstKnownIndex = _stmt.getLong(_columnIndexOfFirstKnownIndex)
          val _tmpHasBeenBackedUp: Boolean
          val _tmp_3: Int
          _tmp_3 = _stmt.getLong(_columnIndexOfHasBeenBackedUp).toInt()
          _tmpHasBeenBackedUp = _tmp_3 != 0
          val _tmpIsTrusted: Boolean
          val _tmp_4: Int
          _tmp_4 = _stmt.getLong(_columnIndexOfIsTrusted).toInt()
          _tmpIsTrusted = _tmp_4 != 0
          val _tmpSenderSigningKey: String
          _tmpSenderSigningKey = _stmt.getText(_columnIndexOfSenderSigningKey)
          val _tmpForwardingCurve25519KeyChain: String
          _tmpForwardingCurve25519KeyChain =
              _stmt.getText(_columnIndexOfForwardingCurve25519KeyChain)
          val _tmpPickled: String
          _tmpPickled = _stmt.getText(_columnIndexOfPickled)
          _result =
              RoomInboundMegolmSession(_tmpSenderKey,_tmpSessionId,_tmpRoomId,_tmpFirstKnownIndex,_tmpHasBeenBackedUp,_tmpIsTrusted,_tmpSenderSigningKey,_tmpForwardingCurve25519KeyChain,_tmpPickled)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun getNotBackedUp(): List<RoomInboundMegolmSession> {
    val _sql: String = "SELECT * FROM InboundMegolmSession WHERE hasBeenBackedUp = 0"
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        val _columnIndexOfSenderKey: Int = getColumnIndexOrThrow(_stmt, "senderKey")
        val _columnIndexOfSessionId: Int = getColumnIndexOrThrow(_stmt, "sessionId")
        val _columnIndexOfRoomId: Int = getColumnIndexOrThrow(_stmt, "roomId")
        val _columnIndexOfFirstKnownIndex: Int = getColumnIndexOrThrow(_stmt, "firstKnownIndex")
        val _columnIndexOfHasBeenBackedUp: Int = getColumnIndexOrThrow(_stmt, "hasBeenBackedUp")
        val _columnIndexOfIsTrusted: Int = getColumnIndexOrThrow(_stmt, "isTrusted")
        val _columnIndexOfSenderSigningKey: Int = getColumnIndexOrThrow(_stmt, "senderSigningKey")
        val _columnIndexOfForwardingCurve25519KeyChain: Int = getColumnIndexOrThrow(_stmt,
            "forwardingCurve25519KeyChain")
        val _columnIndexOfPickled: Int = getColumnIndexOrThrow(_stmt, "pickled")
        val _result: MutableList<RoomInboundMegolmSession> = mutableListOf()
        while (_stmt.step()) {
          val _item: RoomInboundMegolmSession
          val _tmpSenderKey: String
          _tmpSenderKey = _stmt.getText(_columnIndexOfSenderKey)
          val _tmpSessionId: String
          _tmpSessionId = _stmt.getText(_columnIndexOfSessionId)
          val _tmpRoomId: RoomId
          val _tmp: String?
          if (_stmt.isNull(_columnIndexOfRoomId)) {
            _tmp = null
          } else {
            _tmp = _stmt.getText(_columnIndexOfRoomId)
          }
          val _tmp_1: RoomId? = RoomIdConverter.from(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.RoomId', but it was NULL.")
          } else {
            _tmpRoomId = _tmp_1
          }
          val _tmpFirstKnownIndex: Long
          _tmpFirstKnownIndex = _stmt.getLong(_columnIndexOfFirstKnownIndex)
          val _tmpHasBeenBackedUp: Boolean
          val _tmp_2: Int
          _tmp_2 = _stmt.getLong(_columnIndexOfHasBeenBackedUp).toInt()
          _tmpHasBeenBackedUp = _tmp_2 != 0
          val _tmpIsTrusted: Boolean
          val _tmp_3: Int
          _tmp_3 = _stmt.getLong(_columnIndexOfIsTrusted).toInt()
          _tmpIsTrusted = _tmp_3 != 0
          val _tmpSenderSigningKey: String
          _tmpSenderSigningKey = _stmt.getText(_columnIndexOfSenderSigningKey)
          val _tmpForwardingCurve25519KeyChain: String
          _tmpForwardingCurve25519KeyChain =
              _stmt.getText(_columnIndexOfForwardingCurve25519KeyChain)
          val _tmpPickled: String
          _tmpPickled = _stmt.getText(_columnIndexOfPickled)
          _item =
              RoomInboundMegolmSession(_tmpSenderKey,_tmpSessionId,_tmpRoomId,_tmpFirstKnownIndex,_tmpHasBeenBackedUp,_tmpIsTrusted,_tmpSenderSigningKey,_tmpForwardingCurve25519KeyChain,_tmpPickled)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(sessionId: String, roomId: RoomId) {
    val _sql: String = "DELETE FROM InboundMegolmSession WHERE sessionId = ? AND roomId = ?"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, sessionId)
        _argIndex = 2
        val _tmp: String? = RoomIdConverter.to(roomId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteAll() {
    val _sql: String = "DELETE FROM InboundMegolmSession"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
