package net.folivo.trixnity.client.store.repository.room

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import net.folivo.trixnity.core.model.RoomId

@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class RoomAccountDataDao_Impl(
  __db: RoomDatabase,
) : RoomAccountDataDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfRoomRoomAccountData: EntityInsertAdapter<RoomRoomAccountData>
  init {
    this.__db = __db
    this.__insertAdapterOfRoomRoomAccountData = object : EntityInsertAdapter<RoomRoomAccountData>()
        {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `RoomAccountData` (`roomId`,`type`,`key`,`event`) VALUES (?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: RoomRoomAccountData) {
        val _tmp: String? = RoomIdConverter.to(entity.roomId)
        if (_tmp == null) {
          statement.bindNull(1)
        } else {
          statement.bindText(1, _tmp)
        }
        statement.bindText(2, entity.type)
        statement.bindText(3, entity.key)
        statement.bindText(4, entity.event)
      }
    }
  }

  public override suspend fun insert(entity: RoomRoomAccountData): Unit = performSuspending(__db,
      false, true) { _connection ->
    __insertAdapterOfRoomRoomAccountData.insert(_connection, entity)
  }

  public override suspend fun insertAll(entity: List<RoomRoomAccountData>): Unit =
      performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfRoomRoomAccountData.insert(_connection, entity)
  }

  public override suspend fun getByTwoKeys(roomId: RoomId, type: String):
      List<RoomRoomAccountData> {
    val _sql: String = "SELECT * FROM RoomAccountData WHERE roomId = ? AND type = ?"
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = RoomIdConverter.to(roomId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _argIndex = 2
        _stmt.bindText(_argIndex, type)
        val _columnIndexOfRoomId: Int = getColumnIndexOrThrow(_stmt, "roomId")
        val _columnIndexOfType: Int = getColumnIndexOrThrow(_stmt, "type")
        val _columnIndexOfKey: Int = getColumnIndexOrThrow(_stmt, "key")
        val _columnIndexOfEvent: Int = getColumnIndexOrThrow(_stmt, "event")
        val _result: MutableList<RoomRoomAccountData> = mutableListOf()
        while (_stmt.step()) {
          val _item: RoomRoomAccountData
          val _tmpRoomId: RoomId
          val _tmp_1: String?
          if (_stmt.isNull(_columnIndexOfRoomId)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getText(_columnIndexOfRoomId)
          }
          val _tmp_2: RoomId? = RoomIdConverter.from(_tmp_1)
          if (_tmp_2 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.RoomId', but it was NULL.")
          } else {
            _tmpRoomId = _tmp_2
          }
          val _tmpType: String
          _tmpType = _stmt.getText(_columnIndexOfType)
          val _tmpKey: String
          _tmpKey = _stmt.getText(_columnIndexOfKey)
          val _tmpEvent: String
          _tmpEvent = _stmt.getText(_columnIndexOfEvent)
          _item = RoomRoomAccountData(_tmpRoomId,_tmpType,_tmpKey,_tmpEvent)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun getByAllKeys(
    roomId: RoomId,
    type: String,
    key: String,
  ): RoomRoomAccountData? {
    val _sql: String =
        "SELECT * FROM RoomAccountData WHERE roomId = ? AND type = ? AND key = ? LIMIT 1"
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = RoomIdConverter.to(roomId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _argIndex = 2
        _stmt.bindText(_argIndex, type)
        _argIndex = 3
        _stmt.bindText(_argIndex, key)
        val _columnIndexOfRoomId: Int = getColumnIndexOrThrow(_stmt, "roomId")
        val _columnIndexOfType: Int = getColumnIndexOrThrow(_stmt, "type")
        val _columnIndexOfKey: Int = getColumnIndexOrThrow(_stmt, "key")
        val _columnIndexOfEvent: Int = getColumnIndexOrThrow(_stmt, "event")
        val _result: RoomRoomAccountData?
        if (_stmt.step()) {
          val _tmpRoomId: RoomId
          val _tmp_1: String?
          if (_stmt.isNull(_columnIndexOfRoomId)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getText(_columnIndexOfRoomId)
          }
          val _tmp_2: RoomId? = RoomIdConverter.from(_tmp_1)
          if (_tmp_2 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.RoomId', but it was NULL.")
          } else {
            _tmpRoomId = _tmp_2
          }
          val _tmpType: String
          _tmpType = _stmt.getText(_columnIndexOfType)
          val _tmpKey: String
          _tmpKey = _stmt.getText(_columnIndexOfKey)
          val _tmpEvent: String
          _tmpEvent = _stmt.getText(_columnIndexOfEvent)
          _result = RoomRoomAccountData(_tmpRoomId,_tmpType,_tmpKey,_tmpEvent)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(roomId: RoomId) {
    val _sql: String = "DELETE FROM RoomAccountData WHERE roomId = ?"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = RoomIdConverter.to(roomId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(roomId: RoomId, type: String) {
    val _sql: String = "DELETE FROM RoomAccountData WHERE roomId = ? AND type = ?"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = RoomIdConverter.to(roomId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _argIndex = 2
        _stmt.bindText(_argIndex, type)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(
    roomId: RoomId,
    type: String,
    key: String,
  ) {
    val _sql: String = "DELETE FROM RoomAccountData WHERE roomId = ? AND type = ? AND key = ?"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = RoomIdConverter.to(roomId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _argIndex = 2
        _stmt.bindText(_argIndex, type)
        _argIndex = 3
        _stmt.bindText(_argIndex, key)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteAll() {
    val _sql: String = "DELETE FROM RoomAccountData"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
