package net.folivo.trixnity.client.store.repository.room

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.reflect.KClass
import net.folivo.trixnity.core.model.UserId

@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class UserPresenceDao_Impl(
  __db: RoomDatabase,
) : UserPresenceDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfRoomUserPresence: EntityInsertAdapter<RoomUserPresence>
  init {
    this.__db = __db
    this.__insertAdapterOfRoomUserPresence = object : EntityInsertAdapter<RoomUserPresence>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `UserPresence` (`userId`,`value`) VALUES (?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: RoomUserPresence) {
        val _tmp: String? = UserIdConverter.to(entity.userId)
        if (_tmp == null) {
          statement.bindNull(1)
        } else {
          statement.bindText(1, _tmp)
        }
        statement.bindText(2, entity.value)
      }
    }
  }

  public override suspend fun insert(entity: RoomUserPresence): Unit = performSuspending(__db,
      false, true) { _connection ->
    __insertAdapterOfRoomUserPresence.insert(_connection, entity)
  }

  public override suspend fun `get`(userId: UserId): RoomUserPresence? {
    val _sql: String = "SELECT * FROM UserPresence WHERE userId = ?  LIMIT 1"
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = UserIdConverter.to(userId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        val _columnIndexOfUserId: Int = getColumnIndexOrThrow(_stmt, "userId")
        val _columnIndexOfValue: Int = getColumnIndexOrThrow(_stmt, "value")
        val _result: RoomUserPresence?
        if (_stmt.step()) {
          val _tmpUserId: UserId
          val _tmp_1: String?
          if (_stmt.isNull(_columnIndexOfUserId)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getText(_columnIndexOfUserId)
          }
          val _tmp_2: UserId? = UserIdConverter.from(_tmp_1)
          if (_tmp_2 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.UserId', but it was NULL.")
          } else {
            _tmpUserId = _tmp_2
          }
          val _tmpValue: String
          _tmpValue = _stmt.getText(_columnIndexOfValue)
          _result = RoomUserPresence(_tmpUserId,_tmpValue)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(userId: UserId) {
    val _sql: String = "DELETE FROM UserPresence WHERE userId = ?"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = UserIdConverter.to(userId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteAll() {
    val _sql: String = "DELETE FROM UserPresence"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
