package net.folivo.trixnity.client.store.repository.room

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.reflect.KClass

@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class SecretsDao_Impl(
  __db: RoomDatabase,
) : SecretsDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfRoomSecrets: EntityInsertAdapter<RoomSecrets>
  init {
    this.__db = __db
    this.__insertAdapterOfRoomSecrets = object : EntityInsertAdapter<RoomSecrets>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `Secrets` (`id`,`value`) VALUES (?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: RoomSecrets) {
        statement.bindLong(1, entity.id)
        statement.bindText(2, entity.value)
      }
    }
  }

  public override suspend fun insert(entity: RoomSecrets): Unit = performSuspending(__db, false,
      true) { _connection ->
    __insertAdapterOfRoomSecrets.insert(_connection, entity)
  }

  public override suspend fun `get`(id: Long): RoomSecrets? {
    val _sql: String = "SELECT * FROM Secrets WHERE id = ? LIMIT 1"
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, id)
        val _columnIndexOfId: Int = getColumnIndexOrThrow(_stmt, "id")
        val _columnIndexOfValue: Int = getColumnIndexOrThrow(_stmt, "value")
        val _result: RoomSecrets?
        if (_stmt.step()) {
          val _tmpId: Long
          _tmpId = _stmt.getLong(_columnIndexOfId)
          val _tmpValue: String
          _tmpValue = _stmt.getText(_columnIndexOfValue)
          _result = RoomSecrets(_tmpId,_tmpValue)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(id: Long) {
    val _sql: String = "DELETE FROM Secrets WHERE id = ?"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, id)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteAll() {
    val _sql: String = "DELETE FROM Secrets"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
