package net.folivo.trixnity.client.store.repository.room

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass

@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class RoomKeyRequestDao_Impl(
  __db: RoomDatabase,
) : RoomKeyRequestDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfRoomRoomKeyRequest: EntityInsertAdapter<RoomRoomKeyRequest>
  init {
    this.__db = __db
    this.__insertAdapterOfRoomRoomKeyRequest = object : EntityInsertAdapter<RoomRoomKeyRequest>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `RoomKeyRequest` (`id`,`value`) VALUES (?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: RoomRoomKeyRequest) {
        statement.bindText(1, entity.id)
        statement.bindText(2, entity.value)
      }
    }
  }

  public override suspend fun insert(entity: RoomRoomKeyRequest): Unit = performSuspending(__db,
      false, true) { _connection ->
    __insertAdapterOfRoomRoomKeyRequest.insert(_connection, entity)
  }

  public override suspend fun `get`(id: String): RoomRoomKeyRequest? {
    val _sql: String = "SELECT * FROM RoomKeyRequest WHERE id = ? LIMIT 1"
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, id)
        val _columnIndexOfId: Int = getColumnIndexOrThrow(_stmt, "id")
        val _columnIndexOfValue: Int = getColumnIndexOrThrow(_stmt, "value")
        val _result: RoomRoomKeyRequest?
        if (_stmt.step()) {
          val _tmpId: String
          _tmpId = _stmt.getText(_columnIndexOfId)
          val _tmpValue: String
          _tmpValue = _stmt.getText(_columnIndexOfValue)
          _result = RoomRoomKeyRequest(_tmpId,_tmpValue)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun getAll(): List<RoomRoomKeyRequest> {
    val _sql: String = "SELECT * FROM RoomKeyRequest"
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        val _columnIndexOfId: Int = getColumnIndexOrThrow(_stmt, "id")
        val _columnIndexOfValue: Int = getColumnIndexOrThrow(_stmt, "value")
        val _result: MutableList<RoomRoomKeyRequest> = mutableListOf()
        while (_stmt.step()) {
          val _item: RoomRoomKeyRequest
          val _tmpId: String
          _tmpId = _stmt.getText(_columnIndexOfId)
          val _tmpValue: String
          _tmpValue = _stmt.getText(_columnIndexOfValue)
          _item = RoomRoomKeyRequest(_tmpId,_tmpValue)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(id: String) {
    val _sql: String = "DELETE FROM RoomKeyRequest WHERE id = ?"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, id)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteAll() {
    val _sql: String = "DELETE FROM RoomKeyRequest"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
