package net.folivo.trixnity.client.store.repository.room

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.reflect.KClass

@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class OutdatedKeysDao_Impl(
  __db: RoomDatabase,
) : OutdatedKeysDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfRoomOutdatedKeys: EntityInsertAdapter<RoomOutdatedKeys>
  init {
    this.__db = __db
    this.__insertAdapterOfRoomOutdatedKeys = object : EntityInsertAdapter<RoomOutdatedKeys>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `OutdatedKeys` (`id`,`value`) VALUES (?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: RoomOutdatedKeys) {
        statement.bindLong(1, entity.id)
        statement.bindText(2, entity.value)
      }
    }
  }

  public override suspend fun insert(entity: RoomOutdatedKeys): Unit = performSuspending(__db,
      false, true) { _connection ->
    __insertAdapterOfRoomOutdatedKeys.insert(_connection, entity)
  }

  public override suspend fun `get`(id: Long): RoomOutdatedKeys? {
    val _sql: String = "SELECT * FROM OutdatedKeys WHERE id = ? LIMIT 1"
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, id)
        val _columnIndexOfId: Int = getColumnIndexOrThrow(_stmt, "id")
        val _columnIndexOfValue: Int = getColumnIndexOrThrow(_stmt, "value")
        val _result: RoomOutdatedKeys?
        if (_stmt.step()) {
          val _tmpId: Long
          _tmpId = _stmt.getLong(_columnIndexOfId)
          val _tmpValue: String
          _tmpValue = _stmt.getText(_columnIndexOfValue)
          _result = RoomOutdatedKeys(_tmpId,_tmpValue)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(id: Long) {
    val _sql: String = "DELETE FROM OutdatedKeys WHERE id = ?"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, id)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteAll() {
    val _sql: String = "DELETE FROM OutdatedKeys"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
