package net.folivo.trixnity.client.store.repository.room

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.appendPlaceholders
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.Set
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import kotlin.text.StringBuilder
import net.folivo.trixnity.core.model.RoomId

@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class RoomStateDao_Impl(
  __db: RoomDatabase,
) : RoomStateDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfRoomRoomState: EntityInsertAdapter<RoomRoomState>
  init {
    this.__db = __db
    this.__insertAdapterOfRoomRoomState = object : EntityInsertAdapter<RoomRoomState>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `RoomState` (`roomId`,`type`,`stateKey`,`event`) VALUES (?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: RoomRoomState) {
        val _tmp: String? = RoomIdConverter.to(entity.roomId)
        if (_tmp == null) {
          statement.bindNull(1)
        } else {
          statement.bindText(1, _tmp)
        }
        statement.bindText(2, entity.type)
        statement.bindText(3, entity.stateKey)
        statement.bindText(4, entity.event)
      }
    }
  }

  public override suspend fun insert(entity: RoomRoomState): Unit = performSuspending(__db, false,
      true) { _connection ->
    __insertAdapterOfRoomRoomState.insert(_connection, entity)
  }

  public override suspend fun insertAll(entities: List<RoomRoomState>): Unit =
      performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfRoomRoomState.insert(_connection, entities)
  }

  public override suspend fun `get`(roomId: RoomId, type: String): List<RoomRoomState> {
    val _sql: String = "SELECT * FROM RoomState WHERE roomId = ? AND type = ?"
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = RoomIdConverter.to(roomId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _argIndex = 2
        _stmt.bindText(_argIndex, type)
        val _columnIndexOfRoomId: Int = getColumnIndexOrThrow(_stmt, "roomId")
        val _columnIndexOfType: Int = getColumnIndexOrThrow(_stmt, "type")
        val _columnIndexOfStateKey: Int = getColumnIndexOrThrow(_stmt, "stateKey")
        val _columnIndexOfEvent: Int = getColumnIndexOrThrow(_stmt, "event")
        val _result: MutableList<RoomRoomState> = mutableListOf()
        while (_stmt.step()) {
          val _item: RoomRoomState
          val _tmpRoomId: RoomId
          val _tmp_1: String?
          if (_stmt.isNull(_columnIndexOfRoomId)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getText(_columnIndexOfRoomId)
          }
          val _tmp_2: RoomId? = RoomIdConverter.from(_tmp_1)
          if (_tmp_2 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.RoomId', but it was NULL.")
          } else {
            _tmpRoomId = _tmp_2
          }
          val _tmpType: String
          _tmpType = _stmt.getText(_columnIndexOfType)
          val _tmpStateKey: String
          _tmpStateKey = _stmt.getText(_columnIndexOfStateKey)
          val _tmpEvent: String
          _tmpEvent = _stmt.getText(_columnIndexOfEvent)
          _item = RoomRoomState(_tmpRoomId,_tmpType,_tmpStateKey,_tmpEvent)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun `get`(
    roomId: RoomId,
    type: String,
    stateKey: String,
  ): RoomRoomState? {
    val _sql: String =
        "SELECT * FROM RoomState WHERE roomId = ? AND type = ? AND stateKey = ? LIMIT 1"
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = RoomIdConverter.to(roomId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _argIndex = 2
        _stmt.bindText(_argIndex, type)
        _argIndex = 3
        _stmt.bindText(_argIndex, stateKey)
        val _columnIndexOfRoomId: Int = getColumnIndexOrThrow(_stmt, "roomId")
        val _columnIndexOfType: Int = getColumnIndexOrThrow(_stmt, "type")
        val _columnIndexOfStateKey: Int = getColumnIndexOrThrow(_stmt, "stateKey")
        val _columnIndexOfEvent: Int = getColumnIndexOrThrow(_stmt, "event")
        val _result: RoomRoomState?
        if (_stmt.step()) {
          val _tmpRoomId: RoomId
          val _tmp_1: String?
          if (_stmt.isNull(_columnIndexOfRoomId)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getText(_columnIndexOfRoomId)
          }
          val _tmp_2: RoomId? = RoomIdConverter.from(_tmp_1)
          if (_tmp_2 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.RoomId', but it was NULL.")
          } else {
            _tmpRoomId = _tmp_2
          }
          val _tmpType: String
          _tmpType = _stmt.getText(_columnIndexOfType)
          val _tmpStateKey: String
          _tmpStateKey = _stmt.getText(_columnIndexOfStateKey)
          val _tmpEvent: String
          _tmpEvent = _stmt.getText(_columnIndexOfEvent)
          _result = RoomRoomState(_tmpRoomId,_tmpType,_tmpStateKey,_tmpEvent)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun `get`(
    roomIds: Set<RoomId>,
    type: String,
    stateKey: String,
  ): List<RoomRoomState> {
    val _stringBuilder: StringBuilder = StringBuilder()
    _stringBuilder.append("SELECT * FROM RoomState WHERE roomId IN (")
    val _inputSize: Int = roomIds.size
    appendPlaceholders(_stringBuilder, _inputSize)
    _stringBuilder.append(") AND type = ")
    _stringBuilder.append("?")
    _stringBuilder.append(" AND stateKey = ")
    _stringBuilder.append("?")
    val _sql: String = _stringBuilder.toString()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        for (_item: RoomId in roomIds) {
          val _tmp: String? = RoomIdConverter.to(_item)
          if (_tmp == null) {
            _stmt.bindNull(_argIndex)
          } else {
            _stmt.bindText(_argIndex, _tmp)
          }
          _argIndex++
        }
        _argIndex = 1 + _inputSize
        _stmt.bindText(_argIndex, type)
        _argIndex = 2 + _inputSize
        _stmt.bindText(_argIndex, stateKey)
        val _columnIndexOfRoomId: Int = getColumnIndexOrThrow(_stmt, "roomId")
        val _columnIndexOfType: Int = getColumnIndexOrThrow(_stmt, "type")
        val _columnIndexOfStateKey: Int = getColumnIndexOrThrow(_stmt, "stateKey")
        val _columnIndexOfEvent: Int = getColumnIndexOrThrow(_stmt, "event")
        val _result: MutableList<RoomRoomState> = mutableListOf()
        while (_stmt.step()) {
          val _item_1: RoomRoomState
          val _tmpRoomId: RoomId
          val _tmp_1: String?
          if (_stmt.isNull(_columnIndexOfRoomId)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getText(_columnIndexOfRoomId)
          }
          val _tmp_2: RoomId? = RoomIdConverter.from(_tmp_1)
          if (_tmp_2 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.RoomId', but it was NULL.")
          } else {
            _tmpRoomId = _tmp_2
          }
          val _tmpType: String
          _tmpType = _stmt.getText(_columnIndexOfType)
          val _tmpStateKey: String
          _tmpStateKey = _stmt.getText(_columnIndexOfStateKey)
          val _tmpEvent: String
          _tmpEvent = _stmt.getText(_columnIndexOfEvent)
          _item_1 = RoomRoomState(_tmpRoomId,_tmpType,_tmpStateKey,_tmpEvent)
          _result.add(_item_1)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(roomId: RoomId) {
    val _sql: String = "DELETE FROM RoomState WHERE roomId = ?"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = RoomIdConverter.to(roomId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(roomId: RoomId, type: String) {
    val _sql: String = "DELETE FROM RoomState WHERE roomId = ? AND type = ?"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = RoomIdConverter.to(roomId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _argIndex = 2
        _stmt.bindText(_argIndex, type)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(
    roomId: RoomId,
    type: String,
    stateKey: String,
  ) {
    val _sql: String = "DELETE FROM RoomState WHERE roomId = ? AND type = ? AND stateKey = ?"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = RoomIdConverter.to(roomId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _argIndex = 2
        _stmt.bindText(_argIndex, type)
        _argIndex = 3
        _stmt.bindText(_argIndex, stateKey)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteAll() {
    val _sql: String = "DELETE FROM RoomState"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
