package net.folivo.trixnity.client.store.repository.room

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import net.folivo.trixnity.core.model.EventId
import net.folivo.trixnity.core.model.RoomId
import net.folivo.trixnity.core.model.events.m.RelationType

@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class TimelineEventRelationDao_Impl(
  __db: RoomDatabase,
) : TimelineEventRelationDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfRoomTimelineEventRelation:
      EntityInsertAdapter<RoomTimelineEventRelation>
  init {
    this.__db = __db
    this.__insertAdapterOfRoomTimelineEventRelation = object :
        EntityInsertAdapter<RoomTimelineEventRelation>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `TimelineEventRelation` (`roomId`,`eventId`,`relationType`,`relatedEventId`) VALUES (?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: RoomTimelineEventRelation) {
        val _tmp: String? = RoomIdConverter.to(entity.roomId)
        if (_tmp == null) {
          statement.bindNull(1)
        } else {
          statement.bindText(1, _tmp)
        }
        val _tmp_1: String? = EventIdConverter.to(entity.eventId)
        if (_tmp_1 == null) {
          statement.bindNull(2)
        } else {
          statement.bindText(2, _tmp_1)
        }
        val _tmp_2: String? = RelationTypeConverter.to(entity.relationType)
        if (_tmp_2 == null) {
          statement.bindNull(3)
        } else {
          statement.bindText(3, _tmp_2)
        }
        val _tmp_3: String? = EventIdConverter.to(entity.relatedEventId)
        if (_tmp_3 == null) {
          statement.bindNull(4)
        } else {
          statement.bindText(4, _tmp_3)
        }
      }
    }
  }

  public override suspend fun insert(entity: RoomTimelineEventRelation): Unit =
      performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfRoomTimelineEventRelation.insert(_connection, entity)
  }

  public override suspend fun insertAll(entities: List<RoomTimelineEventRelation>): Unit =
      performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfRoomTimelineEventRelation.insert(_connection, entities)
  }

  public override suspend fun `get`(
    relatedEventId: EventId,
    roomId: RoomId,
    relationType: RelationType,
  ): List<RoomTimelineEventRelation> {
    val _sql: String = """
        |
        |        SELECT * FROM TimelineEventRelation
        |        WHERE relatedEventId = ?
        |        AND roomId = ?
        |        AND relationType = ?
        |        
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = EventIdConverter.to(relatedEventId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _argIndex = 2
        val _tmp_1: String? = RoomIdConverter.to(roomId)
        if (_tmp_1 == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp_1)
        }
        _argIndex = 3
        val _tmp_2: String? = RelationTypeConverter.to(relationType)
        if (_tmp_2 == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp_2)
        }
        val _columnIndexOfRoomId: Int = getColumnIndexOrThrow(_stmt, "roomId")
        val _columnIndexOfEventId: Int = getColumnIndexOrThrow(_stmt, "eventId")
        val _columnIndexOfRelationType: Int = getColumnIndexOrThrow(_stmt, "relationType")
        val _columnIndexOfRelatedEventId: Int = getColumnIndexOrThrow(_stmt, "relatedEventId")
        val _result: MutableList<RoomTimelineEventRelation> = mutableListOf()
        while (_stmt.step()) {
          val _item: RoomTimelineEventRelation
          val _tmpRoomId: RoomId
          val _tmp_3: String?
          if (_stmt.isNull(_columnIndexOfRoomId)) {
            _tmp_3 = null
          } else {
            _tmp_3 = _stmt.getText(_columnIndexOfRoomId)
          }
          val _tmp_4: RoomId? = RoomIdConverter.from(_tmp_3)
          if (_tmp_4 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.RoomId', but it was NULL.")
          } else {
            _tmpRoomId = _tmp_4
          }
          val _tmpEventId: EventId
          val _tmp_5: String?
          if (_stmt.isNull(_columnIndexOfEventId)) {
            _tmp_5 = null
          } else {
            _tmp_5 = _stmt.getText(_columnIndexOfEventId)
          }
          val _tmp_6: EventId? = EventIdConverter.from(_tmp_5)
          if (_tmp_6 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.EventId', but it was NULL.")
          } else {
            _tmpEventId = _tmp_6
          }
          val _tmpRelationType: RelationType
          val _tmp_7: String?
          if (_stmt.isNull(_columnIndexOfRelationType)) {
            _tmp_7 = null
          } else {
            _tmp_7 = _stmt.getText(_columnIndexOfRelationType)
          }
          val _tmp_8: RelationType? = RelationTypeConverter.from(_tmp_7)
          if (_tmp_8 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.events.m.RelationType', but it was NULL.")
          } else {
            _tmpRelationType = _tmp_8
          }
          val _tmpRelatedEventId: EventId
          val _tmp_9: String?
          if (_stmt.isNull(_columnIndexOfRelatedEventId)) {
            _tmp_9 = null
          } else {
            _tmp_9 = _stmt.getText(_columnIndexOfRelatedEventId)
          }
          val _tmp_10: EventId? = EventIdConverter.from(_tmp_9)
          if (_tmp_10 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.EventId', but it was NULL.")
          } else {
            _tmpRelatedEventId = _tmp_10
          }
          _item =
              RoomTimelineEventRelation(_tmpRoomId,_tmpEventId,_tmpRelationType,_tmpRelatedEventId)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun `get`(
    relatedEventId: EventId,
    roomId: RoomId,
    relationType: RelationType,
    eventId: EventId,
  ): RoomTimelineEventRelation? {
    val _sql: String = """
        |
        |        SELECT * FROM TimelineEventRelation
        |        WHERE relatedEventId = ?
        |        AND roomId = ?
        |        AND relationType = ?
        |        AND eventId = ?
        |        
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = EventIdConverter.to(relatedEventId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _argIndex = 2
        val _tmp_1: String? = RoomIdConverter.to(roomId)
        if (_tmp_1 == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp_1)
        }
        _argIndex = 3
        val _tmp_2: String? = RelationTypeConverter.to(relationType)
        if (_tmp_2 == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp_2)
        }
        _argIndex = 4
        val _tmp_3: String? = EventIdConverter.to(eventId)
        if (_tmp_3 == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp_3)
        }
        val _columnIndexOfRoomId: Int = getColumnIndexOrThrow(_stmt, "roomId")
        val _columnIndexOfEventId: Int = getColumnIndexOrThrow(_stmt, "eventId")
        val _columnIndexOfRelationType: Int = getColumnIndexOrThrow(_stmt, "relationType")
        val _columnIndexOfRelatedEventId: Int = getColumnIndexOrThrow(_stmt, "relatedEventId")
        val _result: RoomTimelineEventRelation?
        if (_stmt.step()) {
          val _tmpRoomId: RoomId
          val _tmp_4: String?
          if (_stmt.isNull(_columnIndexOfRoomId)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getText(_columnIndexOfRoomId)
          }
          val _tmp_5: RoomId? = RoomIdConverter.from(_tmp_4)
          if (_tmp_5 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.RoomId', but it was NULL.")
          } else {
            _tmpRoomId = _tmp_5
          }
          val _tmpEventId: EventId
          val _tmp_6: String?
          if (_stmt.isNull(_columnIndexOfEventId)) {
            _tmp_6 = null
          } else {
            _tmp_6 = _stmt.getText(_columnIndexOfEventId)
          }
          val _tmp_7: EventId? = EventIdConverter.from(_tmp_6)
          if (_tmp_7 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.EventId', but it was NULL.")
          } else {
            _tmpEventId = _tmp_7
          }
          val _tmpRelationType: RelationType
          val _tmp_8: String?
          if (_stmt.isNull(_columnIndexOfRelationType)) {
            _tmp_8 = null
          } else {
            _tmp_8 = _stmt.getText(_columnIndexOfRelationType)
          }
          val _tmp_9: RelationType? = RelationTypeConverter.from(_tmp_8)
          if (_tmp_9 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.events.m.RelationType', but it was NULL.")
          } else {
            _tmpRelationType = _tmp_9
          }
          val _tmpRelatedEventId: EventId
          val _tmp_10: String?
          if (_stmt.isNull(_columnIndexOfRelatedEventId)) {
            _tmp_10 = null
          } else {
            _tmp_10 = _stmt.getText(_columnIndexOfRelatedEventId)
          }
          val _tmp_11: EventId? = EventIdConverter.from(_tmp_10)
          if (_tmp_11 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.EventId', but it was NULL.")
          } else {
            _tmpRelatedEventId = _tmp_11
          }
          _result =
              RoomTimelineEventRelation(_tmpRoomId,_tmpEventId,_tmpRelationType,_tmpRelatedEventId)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(roomId: RoomId) {
    val _sql: String = """
        |
        |        DELETE FROM TimelineEventRelation
        |        WHERE roomId = ?
        |        
        """.trimMargin()
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = RoomIdConverter.to(roomId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(relatedEventId: EventId, roomId: RoomId) {
    val _sql: String = """
        |
        |        DELETE FROM TimelineEventRelation
        |        WHERE relatedEventId = ?
        |        AND roomId = ?
        |        
        """.trimMargin()
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = EventIdConverter.to(relatedEventId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _argIndex = 2
        val _tmp_1: String? = RoomIdConverter.to(roomId)
        if (_tmp_1 == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp_1)
        }
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(
    relatedEventId: EventId,
    roomId: RoomId,
    relationType: RelationType,
    eventId: EventId,
  ) {
    val _sql: String = """
        |
        |        DELETE FROM TimelineEventRelation
        |        WHERE relatedEventId = ?
        |        AND roomId = ?
        |        AND relationType = ?
        |        AND eventId = ?
        |        
        """.trimMargin()
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = EventIdConverter.to(relatedEventId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _argIndex = 2
        val _tmp_1: String? = RoomIdConverter.to(roomId)
        if (_tmp_1 == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp_1)
        }
        _argIndex = 3
        val _tmp_2: String? = RelationTypeConverter.to(relationType)
        if (_tmp_2 == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp_2)
        }
        _argIndex = 4
        val _tmp_3: String? = EventIdConverter.to(eventId)
        if (_tmp_3 == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp_3)
        }
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteAll() {
    val _sql: String = "DELETE FROM TimelineEventRelation"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
