package net.folivo.trixnity.client.store.repository.room

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import net.folivo.trixnity.core.model.RoomId
import net.folivo.trixnity.core.model.UserId

@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class RoomUserReceiptsDao_Impl(
  __db: RoomDatabase,
) : RoomUserReceiptsDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfRoomRoomUserReceipts: EntityInsertAdapter<RoomRoomUserReceipts>
  init {
    this.__db = __db
    this.__insertAdapterOfRoomRoomUserReceipts = object :
        EntityInsertAdapter<RoomRoomUserReceipts>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `RoomUserReceipts` (`userId`,`roomId`,`value`) VALUES (?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: RoomRoomUserReceipts) {
        val _tmp: String? = UserIdConverter.to(entity.userId)
        if (_tmp == null) {
          statement.bindNull(1)
        } else {
          statement.bindText(1, _tmp)
        }
        val _tmp_1: String? = RoomIdConverter.to(entity.roomId)
        if (_tmp_1 == null) {
          statement.bindNull(2)
        } else {
          statement.bindText(2, _tmp_1)
        }
        statement.bindText(3, entity.value)
      }
    }
  }

  public override suspend fun insert(entity: RoomRoomUserReceipts): Unit = performSuspending(__db,
      false, true) { _connection ->
    __insertAdapterOfRoomRoomUserReceipts.insert(_connection, entity)
  }

  public override suspend fun insertAll(entities: List<RoomRoomUserReceipts>): Unit =
      performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfRoomRoomUserReceipts.insert(_connection, entities)
  }

  public override suspend fun `get`(userId: UserId, roomId: RoomId): RoomRoomUserReceipts? {
    val _sql: String = "SELECT * FROM RoomUserReceipts WHERE userId = ? AND roomId = ? LIMIT 1"
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = UserIdConverter.to(userId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _argIndex = 2
        val _tmp_1: String? = RoomIdConverter.to(roomId)
        if (_tmp_1 == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp_1)
        }
        val _columnIndexOfUserId: Int = getColumnIndexOrThrow(_stmt, "userId")
        val _columnIndexOfRoomId: Int = getColumnIndexOrThrow(_stmt, "roomId")
        val _columnIndexOfValue: Int = getColumnIndexOrThrow(_stmt, "value")
        val _result: RoomRoomUserReceipts?
        if (_stmt.step()) {
          val _tmpUserId: UserId
          val _tmp_2: String?
          if (_stmt.isNull(_columnIndexOfUserId)) {
            _tmp_2 = null
          } else {
            _tmp_2 = _stmt.getText(_columnIndexOfUserId)
          }
          val _tmp_3: UserId? = UserIdConverter.from(_tmp_2)
          if (_tmp_3 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.UserId', but it was NULL.")
          } else {
            _tmpUserId = _tmp_3
          }
          val _tmpRoomId: RoomId
          val _tmp_4: String?
          if (_stmt.isNull(_columnIndexOfRoomId)) {
            _tmp_4 = null
          } else {
            _tmp_4 = _stmt.getText(_columnIndexOfRoomId)
          }
          val _tmp_5: RoomId? = RoomIdConverter.from(_tmp_4)
          if (_tmp_5 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.RoomId', but it was NULL.")
          } else {
            _tmpRoomId = _tmp_5
          }
          val _tmpValue: String
          _tmpValue = _stmt.getText(_columnIndexOfValue)
          _result = RoomRoomUserReceipts(_tmpUserId,_tmpRoomId,_tmpValue)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun `get`(roomId: RoomId): List<RoomRoomUserReceipts> {
    val _sql: String = "SELECT * FROM RoomUserReceipts WHERE roomId = ?"
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = RoomIdConverter.to(roomId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        val _columnIndexOfUserId: Int = getColumnIndexOrThrow(_stmt, "userId")
        val _columnIndexOfRoomId: Int = getColumnIndexOrThrow(_stmt, "roomId")
        val _columnIndexOfValue: Int = getColumnIndexOrThrow(_stmt, "value")
        val _result: MutableList<RoomRoomUserReceipts> = mutableListOf()
        while (_stmt.step()) {
          val _item: RoomRoomUserReceipts
          val _tmpUserId: UserId
          val _tmp_1: String?
          if (_stmt.isNull(_columnIndexOfUserId)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getText(_columnIndexOfUserId)
          }
          val _tmp_2: UserId? = UserIdConverter.from(_tmp_1)
          if (_tmp_2 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.UserId', but it was NULL.")
          } else {
            _tmpUserId = _tmp_2
          }
          val _tmpRoomId: RoomId
          val _tmp_3: String?
          if (_stmt.isNull(_columnIndexOfRoomId)) {
            _tmp_3 = null
          } else {
            _tmp_3 = _stmt.getText(_columnIndexOfRoomId)
          }
          val _tmp_4: RoomId? = RoomIdConverter.from(_tmp_3)
          if (_tmp_4 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.RoomId', but it was NULL.")
          } else {
            _tmpRoomId = _tmp_4
          }
          val _tmpValue: String
          _tmpValue = _stmt.getText(_columnIndexOfValue)
          _item = RoomRoomUserReceipts(_tmpUserId,_tmpRoomId,_tmpValue)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(roomId: RoomId) {
    val _sql: String = "DELETE FROM RoomUserReceipts WHERE roomId = ?"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = RoomIdConverter.to(roomId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(roomId: RoomId, userId: UserId) {
    val _sql: String = "DELETE FROM RoomUserReceipts WHERE roomId = ? AND userId = ?"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = RoomIdConverter.to(roomId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _argIndex = 2
        val _tmp_1: String? = UserIdConverter.to(userId)
        if (_tmp_1 == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp_1)
        }
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteAll() {
    val _sql: String = "DELETE FROM RoomUserReceipts"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
