package net.folivo.trixnity.client.store.repository.room

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.reflect.KClass

@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class MediaCacheMappingDao_Impl(
  __db: RoomDatabase,
) : MediaCacheMappingDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfRoomMediaCacheMapping: EntityInsertAdapter<RoomMediaCacheMapping>
  init {
    this.__db = __db
    this.__insertAdapterOfRoomMediaCacheMapping = object :
        EntityInsertAdapter<RoomMediaCacheMapping>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `MediaCacheMapping` (`cacheUri`,`mxcUri`,`size`,`contentType`) VALUES (?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: RoomMediaCacheMapping) {
        statement.bindText(1, entity.cacheUri)
        val _tmpMxcUri: String? = entity.mxcUri
        if (_tmpMxcUri == null) {
          statement.bindNull(2)
        } else {
          statement.bindText(2, _tmpMxcUri)
        }
        statement.bindLong(3, entity.size)
        val _tmpContentType: String? = entity.contentType
        if (_tmpContentType == null) {
          statement.bindNull(4)
        } else {
          statement.bindText(4, _tmpContentType)
        }
      }
    }
  }

  public override suspend fun insert(entity: RoomMediaCacheMapping): Unit = performSuspending(__db,
      false, true) { _connection ->
    __insertAdapterOfRoomMediaCacheMapping.insert(_connection, entity)
  }

  public override suspend fun `get`(cacheUri: String): RoomMediaCacheMapping? {
    val _sql: String = "SELECT * FROM MediaCacheMapping WHERE cacheUri = ? LIMIT 1"
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, cacheUri)
        val _columnIndexOfCacheUri: Int = getColumnIndexOrThrow(_stmt, "cacheUri")
        val _columnIndexOfMxcUri: Int = getColumnIndexOrThrow(_stmt, "mxcUri")
        val _columnIndexOfSize: Int = getColumnIndexOrThrow(_stmt, "size")
        val _columnIndexOfContentType: Int = getColumnIndexOrThrow(_stmt, "contentType")
        val _result: RoomMediaCacheMapping?
        if (_stmt.step()) {
          val _tmpCacheUri: String
          _tmpCacheUri = _stmt.getText(_columnIndexOfCacheUri)
          val _tmpMxcUri: String?
          if (_stmt.isNull(_columnIndexOfMxcUri)) {
            _tmpMxcUri = null
          } else {
            _tmpMxcUri = _stmt.getText(_columnIndexOfMxcUri)
          }
          val _tmpSize: Long
          _tmpSize = _stmt.getLong(_columnIndexOfSize)
          val _tmpContentType: String?
          if (_stmt.isNull(_columnIndexOfContentType)) {
            _tmpContentType = null
          } else {
            _tmpContentType = _stmt.getText(_columnIndexOfContentType)
          }
          _result = RoomMediaCacheMapping(_tmpCacheUri,_tmpMxcUri,_tmpSize,_tmpContentType)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(cacheUri: String) {
    val _sql: String = "DELETE FROM MediaCacheMapping WHERE cacheUri = ?"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, cacheUri)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteAll() {
    val _sql: String = "DELETE FROM MediaCacheMapping"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
