package net.folivo.trixnity.client.store.repository.room

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import kotlin.Boolean
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.reflect.KClass
import net.folivo.trixnity.core.model.UserId

@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class AccountDao_Impl(
  __db: RoomDatabase,
) : AccountDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfRoomAccount: EntityInsertAdapter<RoomAccount>
  init {
    this.__db = __db
    this.__insertAdapterOfRoomAccount = object : EntityInsertAdapter<RoomAccount>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `Account` (`id`,`olmPickleKey`,`baseUrl`,`userId`,`deviceId`,`accessToken`,`refreshToken`,`syncBatchToken`,`filterId`,`backgroundFilterId`,`displayName`,`avatarUrl`,`isLocked`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: RoomAccount) {
        statement.bindLong(1, entity.id)
        val _tmpOlmPickleKey: String? = entity.olmPickleKey
        if (_tmpOlmPickleKey == null) {
          statement.bindNull(2)
        } else {
          statement.bindText(2, _tmpOlmPickleKey)
        }
        val _tmpBaseUrl: String? = entity.baseUrl
        if (_tmpBaseUrl == null) {
          statement.bindNull(3)
        } else {
          statement.bindText(3, _tmpBaseUrl)
        }
        val _tmpUserId: UserId? = entity.userId
        val _tmp: String? = UserIdConverter.to(_tmpUserId)
        if (_tmp == null) {
          statement.bindNull(4)
        } else {
          statement.bindText(4, _tmp)
        }
        val _tmpDeviceId: String? = entity.deviceId
        if (_tmpDeviceId == null) {
          statement.bindNull(5)
        } else {
          statement.bindText(5, _tmpDeviceId)
        }
        val _tmpAccessToken: String? = entity.accessToken
        if (_tmpAccessToken == null) {
          statement.bindNull(6)
        } else {
          statement.bindText(6, _tmpAccessToken)
        }
        val _tmpRefreshToken: String? = entity.refreshToken
        if (_tmpRefreshToken == null) {
          statement.bindNull(7)
        } else {
          statement.bindText(7, _tmpRefreshToken)
        }
        val _tmpSyncBatchToken: String? = entity.syncBatchToken
        if (_tmpSyncBatchToken == null) {
          statement.bindNull(8)
        } else {
          statement.bindText(8, _tmpSyncBatchToken)
        }
        val _tmpFilterId: String? = entity.filterId
        if (_tmpFilterId == null) {
          statement.bindNull(9)
        } else {
          statement.bindText(9, _tmpFilterId)
        }
        val _tmpBackgroundFilterId: String? = entity.backgroundFilterId
        if (_tmpBackgroundFilterId == null) {
          statement.bindNull(10)
        } else {
          statement.bindText(10, _tmpBackgroundFilterId)
        }
        val _tmpDisplayName: String? = entity.displayName
        if (_tmpDisplayName == null) {
          statement.bindNull(11)
        } else {
          statement.bindText(11, _tmpDisplayName)
        }
        val _tmpAvatarUrl: String? = entity.avatarUrl
        if (_tmpAvatarUrl == null) {
          statement.bindNull(12)
        } else {
          statement.bindText(12, _tmpAvatarUrl)
        }
        val _tmp_1: Int = if (entity.isLocked) 1 else 0
        statement.bindLong(13, _tmp_1.toLong())
      }
    }
  }

  public override suspend fun insert(entity: RoomAccount): Unit = performSuspending(__db, false,
      true) { _connection ->
    __insertAdapterOfRoomAccount.insert(_connection, entity)
  }

  public override suspend fun `get`(id: Long): RoomAccount? {
    val _sql: String = "SELECT * FROM Account WHERE id = ? LIMIT 1"
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, id)
        val _columnIndexOfId: Int = getColumnIndexOrThrow(_stmt, "id")
        val _columnIndexOfOlmPickleKey: Int = getColumnIndexOrThrow(_stmt, "olmPickleKey")
        val _columnIndexOfBaseUrl: Int = getColumnIndexOrThrow(_stmt, "baseUrl")
        val _columnIndexOfUserId: Int = getColumnIndexOrThrow(_stmt, "userId")
        val _columnIndexOfDeviceId: Int = getColumnIndexOrThrow(_stmt, "deviceId")
        val _columnIndexOfAccessToken: Int = getColumnIndexOrThrow(_stmt, "accessToken")
        val _columnIndexOfRefreshToken: Int = getColumnIndexOrThrow(_stmt, "refreshToken")
        val _columnIndexOfSyncBatchToken: Int = getColumnIndexOrThrow(_stmt, "syncBatchToken")
        val _columnIndexOfFilterId: Int = getColumnIndexOrThrow(_stmt, "filterId")
        val _columnIndexOfBackgroundFilterId: Int = getColumnIndexOrThrow(_stmt,
            "backgroundFilterId")
        val _columnIndexOfDisplayName: Int = getColumnIndexOrThrow(_stmt, "displayName")
        val _columnIndexOfAvatarUrl: Int = getColumnIndexOrThrow(_stmt, "avatarUrl")
        val _columnIndexOfIsLocked: Int = getColumnIndexOrThrow(_stmt, "isLocked")
        val _result: RoomAccount?
        if (_stmt.step()) {
          val _tmpId: Long
          _tmpId = _stmt.getLong(_columnIndexOfId)
          val _tmpOlmPickleKey: String?
          if (_stmt.isNull(_columnIndexOfOlmPickleKey)) {
            _tmpOlmPickleKey = null
          } else {
            _tmpOlmPickleKey = _stmt.getText(_columnIndexOfOlmPickleKey)
          }
          val _tmpBaseUrl: String?
          if (_stmt.isNull(_columnIndexOfBaseUrl)) {
            _tmpBaseUrl = null
          } else {
            _tmpBaseUrl = _stmt.getText(_columnIndexOfBaseUrl)
          }
          val _tmpUserId: UserId?
          val _tmp: String?
          if (_stmt.isNull(_columnIndexOfUserId)) {
            _tmp = null
          } else {
            _tmp = _stmt.getText(_columnIndexOfUserId)
          }
          _tmpUserId = UserIdConverter.from(_tmp)
          val _tmpDeviceId: String?
          if (_stmt.isNull(_columnIndexOfDeviceId)) {
            _tmpDeviceId = null
          } else {
            _tmpDeviceId = _stmt.getText(_columnIndexOfDeviceId)
          }
          val _tmpAccessToken: String?
          if (_stmt.isNull(_columnIndexOfAccessToken)) {
            _tmpAccessToken = null
          } else {
            _tmpAccessToken = _stmt.getText(_columnIndexOfAccessToken)
          }
          val _tmpRefreshToken: String?
          if (_stmt.isNull(_columnIndexOfRefreshToken)) {
            _tmpRefreshToken = null
          } else {
            _tmpRefreshToken = _stmt.getText(_columnIndexOfRefreshToken)
          }
          val _tmpSyncBatchToken: String?
          if (_stmt.isNull(_columnIndexOfSyncBatchToken)) {
            _tmpSyncBatchToken = null
          } else {
            _tmpSyncBatchToken = _stmt.getText(_columnIndexOfSyncBatchToken)
          }
          val _tmpFilterId: String?
          if (_stmt.isNull(_columnIndexOfFilterId)) {
            _tmpFilterId = null
          } else {
            _tmpFilterId = _stmt.getText(_columnIndexOfFilterId)
          }
          val _tmpBackgroundFilterId: String?
          if (_stmt.isNull(_columnIndexOfBackgroundFilterId)) {
            _tmpBackgroundFilterId = null
          } else {
            _tmpBackgroundFilterId = _stmt.getText(_columnIndexOfBackgroundFilterId)
          }
          val _tmpDisplayName: String?
          if (_stmt.isNull(_columnIndexOfDisplayName)) {
            _tmpDisplayName = null
          } else {
            _tmpDisplayName = _stmt.getText(_columnIndexOfDisplayName)
          }
          val _tmpAvatarUrl: String?
          if (_stmt.isNull(_columnIndexOfAvatarUrl)) {
            _tmpAvatarUrl = null
          } else {
            _tmpAvatarUrl = _stmt.getText(_columnIndexOfAvatarUrl)
          }
          val _tmpIsLocked: Boolean
          val _tmp_1: Int
          _tmp_1 = _stmt.getLong(_columnIndexOfIsLocked).toInt()
          _tmpIsLocked = _tmp_1 != 0
          _result =
              RoomAccount(_tmpId,_tmpOlmPickleKey,_tmpBaseUrl,_tmpUserId,_tmpDeviceId,_tmpAccessToken,_tmpRefreshToken,_tmpSyncBatchToken,_tmpFilterId,_tmpBackgroundFilterId,_tmpDisplayName,_tmpAvatarUrl,_tmpIsLocked)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(id: Long) {
    val _sql: String = "DELETE FROM Account WHERE id = ?"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, id)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteAll() {
    val _sql: String = "DELETE FROM Account"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
