package net.folivo.trixnity.client.store.repository.room

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.reflect.KClass
import kotlinx.datetime.Instant

@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class OlmForgetFallbackKeyAfterDao_Impl(
  __db: RoomDatabase,
) : OlmForgetFallbackKeyAfterDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfRoomOlmForgetFallbackKeyAfter:
      EntityInsertAdapter<RoomOlmForgetFallbackKeyAfter>
  init {
    this.__db = __db
    this.__insertAdapterOfRoomOlmForgetFallbackKeyAfter = object :
        EntityInsertAdapter<RoomOlmForgetFallbackKeyAfter>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `OlmForgetFallbackKeyAfter` (`id`,`instant`) VALUES (?,?)"

      protected override fun bind(statement: SQLiteStatement,
          entity: RoomOlmForgetFallbackKeyAfter) {
        statement.bindLong(1, entity.id)
        val _tmp: Long? = InstantConverter.to(entity.instant)
        if (_tmp == null) {
          statement.bindNull(2)
        } else {
          statement.bindLong(2, _tmp)
        }
      }
    }
  }

  public override suspend fun insert(entity: RoomOlmForgetFallbackKeyAfter): Unit =
      performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfRoomOlmForgetFallbackKeyAfter.insert(_connection, entity)
  }

  public override suspend fun `get`(id: Long): RoomOlmForgetFallbackKeyAfter? {
    val _sql: String = "SELECT * FROM OlmForgetFallbackKeyAfter WHERE id = ? LIMIT 1"
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, id)
        val _columnIndexOfId: Int = getColumnIndexOrThrow(_stmt, "id")
        val _columnIndexOfInstant: Int = getColumnIndexOrThrow(_stmt, "instant")
        val _result: RoomOlmForgetFallbackKeyAfter?
        if (_stmt.step()) {
          val _tmpId: Long
          _tmpId = _stmt.getLong(_columnIndexOfId)
          val _tmpInstant: Instant
          val _tmp: Long?
          if (_stmt.isNull(_columnIndexOfInstant)) {
            _tmp = null
          } else {
            _tmp = _stmt.getLong(_columnIndexOfInstant)
          }
          val _tmp_1: Instant? = InstantConverter.from(_tmp)
          if (_tmp_1 == null) {
            error("Expected NON-NULL 'kotlinx.datetime.Instant', but it was NULL.")
          } else {
            _tmpInstant = _tmp_1
          }
          _result = RoomOlmForgetFallbackKeyAfter(_tmpId,_tmpInstant)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(id: Long) {
    val _sql: String = "DELETE FROM OlmForgetFallbackKeyAfter WHERE id = ?"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, id)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteAll() {
    val _sql: String = "DELETE FROM OlmForgetFallbackKeyAfter"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
