package net.folivo.trixnity.client.store.repository.room

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.getTotalChangedRows
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass
import net.folivo.trixnity.core.model.UserId

@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class KeyChainLinkDao_Impl(
  __db: RoomDatabase,
) : KeyChainLinkDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfRoomKeyChainLink: EntityInsertAdapter<RoomKeyChainLink>
  init {
    this.__db = __db
    this.__insertAdapterOfRoomKeyChainLink = object : EntityInsertAdapter<RoomKeyChainLink>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `KeyChainLink` (`signingUserId`,`signingKeyId`,`signingKeyValue`,`signedUserId`,`signedKeyId`,`signedKeyValue`) VALUES (?,?,?,?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: RoomKeyChainLink) {
        val _tmp: String? = UserIdConverter.to(entity.signingUserId)
        if (_tmp == null) {
          statement.bindNull(1)
        } else {
          statement.bindText(1, _tmp)
        }
        statement.bindText(2, entity.signingKeyId)
        statement.bindText(3, entity.signingKeyValue)
        val _tmp_1: String? = UserIdConverter.to(entity.signedUserId)
        if (_tmp_1 == null) {
          statement.bindNull(4)
        } else {
          statement.bindText(4, _tmp_1)
        }
        statement.bindText(5, entity.signedKeyId)
        statement.bindText(6, entity.signedKeyValue)
      }
    }
  }

  public override suspend fun insert(entity: RoomKeyChainLink): Unit = performSuspending(__db,
      false, true) { _connection ->
    __insertAdapterOfRoomKeyChainLink.insert(_connection, entity)
  }

  public override suspend fun getBySigningKeys(
    signingUserId: UserId,
    signingKeyId: String?,
    signingKeyValue: String,
  ): List<RoomKeyChainLink> {
    val _sql: String = """
        |
        |        SELECT * FROM KeyChainLink
        |        WHERE signingUserId = ?
        |        AND signingKeyId = ?
        |        AND signingKeyValue = ?
        |        
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = UserIdConverter.to(signingUserId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _argIndex = 2
        if (signingKeyId == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, signingKeyId)
        }
        _argIndex = 3
        _stmt.bindText(_argIndex, signingKeyValue)
        val _columnIndexOfSigningUserId: Int = getColumnIndexOrThrow(_stmt, "signingUserId")
        val _columnIndexOfSigningKeyId: Int = getColumnIndexOrThrow(_stmt, "signingKeyId")
        val _columnIndexOfSigningKeyValue: Int = getColumnIndexOrThrow(_stmt, "signingKeyValue")
        val _columnIndexOfSignedUserId: Int = getColumnIndexOrThrow(_stmt, "signedUserId")
        val _columnIndexOfSignedKeyId: Int = getColumnIndexOrThrow(_stmt, "signedKeyId")
        val _columnIndexOfSignedKeyValue: Int = getColumnIndexOrThrow(_stmt, "signedKeyValue")
        val _result: MutableList<RoomKeyChainLink> = mutableListOf()
        while (_stmt.step()) {
          val _item: RoomKeyChainLink
          val _tmpSigningUserId: UserId
          val _tmp_1: String?
          if (_stmt.isNull(_columnIndexOfSigningUserId)) {
            _tmp_1 = null
          } else {
            _tmp_1 = _stmt.getText(_columnIndexOfSigningUserId)
          }
          val _tmp_2: UserId? = UserIdConverter.from(_tmp_1)
          if (_tmp_2 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.UserId', but it was NULL.")
          } else {
            _tmpSigningUserId = _tmp_2
          }
          val _tmpSigningKeyId: String
          _tmpSigningKeyId = _stmt.getText(_columnIndexOfSigningKeyId)
          val _tmpSigningKeyValue: String
          _tmpSigningKeyValue = _stmt.getText(_columnIndexOfSigningKeyValue)
          val _tmpSignedUserId: UserId
          val _tmp_3: String?
          if (_stmt.isNull(_columnIndexOfSignedUserId)) {
            _tmp_3 = null
          } else {
            _tmp_3 = _stmt.getText(_columnIndexOfSignedUserId)
          }
          val _tmp_4: UserId? = UserIdConverter.from(_tmp_3)
          if (_tmp_4 == null) {
            error("Expected NON-NULL 'net.folivo.trixnity.core.model.UserId', but it was NULL.")
          } else {
            _tmpSignedUserId = _tmp_4
          }
          val _tmpSignedKeyId: String
          _tmpSignedKeyId = _stmt.getText(_columnIndexOfSignedKeyId)
          val _tmpSignedKeyValue: String
          _tmpSignedKeyValue = _stmt.getText(_columnIndexOfSignedKeyValue)
          _item =
              RoomKeyChainLink(_tmpSigningUserId,_tmpSigningKeyId,_tmpSigningKeyValue,_tmpSignedUserId,_tmpSignedKeyId,_tmpSignedKeyValue)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(
    signedUserId: UserId,
    signedKeyId: String?,
    signedKeyValue: String,
  ): Int {
    val _sql: String = """
        |
        |        DELETE FROM KeyChainLink
        |        WHERE signedUserId = ?
        |        AND signedKeyId = ?
        |        AND signedKeyValue = ?
        |        
        """.trimMargin()
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        val _tmp: String? = UserIdConverter.to(signedUserId)
        if (_tmp == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, _tmp)
        }
        _argIndex = 2
        if (signedKeyId == null) {
          _stmt.bindNull(_argIndex)
        } else {
          _stmt.bindText(_argIndex, signedKeyId)
        }
        _argIndex = 3
        _stmt.bindText(_argIndex, signedKeyValue)
        _stmt.step()
        getTotalChangedRows(_connection)
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteAll() {
    val _sql: String = "DELETE FROM KeyChainLink"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
