package net.folivo.trixnity.client.store.repository.room

import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass

@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class GlobalAccountDataDao_Impl(
  __db: RoomDatabase,
) : GlobalAccountDataDao {
  private val __db: RoomDatabase

  private val __insertAdapterOfRoomGlobalAccountData: EntityInsertAdapter<RoomGlobalAccountData>
  init {
    this.__db = __db
    this.__insertAdapterOfRoomGlobalAccountData = object :
        EntityInsertAdapter<RoomGlobalAccountData>() {
      protected override fun createQuery(): String =
          "INSERT OR REPLACE INTO `GlobalAccountData` (`type`,`key`,`event`) VALUES (?,?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: RoomGlobalAccountData) {
        statement.bindText(1, entity.type)
        statement.bindText(2, entity.key)
        statement.bindText(3, entity.event)
      }
    }
  }

  public override suspend fun insert(entity: RoomGlobalAccountData): Unit = performSuspending(__db,
      false, true) { _connection ->
    __insertAdapterOfRoomGlobalAccountData.insert(_connection, entity)
  }

  public override suspend fun insertAll(entities: List<RoomGlobalAccountData>): Unit =
      performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfRoomGlobalAccountData.insert(_connection, entities)
  }

  public override suspend fun getAllByType(type: String): List<RoomGlobalAccountData> {
    val _sql: String = "SELECT * FROM GlobalAccountData WHERE type = ?"
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, type)
        val _columnIndexOfType: Int = getColumnIndexOrThrow(_stmt, "type")
        val _columnIndexOfKey: Int = getColumnIndexOrThrow(_stmt, "key")
        val _columnIndexOfEvent: Int = getColumnIndexOrThrow(_stmt, "event")
        val _result: MutableList<RoomGlobalAccountData> = mutableListOf()
        while (_stmt.step()) {
          val _item: RoomGlobalAccountData
          val _tmpType: String
          _tmpType = _stmt.getText(_columnIndexOfType)
          val _tmpKey: String
          _tmpKey = _stmt.getText(_columnIndexOfKey)
          val _tmpEvent: String
          _tmpEvent = _stmt.getText(_columnIndexOfEvent)
          _item = RoomGlobalAccountData(_tmpType,_tmpKey,_tmpEvent)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun getByKeys(type: String, key: String): RoomGlobalAccountData? {
    val _sql: String = "SELECT * FROM GlobalAccountData WHERE type = ? AND key = ? LIMIT 1"
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, type)
        _argIndex = 2
        _stmt.bindText(_argIndex, key)
        val _columnIndexOfType: Int = getColumnIndexOrThrow(_stmt, "type")
        val _columnIndexOfKey: Int = getColumnIndexOrThrow(_stmt, "key")
        val _columnIndexOfEvent: Int = getColumnIndexOrThrow(_stmt, "event")
        val _result: RoomGlobalAccountData?
        if (_stmt.step()) {
          val _tmpType: String
          _tmpType = _stmt.getText(_columnIndexOfType)
          val _tmpKey: String
          _tmpKey = _stmt.getText(_columnIndexOfKey)
          val _tmpEvent: String
          _tmpEvent = _stmt.getText(_columnIndexOfEvent)
          _result = RoomGlobalAccountData(_tmpType,_tmpKey,_tmpEvent)
        } else {
          _result = null
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(type: String) {
    val _sql: String = "DELETE FROM GlobalAccountData WHERE type = ?"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, type)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun delete(type: String, key: String) {
    val _sql: String = "DELETE FROM GlobalAccountData WHERE type = ? AND key = ?"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, type)
        _argIndex = 2
        _stmt.bindText(_argIndex, key)
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun deleteAll() {
    val _sql: String = "DELETE FROM GlobalAccountData"
    return performSuspending(__db, false, true) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        _stmt.step()
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
