/*
 * Decompiled with CFR 0.152.
 */
package net.folivo.matrix.restclient.config;

import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.folivo.matrix.restclient.MatrixClient;
import net.folivo.matrix.restclient.api.sync.InMemorySyncBatchTokenService;
import net.folivo.matrix.restclient.api.sync.SyncBatchTokenService;
import net.folivo.matrix.restclient.config.MatrixClientAutoconfiguration;
import net.folivo.matrix.restclient.config.MatrixClientConfiguration;
import net.folivo.matrix.restclient.config.MatrixClientProperties;
import net.folivo.matrix.restclient.config.WebClientTokenAuthorizationFilter;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.DefaultUriBuilderFactory;

@Configuration
@EnableConfigurationProperties(value={MatrixClientProperties.class})
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J\u001a\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0017J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0017J \u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0017\u00a8\u0006\u0013"}, d2={"Lnet/folivo/matrix/restclient/config/MatrixClientAutoconfiguration;", "", "()V", "inMemorySyncBatchTokenService", "Lnet/folivo/matrix/restclient/api/sync/SyncBatchTokenService;", "matrixClient", "Lnet/folivo/matrix/restclient/MatrixClient;", "matrixWebClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "syncBatchTokenService", "matrixClientConfiguration", "Lnet/folivo/matrix/restclient/config/MatrixClientConfiguration;", "config", "Lnet/folivo/matrix/restclient/config/MatrixClientProperties;", "webClientBuilder", "Lorg/springframework/web/reactive/function/client/WebClient$Builder;", "webClientTokenAuthorizationFilter", "Lnet/folivo/matrix/restclient/config/WebClientTokenAuthorizationFilter;", "Companion", "matrix-spring-boot-rest-client"})
public class MatrixClientAutoconfiguration {
    private static final Logger LOG;
    public static final Companion Companion;

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public MatrixClientConfiguration matrixClientConfiguration(@NotNull MatrixClientProperties config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return new MatrixClientConfiguration(config);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public MatrixClient matrixClient(@Qualifier(value="matrixWebClient") @NotNull WebClient matrixWebClient2, @NotNull SyncBatchTokenService syncBatchTokenService) {
        Intrinsics.checkNotNullParameter((Object)matrixWebClient2, (String)"matrixWebClient");
        Intrinsics.checkNotNullParameter((Object)syncBatchTokenService, (String)"syncBatchTokenService");
        return new MatrixClient(matrixWebClient2, syncBatchTokenService, null, null, null, null, 60, null);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public SyncBatchTokenService inMemorySyncBatchTokenService() {
        LOG.info("you should implement a persistent SyncBatchTokenService if you use the sync api. Currently used: InMemorySyncBatchTokenService");
        return new InMemorySyncBatchTokenService(null, 1, null);
    }

    @Bean
    @NotNull
    public WebClientTokenAuthorizationFilter webClientTokenAuthorizationFilter(@NotNull MatrixClientConfiguration matrixClientConfiguration) {
        Intrinsics.checkNotNullParameter((Object)matrixClientConfiguration, (String)"matrixClientConfiguration");
        return new WebClientTokenAuthorizationFilter(matrixClientConfiguration);
    }

    @Bean(value={"matrixWebClient"})
    @ConditionalOnMissingBean(name={"matrixWebClient"})
    @NotNull
    public WebClient matrixWebClient(@NotNull MatrixClientProperties config, @NotNull WebClient.Builder webClientBuilder, @NotNull WebClientTokenAuthorizationFilter webClientTokenAuthorizationFilter) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)webClientBuilder, (String)"webClientBuilder");
        Intrinsics.checkNotNullParameter((Object)webClientTokenAuthorizationFilter, (String)"webClientTokenAuthorizationFilter");
        WebClient webClient = webClientBuilder.baseUrl(new DefaultUriBuilderFactory().builder().scheme(config.getHomeServer().getSecure() ? "https" : "http").host(config.getHomeServer().getHostname()).port(config.getHomeServer().getPort()).path("/_matrix/client").build(new Object[0]).toASCIIString()).defaultHeader("Content-Type", new String[]{"application/json"}).filter(ExchangeFilterFunction.ofResponseProcessor((Function)matrixWebClient.1.INSTANCE)).filter((ExchangeFilterFunction)webClientTokenAuthorizationFilter).build();
        Intrinsics.checkNotNullExpressionValue((Object)webClient, (String)"webClientBuilder\n       \u2026\n                .build()");
        return webClient;
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(Companion.getClass());
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/folivo/matrix/restclient/config/MatrixClientAutoconfiguration$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "matrix-spring-boot-rest-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

