/*
 * Decompiled with CFR 0.152.
 */
package net.folivo.matrix.core.model;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00162\u00020\u0001:\u0005\u0016\u0017\u0018\u0019\u001aB\u0017\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0012\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u0082\u0001\u0004\u001b\u001c\u001d\u001e\u00a8\u0006\u001f"}, d2={"Lnet/folivo/matrix/core/model/MatrixId;", "", "full", "", "sigilCharacter", "", "(Ljava/lang/String;C)V", "localpart", "domain", "(Ljava/lang/String;Ljava/lang/String;C)V", "getDomain", "()Ljava/lang/String;", "getFull", "getLocalpart", "getSigilCharacter", "()C", "equals", "", "other", "hashCode", "", "toString", "Companion", "EventId", "RoomAliasId", "RoomId", "UserId", "Lnet/folivo/matrix/core/model/MatrixId$UserId;", "Lnet/folivo/matrix/core/model/MatrixId$RoomId;", "Lnet/folivo/matrix/core/model/MatrixId$RoomAliasId;", "Lnet/folivo/matrix/core/model/MatrixId$EventId;", "matrix-spring-boot-core"})
public abstract class MatrixId {
    @NotNull
    private final String full;
    private final char sigilCharacter;
    @NotNull
    private final String localpart;
    @NotNull
    private final String domain;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getFull() {
        return this.full;
    }

    public final char getSigilCharacter() {
        return this.sigilCharacter;
    }

    @NotNull
    public final String getLocalpart() {
        return this.localpart;
    }

    @NotNull
    public final String getDomain() {
        return this.domain;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof MatrixId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)((MatrixId)other).full, (Object)this.full);
    }

    public int hashCode() {
        return this.full.hashCode();
    }

    @NotNull
    public String toString() {
        return this.full;
    }

    private MatrixId(String full, char sigilCharacter) {
        this.full = full;
        this.sigilCharacter = sigilCharacter;
        String s = StringsKt.trimStart((String)full, (char[])new char[]{sigilCharacter});
        this.localpart = StringsKt.substringBefore$default((String)s, (char)':', null, (int)2, null);
        this.domain = StringsKt.substringAfter$default((String)s, (char)':', null, (int)2, null);
        CharSequence charSequence = full;
        boolean bl = false;
        if (charSequence.length() == 0) {
            throw (Throwable)new IllegalArgumentException("matrix identifier must not be empty");
        }
        if (sigilCharacter != StringsKt.first((CharSequence)full)) {
            throw (Throwable)new IllegalArgumentException("given sigil character " + sigilCharacter + " does not match with full string " + full);
        }
        charSequence = this.localpart;
        bl = false;
        if (charSequence.length() == 0) {
            throw (Throwable)new IllegalArgumentException("localpart must not be empty");
        }
        charSequence = this.domain;
        bl = false;
        if (charSequence.length() == 0) {
            throw (Throwable)new IllegalArgumentException("domain must not be empty");
        }
    }

    private MatrixId(String localpart, String domain, char sigilCharacter) {
        this.full = sigilCharacter + localpart + ':' + domain;
        this.sigilCharacter = sigilCharacter;
        this.localpart = localpart;
        this.domain = domain;
    }

    public /* synthetic */ MatrixId(String full, char sigilCharacter, DefaultConstructorMarker $constructor_marker) {
        this(full, sigilCharacter);
    }

    public /* synthetic */ MatrixId(String localpart, String domain, char sigilCharacter, DefaultConstructorMarker $constructor_marker) {
        this(localpart, domain, sigilCharacter);
    }

    @JvmStatic
    @NotNull
    public static final MatrixId of(@NotNull String full) {
        return Companion.of(full);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lnet/folivo/matrix/core/model/MatrixId$UserId;", "Lnet/folivo/matrix/core/model/MatrixId;", "full", "", "(Ljava/lang/String;)V", "localpart", "domain", "(Ljava/lang/String;Ljava/lang/String;)V", "matrix-spring-boot-core"})
    public static final class UserId
    extends MatrixId {
        public UserId(@NotNull String full) {
            Intrinsics.checkNotNullParameter((Object)full, (String)"full");
            super(full, '@', null);
        }

        public UserId(@NotNull String localpart, @NotNull String domain) {
            Intrinsics.checkNotNullParameter((Object)localpart, (String)"localpart");
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            super(localpart, domain, '@', null);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lnet/folivo/matrix/core/model/MatrixId$RoomId;", "Lnet/folivo/matrix/core/model/MatrixId;", "full", "", "(Ljava/lang/String;)V", "localpart", "domain", "(Ljava/lang/String;Ljava/lang/String;)V", "matrix-spring-boot-core"})
    public static final class RoomId
    extends MatrixId {
        public RoomId(@NotNull String full) {
            Intrinsics.checkNotNullParameter((Object)full, (String)"full");
            super(full, '!', null);
        }

        public RoomId(@NotNull String localpart, @NotNull String domain) {
            Intrinsics.checkNotNullParameter((Object)localpart, (String)"localpart");
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            super(localpart, domain, '!', null);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lnet/folivo/matrix/core/model/MatrixId$RoomAliasId;", "Lnet/folivo/matrix/core/model/MatrixId;", "full", "", "(Ljava/lang/String;)V", "localpart", "domain", "(Ljava/lang/String;Ljava/lang/String;)V", "matrix-spring-boot-core"})
    public static final class RoomAliasId
    extends MatrixId {
        public RoomAliasId(@NotNull String full) {
            Intrinsics.checkNotNullParameter((Object)full, (String)"full");
            super(full, '#', null);
        }

        public RoomAliasId(@NotNull String localpart, @NotNull String domain) {
            Intrinsics.checkNotNullParameter((Object)localpart, (String)"localpart");
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            super(localpart, domain, '#', null);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lnet/folivo/matrix/core/model/MatrixId$EventId;", "Lnet/folivo/matrix/core/model/MatrixId;", "full", "", "(Ljava/lang/String;)V", "localpart", "domain", "(Ljava/lang/String;Ljava/lang/String;)V", "matrix-spring-boot-core"})
    public static final class EventId
    extends MatrixId {
        public EventId(@NotNull String full) {
            Intrinsics.checkNotNullParameter((Object)full, (String)"full");
            super(full, '$', null);
        }

        public EventId(@NotNull String localpart, @NotNull String domain) {
            Intrinsics.checkNotNullParameter((Object)localpart, (String)"localpart");
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            super(localpart, domain, '$', null);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lnet/folivo/matrix/core/model/MatrixId$Companion;", "", "()V", "of", "Lnet/folivo/matrix/core/model/MatrixId;", "full", "", "matrix-spring-boot-core"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final MatrixId of(@NotNull String full) {
            MatrixId matrixId;
            Intrinsics.checkNotNullParameter((Object)full, (String)"full");
            CharSequence charSequence = full;
            boolean bl = false;
            if (charSequence.length() == 0) {
                throw (Throwable)new IllegalArgumentException("matrix identifier must not be empty");
            }
            switch (StringsKt.first((CharSequence)full)) {
                case '@': {
                    matrixId = new UserId(full);
                    break;
                }
                case '!': {
                    matrixId = new RoomId(full);
                    break;
                }
                case '#': {
                    matrixId = new RoomAliasId(full);
                    break;
                }
                case '$': {
                    matrixId = new EventId(full);
                    break;
                }
                default: {
                    throw (Throwable)new IllegalArgumentException("not a valid matrix identifier");
                }
            }
            return matrixId;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

