/*
 * Decompiled with CFR 0.152.
 */
package net.folivo.matrix.core.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.folivo.matrix.core.model.MatrixId;
import net.folivo.matrix.core.model.events.RoomEvent;
import net.folivo.matrix.core.model.events.m.room.message.MessageEvent;
import net.folivo.matrix.core.model.events.m.room.message.UnknownMessageEventContent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B!\u0012\u001a\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0004\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\"\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lnet/folivo/matrix/core/jackson/MessageEventTypeDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lnet/folivo/matrix/core/model/events/m/room/message/MessageEvent;", "eventContentTypes", "", "", "Ljava/lang/Class;", "Lnet/folivo/matrix/core/model/events/m/room/message/MessageEvent$MessageEventContent;", "(Ljava/util/Map;)V", "deserialize", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "context", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "matrix-spring-boot-core"})
public final class MessageEventTypeDeserializer
extends JsonDeserializer<MessageEvent<?>> {
    private final Map<String, Class<? extends MessageEvent.MessageEventContent>> eventContentTypes;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public MessageEvent<?> deserialize(@NotNull JsonParser parser, @NotNull DeserializationContext context) {
        MatrixId.RoomId roomId;
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JsonNode jsonNode = context.readTree(parser);
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"context.readTree(parser)");
        JsonNode node = jsonNode;
        JsonNode jsonNode2 = node.get("content");
        String msgtype = jsonNode2 != null && (jsonNode2 = jsonNode2.get("msgtype")) != null ? jsonNode2.asText() : null;
        Map<String, Class<? extends MessageEvent.MessageEventContent>> map = this.eventContentTypes;
        boolean bl = false;
        Class<? extends MessageEvent.MessageEventContent> clazz = map.get(msgtype);
        if (clazz == null) {
            clazz = UnknownMessageEventContent.class;
        }
        Class<? extends MessageEvent.MessageEventContent> javaType = clazz;
        JsonParser contentParser = node.get("content").traverse();
        contentParser.nextToken();
        JsonParser unsignedParser = node.get("unsigned").traverse();
        unsignedParser.nextToken();
        MessageEvent.MessageEventContent messageEventContent = (MessageEvent.MessageEventContent)context.readValue(contentParser, javaType);
        String string = node.get("event_id").asText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.get(\"event_id\").asText()");
        MatrixId.EventId eventId = new MatrixId.EventId(string);
        String string2 = node.get("sender").asText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"node.get(\"sender\").asText()");
        MatrixId.UserId userId = new MatrixId.UserId(string2);
        long l = node.get("origin_server_ts").asLong();
        Object object = node.get("room_id");
        if (object != null && (object = object.asText()) != null) {
            void it;
            Object object2 = object;
            boolean bl2 = false;
            boolean bl3 = false;
            Object object3 = object2;
            long l2 = l;
            MatrixId.UserId userId2 = userId;
            MatrixId.EventId eventId2 = eventId;
            MessageEvent.MessageEventContent messageEventContent2 = messageEventContent;
            boolean bl4 = false;
            MatrixId.RoomId roomId2 = new MatrixId.RoomId((String)it);
            messageEventContent = messageEventContent2;
            eventId = eventId2;
            userId = userId2;
            l = l2;
            roomId = roomId2;
        } else {
            roomId = null;
        }
        Object object4 = context.readValue(unsignedParser, RoomEvent.UnsignedData.class);
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"context.readValue(unsign\u2026UnsignedData::class.java)");
        RoomEvent.UnsignedData unsignedData = (RoomEvent.UnsignedData)object4;
        MatrixId.RoomId roomId3 = roomId;
        long l3 = l;
        MatrixId.UserId userId3 = userId;
        MatrixId.EventId eventId3 = eventId;
        MessageEvent.MessageEventContent messageEventContent3 = messageEventContent;
        return new MessageEvent<MessageEvent.MessageEventContent>(messageEventContent3, eventId3, userId3, l3, roomId3, unsignedData);
    }

    public MessageEventTypeDeserializer(@NotNull Map<String, ? extends Class<? extends MessageEvent.MessageEventContent>> eventContentTypes) {
        Intrinsics.checkNotNullParameter(eventContentTypes, (String)"eventContentTypes");
        this.eventContentTypes = eventContentTypes;
    }
}

