/*
 * Decompiled with CFR 0.152.
 */
package net.folivo.matrix.core.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.folivo.matrix.core.model.events.RoomEvent;
import net.folivo.matrix.core.model.events.m.room.message.MessageEvent;
import net.folivo.matrix.core.model.events.m.room.message.UnknownMessageEventContent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B!\u0012\u001a\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0004\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\"\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lnet/folivo/matrix/core/config/MessageEventTypeDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lnet/folivo/matrix/core/model/events/m/room/message/MessageEvent;", "eventContentTypes", "", "", "Ljava/lang/Class;", "Lnet/folivo/matrix/core/model/events/m/room/message/MessageEvent$MessageEventContent;", "(Ljava/util/Map;)V", "deserialize", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "context", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "matrix-spring-boot-core"})
public final class MessageEventTypeDeserializer
extends JsonDeserializer<MessageEvent<?>> {
    private final Map<String, Class<? extends MessageEvent.MessageEventContent>> eventContentTypes;

    @NotNull
    public MessageEvent<?> deserialize(@NotNull JsonParser parser, @NotNull DeserializationContext context) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JsonNode jsonNode = context.readTree(parser);
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"context.readTree(parser)");
        JsonNode node = jsonNode;
        JsonNode jsonNode2 = node.get("content");
        String msgtype = jsonNode2 != null && (jsonNode2 = jsonNode2.get("msgtype")) != null ? jsonNode2.asText() : null;
        Map<String, Class<? extends MessageEvent.MessageEventContent>> map = this.eventContentTypes;
        boolean bl = false;
        Class<? extends MessageEvent.MessageEventContent> clazz = map.get(msgtype);
        if (clazz == null) {
            clazz = UnknownMessageEventContent.class;
        }
        Class<? extends MessageEvent.MessageEventContent> javaType = clazz;
        JsonParser contentParser = node.get("content").traverse();
        contentParser.nextToken();
        JsonParser unsignedParser = node.get("unsigned").traverse();
        unsignedParser.nextToken();
        MessageEvent.MessageEventContent messageEventContent = (MessageEvent.MessageEventContent)context.readValue(contentParser, javaType);
        String string = node.get("event_id").asText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.get(\"event_id\").asText()");
        String string2 = node.get("sender").asText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"node.get(\"sender\").asText()");
        long l = node.get("origin_server_ts").asLong();
        JsonNode jsonNode3 = node.get("room_id");
        String string3 = jsonNode3 != null ? jsonNode3.asText() : null;
        Object object = context.readValue(unsignedParser, RoomEvent.UnsignedData.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.readValue(unsign\u2026UnsignedData::class.java)");
        return new MessageEvent<MessageEvent.MessageEventContent>(messageEventContent, string, string2, l, string3, (RoomEvent.UnsignedData)object);
    }

    public MessageEventTypeDeserializer(@NotNull Map<String, ? extends Class<? extends MessageEvent.MessageEventContent>> eventContentTypes) {
        Intrinsics.checkNotNullParameter(eventContentTypes, (String)"eventContentTypes");
        this.eventContentTypes = eventContentTypes;
    }
}

