/*
 * Decompiled with CFR 0.152.
 */
package net.folivo.matrix.core.config;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import net.folivo.matrix.core.annotation.MatrixEvent;
import net.folivo.matrix.core.annotation.MatrixMessageEventContent;
import net.folivo.matrix.core.model.events.Event;
import net.folivo.matrix.core.model.events.m.room.message.MessageEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0010\u001a\u00020\u00002\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0002\b\u0014J7\u0010\u0015\u001a\u00020\u00132*\u0010\u0016\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\n0\t0\u0017\"\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\n0\t\u00a2\u0006\u0002\u0010\u0018J/\u0010\u0019\u001a\u00020\u00132\"\u0010\u001a\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\t0\u0017\"\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\t\u00a2\u0006\u0002\u0010\u0018R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\n0\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR%\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u001b"}, d2={"Lnet/folivo/matrix/core/config/MatrixConfiguration;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "registeredEvents", "", "", "Ljava/lang/Class;", "Lnet/folivo/matrix/core/model/events/Event;", "getRegisteredEvents", "()Ljava/util/Map;", "registeredMessageEventContent", "Lnet/folivo/matrix/core/model/events/m/room/message/MessageEvent$MessageEventContent;", "getRegisteredMessageEventContent", "configure", "init", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "registerMatrixEvents", "events", "", "([Ljava/lang/Class;)V", "registerMessageEventContents", "messageEventContents", "matrix-spring-boot-core"})
public final class MatrixConfiguration {
    private final Logger logger = LoggerFactory.getLogger(MatrixConfiguration.class);
    @NotNull
    private final Map<String, Class<? extends Event<?>>> registeredEvents;
    @NotNull
    private final Map<String, Class<? extends MessageEvent.MessageEventContent>> registeredMessageEventContent;

    @NotNull
    public final Map<String, Class<? extends Event<?>>> getRegisteredEvents() {
        return this.registeredEvents;
    }

    @NotNull
    public final Map<String, Class<? extends MessageEvent.MessageEventContent>> getRegisteredMessageEventContent() {
        return this.registeredMessageEventContent;
    }

    @NotNull
    public final MatrixConfiguration configure(@NotNull Function1<? super MatrixConfiguration, Unit> init) {
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        MatrixConfiguration matrixConfiguration = this;
        boolean bl = false;
        boolean bl2 = false;
        init.invoke((Object)matrixConfiguration);
        return matrixConfiguration;
    }

    public final void registerMatrixEvents(Class<? extends Event<?>> ... events) {
        Intrinsics.checkParameterIsNotNull(events, (String)"events");
        Class<? extends Event<?>>[] $this$forEach$iv = events;
        boolean $i$f$forEach = false;
        Class<? extends Event<?>>[] classArray = $this$forEach$iv;
        int n = classArray.length;
        for (int i = 0; i < n; ++i) {
            Class<Event<?>> element$iv;
            Class<Event<?>> it = element$iv = classArray[i];
            boolean bl = false;
            MatrixEvent eventType = (MatrixEvent)AnnotationUtils.findAnnotation(it, MatrixEvent.class);
            if (eventType == null) {
                this.logger.warn(it + " has no " + Reflection.getOrCreateKotlinClass(MatrixEvent.class) + " annotation");
                return;
            }
            this.registeredEvents.put(eventType.type(), it);
            this.logger.debug("registered event type " + eventType.type());
        }
    }

    public final void registerMessageEventContents(Class<? extends MessageEvent.MessageEventContent> ... messageEventContents) {
        Intrinsics.checkParameterIsNotNull(messageEventContents, (String)"messageEventContents");
        Class<? extends MessageEvent.MessageEventContent>[] $this$forEach$iv = messageEventContents;
        boolean $i$f$forEach = false;
        Class<? extends MessageEvent.MessageEventContent>[] classArray = $this$forEach$iv;
        int n = classArray.length;
        for (int i = 0; i < n; ++i) {
            Class<? extends MessageEvent.MessageEventContent> element$iv;
            Class<? extends MessageEvent.MessageEventContent> it = element$iv = classArray[i];
            boolean bl = false;
            MatrixMessageEventContent messageType = (MatrixMessageEventContent)AnnotationUtils.findAnnotation(it, MatrixMessageEventContent.class);
            if (messageType == null) {
                this.logger.warn(it + " has no " + Reflection.getOrCreateKotlinClass(MatrixMessageEventContent.class));
                return;
            }
            this.registeredMessageEventContent.put(messageType.type(), it);
            this.logger.debug("registered message event content type " + messageType.type());
        }
    }

    public MatrixConfiguration() {
        Map map;
        MatrixConfiguration matrixConfiguration = this;
        boolean bl = false;
        matrixConfiguration.registeredEvents = map = (Map)new LinkedHashMap();
        matrixConfiguration = this;
        bl = false;
        matrixConfiguration.registeredMessageEventContent = map = (Map)new LinkedHashMap();
    }
}

