/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.hadoop.fs.Path;

public enum VCFFormat {
    VCF,
    BCF;


    public static VCFFormat inferFromFilePath(Path path) {
        return VCFFormat.inferFromFilePath(path.getName());
    }

    public static VCFFormat inferFromFilePath(String name) {
        if (name.endsWith(".bcf")) {
            return BCF;
        }
        if (name.endsWith(".vcf")) {
            return VCF;
        }
        if (name.endsWith(".gz")) {
            return VCF;
        }
        if (name.endsWith(".bgz")) {
            return VCF;
        }
        return null;
    }

    public static VCFFormat inferFromData(InputStream in) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(in);
        return VCFFormat.inferFromUncompressedData(VCFFormat.isGzip(bis) ? new GZIPInputStream(bis) : bis);
    }

    private static VCFFormat inferFromUncompressedData(InputStream in) throws IOException {
        byte b = (byte)in.read();
        in.close();
        switch (b) {
            case 66: {
                return BCF;
            }
            case 35: {
                return VCF;
            }
        }
        return null;
    }

    public static boolean isGzip(InputStream in) throws IOException {
        in.mark(1);
        byte b = (byte)in.read();
        in.reset();
        return b == 31;
    }
}

