/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.CharacterCodingException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.seqdoop.hadoop_bam.FormatConstants;
import org.seqdoop.hadoop_bam.FormatException;
import org.seqdoop.hadoop_bam.LineReader;
import org.seqdoop.hadoop_bam.SequencedFragment;
import org.seqdoop.hadoop_bam.util.ConfHelper;

public class QseqInputFormat
extends FileInputFormat<Text, SequencedFragment> {
    public static final String CONF_BASE_QUALITY_ENCODING = "hbam.qseq-input.base-quality-encoding";
    public static final String CONF_FILTER_FAILED_QC = "hbam.qseq-input.filter-failed-qc";
    public static final String CONF_BASE_QUALITY_ENCODING_DEFAULT = "illumina";

    public boolean isSplitable(JobContext context, Path path) {
        CompressionCodec codec = new CompressionCodecFactory(context.getConfiguration()).getCodec(path);
        return codec == null;
    }

    public RecordReader<Text, SequencedFragment> createRecordReader(InputSplit genericSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        context.setStatus(genericSplit.toString());
        return new QseqRecordReader(context.getConfiguration(), (FileSplit)genericSplit);
    }

    public static class QseqRecordReader
    extends RecordReader<Text, SequencedFragment> {
        private long start;
        private long end;
        private long pos;
        private Path file;
        private LineReader lineReader;
        private InputStream inputStream;
        private Text currentKey = new Text();
        private SequencedFragment currentValue = new SequencedFragment();
        private Text buffer = new Text();
        private static final int NUM_QSEQ_COLS = 11;
        private int[] fieldPositions = new int[11];
        private int[] fieldLengths = new int[11];
        private FormatConstants.BaseQualityEncoding qualityEncoding;
        private boolean filterFailedQC = false;
        private static final String Delim = "\t";
        public static final int MAX_LINE_LENGTH = 20000;

        public QseqRecordReader(Configuration conf, FileSplit split) throws IOException {
            this.setConf(conf);
            this.file = split.getPath();
            this.start = split.getStart();
            this.end = this.start + split.getLength();
            FileSystem fs = this.file.getFileSystem(conf);
            FSDataInputStream fileIn = fs.open(this.file);
            CompressionCodecFactory codecFactory = new CompressionCodecFactory(conf);
            CompressionCodec codec = codecFactory.getCodec(this.file);
            if (codec == null) {
                this.positionAtFirstRecord(fileIn);
                this.inputStream = fileIn;
            } else {
                if (this.start != 0L) {
                    throw new RuntimeException("Start position for compressed file is not 0! (found " + this.start + ")");
                }
                this.inputStream = codec.createInputStream((InputStream)fileIn);
                this.end = Long.MAX_VALUE;
            }
            this.lineReader = new LineReader(this.inputStream);
        }

        private void positionAtFirstRecord(FSDataInputStream stream) throws IOException {
            if (this.start > 0L) {
                --this.start;
                stream.seek(this.start);
                LineReader reader = new LineReader((InputStream)stream);
                int bytesRead = reader.readLine(this.buffer, (int)Math.min(20000L, this.end - this.start));
                this.start += (long)bytesRead;
                stream.seek(this.start);
            }
            this.pos = this.start;
        }

        protected void setConf(Configuration conf) {
            String encoding = conf.get(QseqInputFormat.CONF_BASE_QUALITY_ENCODING, conf.get("hbam.input.base-quality-encoding", QseqInputFormat.CONF_BASE_QUALITY_ENCODING_DEFAULT));
            if (QseqInputFormat.CONF_BASE_QUALITY_ENCODING_DEFAULT.equals(encoding)) {
                this.qualityEncoding = FormatConstants.BaseQualityEncoding.Illumina;
            } else if ("sanger".equals(encoding)) {
                this.qualityEncoding = FormatConstants.BaseQualityEncoding.Sanger;
            } else {
                throw new RuntimeException("Unknown input base quality encoding value " + encoding);
            }
            this.filterFailedQC = ConfHelper.parseBoolean(conf.get(QseqInputFormat.CONF_FILTER_FAILED_QC, conf.get("hbam.input.filter-failed-qc")), false);
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        }

        public Text getCurrentKey() {
            return this.currentKey;
        }

        public SequencedFragment getCurrentValue() {
            return this.currentValue;
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            return this.next(this.currentKey, this.currentValue);
        }

        public void close() throws IOException {
            this.inputStream.close();
        }

        public Text createKey() {
            return new Text();
        }

        public SequencedFragment createValue() {
            return new SequencedFragment();
        }

        public long getPos() {
            return this.pos;
        }

        public float getProgress() {
            if (this.start == this.end) {
                return 1.0f;
            }
            return Math.min(1.0f, (float)(this.pos - this.start) / (float)(this.end - this.start));
        }

        public String makePositionMessage(long pos) {
            return this.file.toString() + ":" + pos;
        }

        public String makePositionMessage() {
            return this.file.toString() + ":" + this.pos;
        }

        private int lowLevelQseqRead(Text key, SequencedFragment value) throws IOException {
            int bytesRead = this.lineReader.readLine(this.buffer, 20000);
            this.pos += (long)bytesRead;
            if (bytesRead >= 20000) {
                String line;
                try {
                    line = Text.decode((byte[])this.buffer.getBytes(), (int)0, (int)500);
                }
                catch (CharacterCodingException e) {
                    line = "(line not convertible to printable format)";
                }
                throw new RuntimeException("found abnormally large line (length " + bytesRead + ") at " + this.makePositionMessage(this.pos - (long)bytesRead) + ": " + line);
            }
            if (bytesRead > 0) {
                this.scanQseqLine(this.buffer, key, value);
            }
            return bytesRead;
        }

        public boolean next(Text key, SequencedFragment value) throws IOException {
            boolean goodRecord;
            if (this.pos >= this.end) {
                return false;
            }
            int bytesRead = 0;
            do {
                boolean bl = goodRecord = (bytesRead = this.lowLevelQseqRead(key, value)) > 0 && (!this.filterFailedQC || value.getFilterPassed() == null || value.getFilterPassed() != false);
            } while (bytesRead > 0 && !goodRecord);
            if (goodRecord) {
                try {
                    this.postProcessSequencedFragment(value);
                }
                catch (FormatException e) {
                    throw new FormatException(e.getMessage() + " Position: " + this.makePositionMessage(this.pos - (long)bytesRead) + "; line: " + this.buffer);
                }
            }
            return goodRecord;
        }

        private void setFieldPositionsAndLengths(Text line) {
            int fieldno;
            int pos = 0;
            for (fieldno = 0; pos < line.getLength() && fieldno < 11; ++fieldno) {
                int endpos = line.find(Delim, pos);
                if (endpos < 0) {
                    endpos = line.getLength();
                }
                this.fieldPositions[fieldno] = pos;
                this.fieldLengths[fieldno] = endpos - pos;
                pos = endpos + 1;
            }
            if (fieldno != 11) {
                throw new FormatException("found " + fieldno + " fields instead of 11 at " + this.makePositionMessage(this.pos - (long)line.getLength()) + ". Line: " + line);
            }
        }

        private void scanQseqLine(Text line, Text key, SequencedFragment fragment) {
            this.setFieldPositionsAndLengths(line);
            key.clear();
            key.append(line.getBytes(), 0, this.fieldPositions[5] + this.fieldLengths[5]);
            byte[] bytes = key.getBytes();
            int temporaryEnd = key.getLength();
            for (int i = 0; i < temporaryEnd; ++i) {
                if (bytes[i] != 9) continue;
                bytes[i] = 58;
            }
            key.append(line.getBytes(), this.fieldPositions[7] - 1, this.fieldLengths[7] + 1);
            key.getBytes()[temporaryEnd] = 58;
            try {
                fragment.clear();
                fragment.setInstrument(Text.decode((byte[])line.getBytes(), (int)this.fieldPositions[0], (int)this.fieldLengths[0]));
                fragment.setRunNumber(Integer.parseInt(Text.decode((byte[])line.getBytes(), (int)this.fieldPositions[1], (int)this.fieldLengths[1])));
                fragment.setLane(Integer.parseInt(Text.decode((byte[])line.getBytes(), (int)this.fieldPositions[2], (int)this.fieldLengths[2])));
                fragment.setTile(Integer.parseInt(Text.decode((byte[])line.getBytes(), (int)this.fieldPositions[3], (int)this.fieldLengths[3])));
                fragment.setXpos(Integer.parseInt(Text.decode((byte[])line.getBytes(), (int)this.fieldPositions[4], (int)this.fieldLengths[4])));
                fragment.setYpos(Integer.parseInt(Text.decode((byte[])line.getBytes(), (int)this.fieldPositions[5], (int)this.fieldLengths[5])));
                fragment.setRead(Integer.parseInt(Text.decode((byte[])line.getBytes(), (int)this.fieldPositions[7], (int)this.fieldLengths[7])));
                fragment.setFilterPassed(line.getBytes()[this.fieldPositions[10]] != 48);
                if (this.fieldLengths[6] > 0 && line.getBytes()[this.fieldPositions[6]] == 48) {
                    fragment.setIndexSequence(null);
                } else {
                    fragment.setIndexSequence(Text.decode((byte[])line.getBytes(), (int)this.fieldPositions[6], (int)this.fieldLengths[6]).replace('.', 'N'));
                }
            }
            catch (CharacterCodingException e) {
                throw new FormatException("Invalid character format at " + this.makePositionMessage(this.pos - (long)line.getLength()) + "; line: " + line);
            }
            fragment.getSequence().append(line.getBytes(), this.fieldPositions[8], this.fieldLengths[8]);
            fragment.getQuality().append(line.getBytes(), this.fieldPositions[9], this.fieldLengths[9]);
        }

        private void postProcessSequencedFragment(SequencedFragment fragment) {
            byte[] bytes = fragment.getSequence().getBytes();
            for (int i = 0; i < this.fieldLengths[8]; ++i) {
                if (bytes[i] != 46) continue;
                bytes[i] = 78;
            }
            if (this.qualityEncoding == FormatConstants.BaseQualityEncoding.Illumina) {
                SequencedFragment.convertQuality(fragment.getQuality(), FormatConstants.BaseQualityEncoding.Illumina, FormatConstants.BaseQualityEncoding.Sanger);
            } else {
                int outOfRangeElement = SequencedFragment.verifyQuality(fragment.getQuality(), FormatConstants.BaseQualityEncoding.Sanger);
                if (outOfRangeElement >= 0) {
                    throw new FormatException("qseq base quality score out of range for Sanger Phred+33 format (found " + (fragment.getQuality().getBytes()[outOfRangeElement] - 33) + ").\nAlthough Sanger format has been requested, maybe qualities are in Illumina Phred+64 format?\n");
                }
            }
        }
    }
}

