/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.hadoop.io.IOUtils;

class BaseSplitGuesser {
    protected static final int BGZF_MAGIC = 67668767;
    protected static final int BGZF_MAGIC_SUB = 148290;
    protected static final int BGZF_SUB_SIZE = 6;
    protected SeekableStream in;
    protected final ByteBuffer buf = ByteBuffer.allocate(8);

    public BaseSplitGuesser() {
        this.buf.order(ByteOrder.LITTLE_ENDIAN);
    }

    protected PosSize guessNextBGZFPos(int p, int end) {
        try {
            while (true) {
                this.in.seek((long)p);
                IOUtils.readFully((InputStream)this.in, (byte[])this.buf.array(), (int)0, (int)4);
                int n = this.buf.getInt(0);
                if (n != 67668767) {
                    p = n >>> 8 == 559903 ? ++p : (n >>> 16 == 35615 ? (p += 2) : (p += 3));
                    if (p < end) continue;
                    return null;
                }
                int p0 = p;
                this.in.seek((long)(p += 10));
                IOUtils.readFully((InputStream)this.in, (byte[])this.buf.array(), (int)0, (int)2);
                int xlen = this.getUShort(0);
                int subEnd = (p += 2) + xlen;
                while (p < subEnd) {
                    IOUtils.readFully((InputStream)this.in, (byte[])this.buf.array(), (int)0, (int)4);
                    if (this.buf.getInt(0) != 148290) {
                        this.in.seek((long)(p += 4 + this.getUShort(2)));
                        continue;
                    }
                    IOUtils.readFully((InputStream)this.in, (byte[])this.buf.array(), (int)0, (int)2);
                    int bsize = this.getUShort(0);
                    p += 6;
                    while (p < subEnd) {
                        this.in.seek((long)p);
                        IOUtils.readFully((InputStream)this.in, (byte[])this.buf.array(), (int)0, (int)4);
                        p += 4 + this.getUShort(2);
                    }
                    if (p != subEnd) break;
                    this.in.seek((long)(p += bsize - xlen - 19 + 4));
                    IOUtils.readFully((InputStream)this.in, (byte[])this.buf.array(), (int)0, (int)4);
                    return new PosSize(p0, this.buf.getInt(0));
                }
                p = p0 + 4;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    protected int getUShort(int idx) {
        return this.buf.getShort(idx) & 0xFFFF;
    }

    protected static class PosSize {
        public int pos;
        public int size;

        public PosSize(int p, int s) {
            this.pos = p;
            this.size = s;
        }
    }
}

