/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.util.BinaryCodec;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.seqdoop.hadoop_bam.BAMInputFormat;
import org.seqdoop.hadoop_bam.SAMRecordWritable;
import org.seqdoop.hadoop_bam.SplittingBAMIndexer;
import org.seqdoop.hadoop_bam.util.SAMHeaderReader;

public abstract class BAMRecordWriter<K>
extends RecordWriter<K, SAMRecordWritable> {
    private OutputStream origOutput;
    private BinaryCodec binaryCodec;
    private BAMRecordCodec recordCodec;
    private BlockCompressedOutputStream compressedOut;
    private SplittingBAMIndexer splittingBAMIndexer;

    public BAMRecordWriter(Path output, Path input, boolean writeHeader, TaskAttemptContext ctx) throws IOException {
        this.init(output, SAMHeaderReader.readSAMHeaderFrom(input, ctx.getConfiguration()), writeHeader, ctx);
        if (ctx.getConfiguration().getBoolean("hadoopbam.bam.write-splitting-bai", false)) {
            Path splittingIndex = BAMInputFormat.getIdxPath(output);
            FSDataOutputStream splittingIndexOutput = output.getFileSystem(ctx.getConfiguration()).create(splittingIndex);
            this.splittingBAMIndexer = new SplittingBAMIndexer((OutputStream)splittingIndexOutput);
        }
    }

    public BAMRecordWriter(Path output, SAMFileHeader header, boolean writeHeader, TaskAttemptContext ctx) throws IOException {
        this.init((OutputStream)output.getFileSystem(ctx.getConfiguration()).create(output), header, writeHeader);
        if (ctx.getConfiguration().getBoolean("hadoopbam.bam.write-splitting-bai", false)) {
            Path splittingIndex = BAMInputFormat.getIdxPath(output);
            FSDataOutputStream splittingIndexOutput = output.getFileSystem(ctx.getConfiguration()).create(splittingIndex);
            this.splittingBAMIndexer = new SplittingBAMIndexer((OutputStream)splittingIndexOutput);
        }
    }

    public BAMRecordWriter(OutputStream output, SAMFileHeader header, boolean writeHeader) throws IOException {
        this.init(output, header, writeHeader);
    }

    private void init(Path output, SAMFileHeader header, boolean writeHeader, TaskAttemptContext ctx) throws IOException {
        this.init((OutputStream)output.getFileSystem(ctx.getConfiguration()).create(output), header, writeHeader);
    }

    private void init(OutputStream output, SAMFileHeader header, boolean writeHeader) throws IOException {
        this.origOutput = output;
        this.compressedOut = new BlockCompressedOutputStream(this.origOutput, null);
        this.binaryCodec = new BinaryCodec((OutputStream)this.compressedOut);
        this.recordCodec = new BAMRecordCodec(header);
        this.recordCodec.setOutputStream((OutputStream)this.compressedOut);
        if (writeHeader) {
            this.writeHeader(header);
        }
    }

    public void close(TaskAttemptContext ctx) throws IOException {
        this.binaryCodec.getOutputStream().flush();
        if (this.splittingBAMIndexer != null) {
            this.splittingBAMIndexer.finish(this.compressedOut.getFilePointer() >> 16);
        }
        this.origOutput.close();
    }

    protected void writeAlignment(SAMRecord rec) throws IOException {
        if (this.splittingBAMIndexer != null) {
            this.splittingBAMIndexer.processAlignment(this.compressedOut.getFilePointer());
        }
        this.recordCodec.encode(rec);
    }

    private void writeHeader(SAMFileHeader header) {
        this.binaryCodec.writeBytes("BAM\u0001".getBytes(Charset.forName("UTF8")));
        StringWriter sw = new StringWriter();
        new SAMTextHeaderCodec().encode((Writer)sw, header);
        this.binaryCodec.writeString(((Object)sw).toString(), true, false);
        SAMSequenceDictionary dict = header.getSequenceDictionary();
        this.binaryCodec.writeInt(dict.size());
        for (SAMSequenceRecord rec : dict.getSequences()) {
            this.binaryCodec.writeString(rec.getSequenceName(), true, true);
            this.binaryCodec.writeInt(rec.getSequenceLength());
        }
    }
}

