/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import htsjdk.samtools.BAMFileReader;
import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSpan;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamFiles;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.Interval;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.seqdoop.hadoop_bam.BAMInputFormat;
import org.seqdoop.hadoop_bam.FileVirtualSplit;
import org.seqdoop.hadoop_bam.SAMRecordWritable;
import org.seqdoop.hadoop_bam.util.MurmurHash3;
import org.seqdoop.hadoop_bam.util.NIOFileUtil;
import org.seqdoop.hadoop_bam.util.SAMHeaderReader;
import org.seqdoop.hadoop_bam.util.WrapSeekable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BAMRecordReader
extends RecordReader<LongWritable, SAMRecordWritable> {
    private static final Logger logger = LoggerFactory.getLogger(BAMRecordReader.class);
    private final LongWritable key = new LongWritable();
    private final SAMRecordWritable record = new SAMRecordWritable();
    private BAMFileReader bamFileReader;
    private CloseableIterator<SAMRecord> iterator;
    private boolean reachedEnd;
    private WrapSeekable<FSDataInputStream> in;
    private long fileStart;
    private long virtualEnd;
    private boolean isInitialized = false;

    public static long getKey(SAMRecord rec) {
        int refIdx = rec.getReferenceIndex();
        int start = rec.getAlignmentStart();
        if (!rec.getReadUnmappedFlag() && refIdx >= 0 && start >= 0) {
            return BAMRecordReader.getKey(refIdx, start);
        }
        int hash = 0;
        byte[] var = rec.getVariableBinaryRepresentation();
        if (var != null) {
            hash = (int)MurmurHash3.murmurhash3(var, hash);
        } else {
            hash = (int)MurmurHash3.murmurhash3(rec.getReadName(), hash);
            hash = (int)MurmurHash3.murmurhash3(rec.getReadBases(), hash);
            hash = (int)MurmurHash3.murmurhash3(rec.getBaseQualities(), hash);
            hash = (int)MurmurHash3.murmurhash3(rec.getCigarString(), hash);
        }
        return BAMRecordReader.getKey0(Integer.MAX_VALUE, hash);
    }

    public static long getKey(int refIdx, int alignmentStart) {
        return BAMRecordReader.getKey0(refIdx, alignmentStart - 1);
    }

    public static long getKey0(int refIdx, int alignmentStart0) {
        return (long)refIdx << 32 | (long)alignmentStart0;
    }

    public void initialize(InputSplit spl, TaskAttemptContext ctx) throws IOException {
        if (this.isInitialized) {
            this.close();
        }
        this.isInitialized = true;
        this.reachedEnd = false;
        Configuration conf = ctx.getConfiguration();
        FileVirtualSplit split = (FileVirtualSplit)spl;
        Path file = split.getPath();
        FileSystem fs = file.getFileSystem(conf);
        ValidationStringency stringency = SAMHeaderReader.getValidationStringency(conf);
        java.nio.file.Path index = SamFiles.findIndex((java.nio.file.Path)NIOFileUtil.asPath(fs.makeQualified(file).toUri()));
        Path fileIndex = index == null ? null : new Path(index.toUri());
        WrapSeekable<FSDataInputStream> indexStream = fileIndex == null ? null : WrapSeekable.openPath(fs, fileIndex);
        this.in = WrapSeekable.openPath(fs, file);
        SamReader samReader = this.createSamReader(this.in, indexStream, stringency);
        SAMFileHeader header = samReader.getFileHeader();
        long virtualStart = split.getStartVirtualOffset();
        this.fileStart = virtualStart >>> 16;
        this.virtualEnd = split.getEndVirtualOffset();
        SamReader.PrimitiveSamReader primitiveSamReader = ((SamReader.PrimitiveSamReaderToSamReaderAdapter)samReader).underlyingReader();
        this.bamFileReader = (BAMFileReader)primitiveSamReader;
        if (logger.isDebugEnabled()) {
            long recordStart = virtualStart & 0xFFFFL;
            logger.debug("Initialized BAMRecordReader; byte offset: {}, record offset: {}", (Object)this.fileStart, (Object)recordStart);
        }
        if (conf.getBoolean("hadoopbam.bam.keep-paired-reads-together", false)) {
            throw new IllegalArgumentException("Property hadoopbam.bam.keep-paired-reads-together is no longer honored.");
        }
        boolean boundedTraversal = BAMInputFormat.isBoundedTraversal(conf);
        if (boundedTraversal && split.getIntervalFilePointers() != null) {
            List<Interval> intervals = BAMInputFormat.getIntervals(conf);
            QueryInterval[] queryIntervals = BAMInputFormat.prepareQueryIntervals(intervals, header.getSequenceDictionary());
            this.iterator = this.bamFileReader.createIndexIterator(queryIntervals, false, split.getIntervalFilePointers());
        } else if (boundedTraversal && split.getIntervalFilePointers() == null) {
            this.iterator = this.bamFileReader.queryUnmapped();
        } else {
            BAMFileSpan splitSpan = new BAMFileSpan(new Chunk(virtualStart, this.virtualEnd));
            this.iterator = this.bamFileReader.getIterator((SAMFileSpan)splitSpan);
        }
    }

    private SamReader createSamReader(SeekableStream in, SeekableStream inIndex, ValidationStringency stringency) {
        SamReaderFactory readerFactory = SamReaderFactory.makeDefault().setOption(SamReaderFactory.Option.CACHE_FILE_BASED_INDEXES, true).setOption(SamReaderFactory.Option.EAGERLY_DECODE, false).setUseAsyncIo(false);
        if (stringency != null) {
            readerFactory.validationStringency(stringency);
        }
        SamInputResource resource = SamInputResource.of((SeekableStream)in);
        if (inIndex != null) {
            resource.index(inIndex);
        }
        return readerFactory.open(resource);
    }

    public void close() throws IOException {
        this.bamFileReader.close();
    }

    public float getProgress() throws IOException {
        if (this.reachedEnd) {
            return 1.0f;
        }
        long filePos = this.in.position();
        long fileEnd = this.virtualEnd >>> 16;
        return (float)(filePos - this.fileStart) / (float)(fileEnd - this.fileStart + 1L);
    }

    public LongWritable getCurrentKey() {
        return this.key;
    }

    public SAMRecordWritable getCurrentValue() {
        return this.record;
    }

    public boolean nextKeyValue() {
        if (!this.iterator.hasNext()) {
            this.reachedEnd = true;
            return false;
        }
        SAMRecord r = (SAMRecord)this.iterator.next();
        this.key.set(BAMRecordReader.getKey(r));
        this.record.set(r);
        return true;
    }
}

