/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import com.google.common.collect.ImmutableList;
import htsjdk.samtools.AbstractBAMFileIndex;
import htsjdk.samtools.BAMFileReader;
import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.BAMIndex;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.LinearBAMIndex;
import htsjdk.samtools.LinearIndex;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSpan;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.Locatable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.ProviderNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.seqdoop.hadoop_bam.BAMRecordReader;
import org.seqdoop.hadoop_bam.BAMSplitGuesser;
import org.seqdoop.hadoop_bam.FileVirtualSplit;
import org.seqdoop.hadoop_bam.SAMRecordWritable;
import org.seqdoop.hadoop_bam.SplittingBAMIndex;
import org.seqdoop.hadoop_bam.util.NIOFileUtil;
import org.seqdoop.hadoop_bam.util.SAMHeaderReader;
import org.seqdoop.hadoop_bam.util.WrapSeekable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BAMInputFormat
extends FileInputFormat<LongWritable, SAMRecordWritable> {
    private static final Logger logger = LoggerFactory.getLogger(BAMInputFormat.class);
    public static final String BOUNDED_TRAVERSAL_PROPERTY = "hadoopbam.bam.bounded-traversal";
    public static final String ENABLE_BAI_SPLIT_CALCULATOR = "hadoopbam.bam.enable-bai-splitter";
    public static final String INTERVALS_PROPERTY = "hadoopbam.bam.intervals";
    public static final String TRAVERSE_UNPLACED_UNMAPPED_PROPERTY = "hadoopbam.bam.traverse-unplaced-unmapped";

    public static <T extends Locatable> void setIntervals(Configuration conf, List<T> intervals) {
        BAMInputFormat.setTraversalParameters(conf, intervals, false);
    }

    public static void setEnableBAISplitCalculator(Configuration conf, boolean setEnabled) {
        conf.setBoolean(ENABLE_BAI_SPLIT_CALCULATOR, setEnabled);
    }

    public static <T extends Locatable> void setTraversalParameters(Configuration conf, List<T> intervals, boolean traverseUnplacedUnmapped) {
        if (intervals == null && !traverseUnplacedUnmapped) {
            throw new IllegalArgumentException("Traversing mapped reads only is not supported.");
        }
        conf.setBoolean(BOUNDED_TRAVERSAL_PROPERTY, true);
        if (intervals != null) {
            StringBuilder sb = new StringBuilder();
            Iterator<T> it = intervals.iterator();
            while (it.hasNext()) {
                Locatable l = (Locatable)it.next();
                sb.append(String.format("%s:%d-%d", l.getContig(), l.getStart(), l.getEnd()));
                if (!it.hasNext()) continue;
                sb.append(",");
            }
            conf.set(INTERVALS_PROPERTY, sb.toString());
        }
        conf.setBoolean(TRAVERSE_UNPLACED_UNMAPPED_PROPERTY, traverseUnplacedUnmapped);
    }

    public static void unsetTraversalParameters(Configuration conf) {
        conf.unset(BOUNDED_TRAVERSAL_PROPERTY);
        conf.unset(INTERVALS_PROPERTY);
        conf.unset(TRAVERSE_UNPLACED_UNMAPPED_PROPERTY);
    }

    static boolean isBoundedTraversal(Configuration conf) {
        return conf.getBoolean(BOUNDED_TRAVERSAL_PROPERTY, false) || conf.get(INTERVALS_PROPERTY) != null;
    }

    static boolean traverseUnplacedUnmapped(Configuration conf) {
        return conf.getBoolean(TRAVERSE_UNPLACED_UNMAPPED_PROPERTY, false);
    }

    static List<Interval> getIntervals(Configuration conf) {
        String intervalsProperty = conf.get(INTERVALS_PROPERTY);
        if (intervalsProperty == null) {
            return null;
        }
        if (intervalsProperty.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        for (String s : intervalsProperty.split(",")) {
            String[] parts = s.split(":|-");
            Interval interval = new Interval(parts[0], Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
            intervals.add(interval);
        }
        return intervals;
    }

    static Path getIdxPath(Path path) {
        return path.suffix(".splitting-bai");
    }

    static List<InputSplit> removeIndexFiles(List<InputSplit> splits) {
        return splits.stream().filter(split -> !((FileSplit)split).getPath().getName().endsWith(".splitting-bai")).filter(split -> !((FileSplit)split).getPath().getName().endsWith(".bai")).collect(Collectors.toList());
    }

    static Path getBAIPath(Path path) {
        return path.suffix(".bai");
    }

    public RecordReader<LongWritable, SAMRecordWritable> createRecordReader(InputSplit split, TaskAttemptContext ctx) throws InterruptedException, IOException {
        BAMRecordReader rr = new BAMRecordReader();
        rr.initialize(split, ctx);
        return rr;
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        return this.getSplits(super.getSplits(job), job.getConfiguration());
    }

    public List<InputSplit> getSplits(List<InputSplit> splits, Configuration cfg) throws IOException {
        List<InputSplit> origSplits = BAMInputFormat.removeIndexFiles(splits);
        Collections.sort(origSplits, new Comparator<InputSplit>(){

            @Override
            public int compare(InputSplit a, InputSplit b) {
                FileSplit fa = (FileSplit)a;
                FileSplit fb = (FileSplit)b;
                return fa.getPath().compareTo((Object)fb.getPath());
            }
        });
        ArrayList<InputSplit> newSplits = new ArrayList<InputSplit>(origSplits.size());
        int i = 0;
        while (i < origSplits.size()) {
            try {
                i = this.addIndexedSplits(origSplits, i, newSplits, cfg);
            }
            catch (IOException | ProviderNotFoundException e) {
                if (cfg.getBoolean(ENABLE_BAI_SPLIT_CALCULATOR, false)) {
                    try {
                        i = this.addBAISplits(origSplits, i, newSplits, cfg);
                    }
                    catch (IOException | ProviderNotFoundException e2) {
                        i = this.addProbabilisticSplits(origSplits, i, newSplits, cfg);
                    }
                    continue;
                }
                i = this.addProbabilisticSplits(origSplits, i, newSplits, cfg);
            }
        }
        return this.filterByInterval(newSplits, cfg);
    }

    private int addIndexedSplits(List<InputSplit> splits, int i, List<InputSplit> newSplits, Configuration cfg) throws IOException {
        int j;
        Path file = ((FileSplit)splits.get(i)).getPath();
        ArrayList<FileVirtualSplit> potentialSplits = new ArrayList<FileVirtualSplit>();
        SplittingBAMIndex idx = new SplittingBAMIndex((InputStream)file.getFileSystem(cfg).open(BAMInputFormat.getIdxPath(file)));
        int splitsEnd = splits.size();
        for (j = i; j < splitsEnd; ++j) {
            if (file.equals((Object)((FileSplit)splits.get(j)).getPath())) continue;
            splitsEnd = j;
        }
        if (idx.size() == 1) {
            return splitsEnd;
        }
        for (j = i; j < splitsEnd; ++j) {
            FileSplit fileSplit = (FileSplit)splits.get(j);
            long start = fileSplit.getStart();
            long end = start + fileSplit.getLength();
            Long blockStart = idx.nextAlignment(start);
            Long blockEnd = j == splitsEnd - 1 ? Long.valueOf(idx.prevAlignment(end) | 0xFFFFL) : idx.nextAlignment(end);
            if (blockStart == null || blockEnd == null) {
                logger.warn("Index for {} was not good. Generating probabilistic splits.", (Object)file);
                return this.addProbabilisticSplits(splits, i, newSplits, cfg);
            }
            potentialSplits.add(new FileVirtualSplit(file, blockStart, blockEnd, fileSplit.getLocations()));
        }
        for (InputSplit inputSplit : potentialSplits) {
            newSplits.add(inputSplit);
        }
        return splitsEnd;
    }

    private int addBAISplits(List<InputSplit> splits, int i, List<InputSplit> newSplits, Configuration conf) throws IOException {
        Path path = ((FileSplit)splits.get(i)).getPath();
        FileSystem fs = path.getFileSystem(conf);
        int splitsEnd = i;
        try (FSDataInputStream in = fs.open(path);){
            long fSplitEnd;
            FileSplit fSplit;
            LinearIndex linIdx;
            int ctgBins;
            SAMFileHeader header = SAMHeaderReader.readSAMHeaderFrom((InputStream)in, conf);
            SAMSequenceDictionary dict = header.getSequenceDictionary();
            WrapSeekable<FSDataInputStream> guesserSin = WrapSeekable.openPath(fs, path);
            BAMSplitGuesser guesser = new BAMSplitGuesser(guesserSin, conf);
            WrapSeekable<FSDataInputStream> sin = fs.exists(BAMInputFormat.getBAIPath(path)) ? WrapSeekable.openPath(fs, BAMInputFormat.getBAIPath(path)) : WrapSeekable.openPath(fs, new Path(path.toString().replaceFirst("\\.bam$", ".bai")));
            LinearBAMIndex idx = new LinearBAMIndex(sin, dict);
            int ctgIdx = -1;
            int bin = 0;
            long lastStart = 0L;
            while ((ctgBins = (linIdx = idx.getLinearIndex(++ctgIdx)).size()) == 0) {
            }
            long nextStart = linIdx.get(bin);
            FileVirtualSplit newSplit = null;
            boolean lastWasGuessed = false;
            while (splitsEnd < splits.size() && ((FileSplit)splits.get(splitsEnd)).getPath() == path) {
                fSplit = (FileSplit)splits.get(splitsEnd);
                if (++splitsEnd >= splits.size()) break;
                fSplitEnd = fSplit.getStart() + fSplit.getLength() << 16;
                lastStart = nextStart;
                while (nextStart < fSplitEnd && ctgIdx < dict.size()) {
                    if (bin + 1 >= ctgBins) {
                        do {
                            bin = 0;
                        } while (++ctgIdx < dict.size() && (ctgBins = (linIdx = idx.getLinearIndex(ctgIdx)).size()) == 0);
                    }
                    if (ctgIdx >= dict.size() || linIdx.size() <= bin) continue;
                    nextStart = linIdx.get(bin);
                    ++bin;
                }
                if (fSplit.getStart() == 0L) {
                    WrapSeekable<FSDataInputStream> inFile = WrapSeekable.openPath(path.getFileSystem(conf), path);
                    SamReader open = SamReaderFactory.makeDefault().setUseAsyncIo(false).open(SamInputResource.of(inFile));
                    SAMFileSpan span = open.indexing().getFilePointerSpanningReads();
                    long bamStart = ((BAMFileSpan)span).getFirstOffset();
                    newSplit = new FileVirtualSplit(fSplit.getPath(), bamStart, nextStart - 1L, fSplit.getLocations());
                    newSplits.add(newSplit);
                } else if (lastStart != nextStart) {
                    if (lastWasGuessed) {
                        newSplit.setEndVirtualOffset(lastStart - 1L);
                        lastWasGuessed = false;
                    }
                    newSplit = new FileVirtualSplit(fSplit.getPath(), lastStart, nextStart - 1L, fSplit.getLocations());
                    newSplits.add(newSplit);
                } else {
                    long alignedBeg = guesser.guessNextBAMRecordStart(fSplit.getStart(), fSplit.getStart() + fSplit.getLength());
                    newSplit.setEndVirtualOffset(alignedBeg - 1L);
                    lastStart = alignedBeg;
                    nextStart = alignedBeg;
                    newSplit = new FileVirtualSplit(fSplit.getPath(), alignedBeg, alignedBeg + 1L, fSplit.getLocations());
                    lastWasGuessed = true;
                    newSplits.add(newSplit);
                }
                lastStart = nextStart;
            }
            if (splitsEnd == splits.size()) {
                if (lastWasGuessed) {
                    newSplit.setEndVirtualOffset(lastStart - 1L);
                    lastWasGuessed = false;
                }
                fSplit = (FileSplit)splits.get(splitsEnd - 1);
                fSplitEnd = fSplit.getStart() + fSplit.getLength() << 16;
                newSplit = new FileVirtualSplit(fSplit.getPath(), lastStart, fSplitEnd, fSplit.getLocations());
                newSplits.add(newSplit);
            }
        }
        return splitsEnd + 1;
    }

    private int addProbabilisticSplits(List<InputSplit> splits, int i, List<InputSplit> newSplits, Configuration cfg) throws IOException {
        FileSplit fspl;
        Path path = ((FileSplit)splits.get(i)).getPath();
        WrapSeekable<FSDataInputStream> sin = WrapSeekable.openPath(path.getFileSystem(cfg), path);
        BAMSplitGuesser guesser = new BAMSplitGuesser(sin, cfg);
        FileVirtualSplit previousSplit = null;
        while (i < splits.size() && (fspl = (FileSplit)splits.get(i)).getPath().equals((Object)path)) {
            long beg = fspl.getStart();
            long end = beg + fspl.getLength();
            long alignedBeg = guesser.guessNextBAMRecordStart(beg, end);
            long alignedEnd = end << 16 | 0xFFFFL;
            if (alignedBeg == end) {
                if (previousSplit == null) {
                    throw new IOException("'" + path + "': no reads in first split: bad BAM file or tiny split size?");
                }
                previousSplit.setEndVirtualOffset(alignedEnd);
            } else {
                previousSplit = new FileVirtualSplit(path, alignedBeg, alignedEnd, fspl.getLocations());
                if (logger.isDebugEnabled()) {
                    long byteOffset = alignedBeg >>> 16;
                    long recordOffset = alignedBeg & 0xFFFFL;
                    logger.debug("Split {}: byte offset: {} record offset: {}, virtual offset: {}", new Object[]{i, byteOffset, recordOffset, alignedBeg});
                }
                newSplits.add(previousSplit);
            }
            ++i;
        }
        sin.close();
        return i;
    }

    private List<InputSplit> filterByInterval(List<InputSplit> splits, Configuration conf) throws IOException {
        if (!BAMInputFormat.isBoundedTraversal(conf)) {
            return splits;
        }
        LinkedHashSet<Path> bamFiles = new LinkedHashSet<Path>();
        for (InputSplit split : splits) {
            bamFiles.add(((FileVirtualSplit)split).getPath());
        }
        LinkedHashMap<Path, BAMFileSpan> fileToSpan = new LinkedHashMap<Path, BAMFileSpan>();
        SamReaderFactory readerFactory = SamReaderFactory.makeDefault().setOption(SamReaderFactory.Option.CACHE_FILE_BASED_INDEXES, true).setOption(SamReaderFactory.Option.EAGERLY_DECODE, false).setUseAsyncIo(false);
        List<Interval> intervals = BAMInputFormat.getIntervals(conf);
        LinkedHashMap<Path, Long> fileToUnmapped = new LinkedHashMap<Path, Long>();
        boolean traverseUnplacedUnmapped = BAMInputFormat.traverseUnplacedUnmapped(conf);
        for (Path bamFile : bamFiles) {
            FileSystem fileSystem = bamFile.getFileSystem(conf);
            SamReader samReader = readerFactory.open(NIOFileUtil.asPath(fileSystem.makeQualified(bamFile).toUri()));
            Throwable throwable = null;
            try {
                if (!samReader.hasIndex()) {
                    throw new IllegalArgumentException("Intervals set but no BAM index file found for " + bamFile);
                }
                FSDataInputStream in = fileSystem.open(bamFile);
                Throwable throwable2 = null;
                try {
                    SAMFileHeader header = SAMHeaderReader.readSAMHeaderFrom((InputStream)in, conf);
                    SAMSequenceDictionary dict = header.getSequenceDictionary();
                    BAMIndex idx = samReader.indexing().getIndex();
                    if (intervals != null && !intervals.isEmpty()) {
                        QueryInterval[] queryIntervals = BAMInputFormat.prepareQueryIntervals(intervals, dict);
                        fileToSpan.put(bamFile, BAMFileReader.getFileSpan((QueryInterval[])queryIntervals, (BAMIndex)idx));
                    }
                    if (!traverseUnplacedUnmapped) continue;
                    long startOfLastLinearBin = idx.getStartOfLastLinearBin();
                    long noCoordinateCount = ((AbstractBAMFileIndex)idx).getNoCoordinateCount();
                    if (startOfLastLinearBin == -1L || noCoordinateCount <= 0L) continue;
                    fileToUnmapped.put(bamFile, startOfLastLinearBin);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (in == null) continue;
                    if (throwable2 != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (samReader == null) continue;
                if (throwable != null) {
                    try {
                        samReader.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                samReader.close();
            }
        }
        ArrayList<InputSplit> filteredSplits = new ArrayList<InputSplit>();
        for (InputSplit inputSplit : splits) {
            FileVirtualSplit virtualSplit = (FileVirtualSplit)inputSplit;
            long splitStart = virtualSplit.getStartVirtualOffset();
            long splitEnd = virtualSplit.getEndVirtualOffset();
            BAMFileSpan splitSpan = new BAMFileSpan(new Chunk(splitStart, splitEnd));
            BAMFileSpan span = (BAMFileSpan)fileToSpan.get(virtualSplit.getPath());
            if (span == null) continue;
            span = (BAMFileSpan)span.removeContentsBefore((SAMFileSpan)splitSpan);
            if ((span = (BAMFileSpan)span.removeContentsAfter((SAMFileSpan)splitSpan)).getChunks().isEmpty()) continue;
            filteredSplits.add(new FileVirtualSplit(virtualSplit.getPath(), splitStart, splitEnd, virtualSplit.getLocations(), span.toCoordinateArray()));
        }
        if (traverseUnplacedUnmapped) {
            for (Map.Entry entry : fileToUnmapped.entrySet()) {
                Path file = (Path)entry.getKey();
                long unmappedStart = (Long)entry.getValue();
                boolean foundFirstSplit = false;
                for (InputSplit split : splits) {
                    FileVirtualSplit virtualSplit = (FileVirtualSplit)split;
                    if (!virtualSplit.getPath().equals((Object)file)) continue;
                    long splitStart = virtualSplit.getStartVirtualOffset();
                    long splitEnd = virtualSplit.getEndVirtualOffset();
                    if (foundFirstSplit) {
                        filteredSplits.add(new FileVirtualSplit(virtualSplit.getPath(), splitStart, splitEnd, virtualSplit.getLocations()));
                        continue;
                    }
                    if (splitStart > unmappedStart || unmappedStart > splitEnd) continue;
                    filteredSplits.add(new FileVirtualSplit(virtualSplit.getPath(), unmappedStart, splitEnd, virtualSplit.getLocations()));
                    foundFirstSplit = true;
                }
            }
        }
        return filteredSplits;
    }

    static QueryInterval[] prepareQueryIntervals(List<Interval> rawIntervals, SAMSequenceDictionary sequenceDictionary) {
        if (rawIntervals == null || rawIntervals.isEmpty()) {
            return null;
        }
        QueryInterval[] convertedIntervals = (QueryInterval[])rawIntervals.stream().map(rawInterval -> BAMInputFormat.convertSimpleIntervalToQueryInterval(rawInterval, sequenceDictionary)).toArray(QueryInterval[]::new);
        return QueryInterval.optimizeIntervals((QueryInterval[])convertedIntervals);
    }

    private static QueryInterval convertSimpleIntervalToQueryInterval(Interval interval, SAMSequenceDictionary sequenceDictionary) {
        if (interval == null) {
            throw new IllegalArgumentException("interval may not be null");
        }
        if (sequenceDictionary == null) {
            throw new IllegalArgumentException("sequence dictionary may not be null");
        }
        int contigIndex = sequenceDictionary.getSequenceIndex(interval.getContig());
        if (contigIndex == -1) {
            throw new IllegalArgumentException("Contig " + interval.getContig() + " not present in reads sequence dictionary");
        }
        return new QueryInterval(contigIndex, interval.getStart(), interval.getEnd());
    }

    public boolean isSplitable(JobContext job, Path path) {
        return true;
    }
}

