/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import com.google.common.collect.Iterators;
import com.google.common.io.Files;
import htsjdk.samtools.seekablestream.SeekableFileStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextComparator;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.seqdoop.hadoop_bam.KeyIgnoringVCFOutputFormat;
import org.seqdoop.hadoop_bam.TestVCFInputFormat;
import org.seqdoop.hadoop_bam.VCFFormat;
import org.seqdoop.hadoop_bam.VCFInputFormat;
import org.seqdoop.hadoop_bam.VariantContextWritable;
import org.seqdoop.hadoop_bam.util.BGZFCodec;
import org.seqdoop.hadoop_bam.util.BGZFEnhancedGzipCodec;
import org.seqdoop.hadoop_bam.util.VCFFileMerger;
import org.seqdoop.hadoop_bam.util.VCFHeaderReader;

@RunWith(value=Parameterized.class)
public class TestVCFRoundTrip {
    private static Configuration conf;
    private String testVCFFileName;
    private Class<? extends CompressionCodec> codecClass;
    private TestVCFInputFormat.NUM_SPLITS expectedSplits;

    @Parameterized.Parameters
    public static Collection<Object> data() {
        return Arrays.asList({"test.vcf", null, TestVCFInputFormat.NUM_SPLITS.ANY}, {"test.vcf.gz", BGZFEnhancedGzipCodec.class, TestVCFInputFormat.NUM_SPLITS.EXACTLY_ONE}, {"test.vcf.bgzf.gz", BGZFCodec.class, TestVCFInputFormat.NUM_SPLITS.ANY}, {"test.vcf.bgz", BGZFCodec.class, TestVCFInputFormat.NUM_SPLITS.ANY}, {"HiSeq.10000.vcf", null, TestVCFInputFormat.NUM_SPLITS.MORE_THAN_ONE}, {"HiSeq.10000.vcf.gz", BGZFEnhancedGzipCodec.class, TestVCFInputFormat.NUM_SPLITS.EXACTLY_ONE}, {"HiSeq.10000.vcf.bgzf.gz", BGZFCodec.class, TestVCFInputFormat.NUM_SPLITS.MORE_THAN_ONE}, {"HiSeq.10000.vcf.bgz", BGZFCodec.class, TestVCFInputFormat.NUM_SPLITS.MORE_THAN_ONE});
    }

    public TestVCFRoundTrip(String filename, Class<? extends CompressionCodec> codecClass, TestVCFInputFormat.NUM_SPLITS expectedSplits) {
        this.testVCFFileName = ClassLoader.getSystemClassLoader().getResource(filename).getFile();
        this.codecClass = codecClass;
        this.expectedSplits = expectedSplits;
    }

    @Before
    public void setup() throws Exception {
        conf = new Configuration();
        conf.set("TestVCF.header", this.testVCFFileName);
        conf.setStrings("io.compression.codecs", new String[]{BGZFCodec.class.getCanonicalName(), BGZFEnhancedGzipCodec.class.getCanonicalName()});
        conf.setInt("mapreduce.input.fileinputformat.split.maxsize", 102400);
    }

    @Test
    public void testRoundTrip() throws Exception {
        Path vcfPath = new Path("file://" + this.testVCFFileName);
        Path outputPath = this.doMapReduce(vcfPath, true);
        ArrayList expectedVariants = new ArrayList();
        VCFFileReader vcfFileReader = TestVCFRoundTrip.parseVcf(new File(this.testVCFFileName));
        Iterators.addAll(expectedVariants, (Iterator)vcfFileReader.iterator());
        int splits = 0;
        ArrayList actualVariants = new ArrayList();
        Object[] vcfFiles = new File(outputPath.toUri()).listFiles(pathname -> !pathname.getName().startsWith(".") && !pathname.getName().startsWith("_"));
        Arrays.sort(vcfFiles);
        for (Object vcf : vcfFiles) {
            ++splits;
            Iterators.addAll(actualVariants, (Iterator)TestVCFRoundTrip.parseVcf((File)vcf).iterator());
            if (BGZFCodec.class.equals(this.codecClass)) {
                Assert.assertTrue((boolean)BlockCompressedInputStream.isValidFile((InputStream)new BufferedInputStream(new FileInputStream((File)vcf))));
                continue;
            }
            if (!BGZFEnhancedGzipCodec.class.equals(this.codecClass)) continue;
            Assert.assertTrue((boolean)VCFFormat.isGzip((InputStream)new BufferedInputStream(new FileInputStream((File)vcf))));
        }
        switch (this.expectedSplits) {
            case EXACTLY_ONE: {
                Assert.assertEquals((String)"Should be exactly one split", (long)1L, (long)splits);
                break;
            }
            case MORE_THAN_ONE: {
                Assert.assertTrue((String)"Should be more than one split", (splits > 1 ? 1 : 0) != 0);
                break;
            }
        }
        VCFHeader vcfHeader = VCFHeaderReader.readHeaderFrom((SeekableStream)new SeekableFileStream(new File(this.testVCFFileName)));
        VariantContextComparator vcfRecordComparator = vcfHeader.getVCFRecordComparator();
        Assert.assertEquals((long)expectedVariants.size(), (long)actualVariants.size());
        for (int i = 0; i < expectedVariants.size(); ++i) {
            Assert.assertEquals((long)0L, (long)vcfRecordComparator.compare((VariantContext)expectedVariants.get(i), (VariantContext)actualVariants.get(i)));
        }
    }

    @Test
    public void testRoundTripWithMerge() throws Exception {
        Path vcfPath = new Path("file://" + this.testVCFFileName);
        Path outputPath = this.doMapReduce(vcfPath, false);
        VCFHeader vcfHeader = VCFHeaderReader.readHeaderFrom((SeekableStream)new SeekableFileStream(new File(this.testVCFFileName)));
        File outFile = File.createTempFile("testVCFWriter", this.testVCFFileName.substring(this.testVCFFileName.lastIndexOf(".")));
        outFile.deleteOnExit();
        VCFFileMerger.mergeParts((String)outputPath.toUri().toString(), (String)outFile.toURI().toString(), (VCFHeader)vcfHeader);
        ArrayList actualVariants = new ArrayList();
        VCFFileReader vcfFileReaderActual = TestVCFRoundTrip.parseVcf(outFile);
        Iterators.addAll(actualVariants, (Iterator)vcfFileReaderActual.iterator());
        ArrayList expectedVariants = new ArrayList();
        VCFFileReader vcfFileReader = TestVCFRoundTrip.parseVcf(new File(this.testVCFFileName));
        Iterators.addAll(expectedVariants, (Iterator)vcfFileReader.iterator());
        VariantContextComparator vcfRecordComparator = vcfHeader.getVCFRecordComparator();
        Assert.assertEquals((long)expectedVariants.size(), (long)actualVariants.size());
        for (int i = 0; i < expectedVariants.size(); ++i) {
            Assert.assertEquals((long)0L, (long)vcfRecordComparator.compare((VariantContext)expectedVariants.get(i), (VariantContext)actualVariants.get(i)));
        }
    }

    private Path doMapReduce(Path inputPath, boolean writeHeader) throws Exception {
        FileSystem fileSystem = FileSystem.get((Configuration)conf);
        Path outputPath = fileSystem.makeQualified(new Path("target/out"));
        fileSystem.delete(outputPath, true);
        Job job = Job.getInstance((Configuration)conf);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inputPath});
        job.setInputFormatClass(VCFInputFormat.class);
        job.setMapOutputKeyClass(LongWritable.class);
        job.setMapOutputValueClass(VariantContextWritable.class);
        job.setOutputFormatClass(writeHeader ? VCFTestWithHeaderOutputFormat.class : VCFTestNoHeaderOutputFormat.class);
        job.setOutputKeyClass(LongWritable.class);
        job.setOutputValueClass(VariantContextWritable.class);
        job.setNumReduceTasks(0);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        if (this.codecClass != null) {
            FileOutputFormat.setOutputCompressorClass((Job)job, this.codecClass);
        }
        boolean success = job.waitForCompletion(true);
        Assert.assertTrue((boolean)success);
        return outputPath;
    }

    private static VCFFileReader parseVcf(File vcf) throws IOException {
        File actualVcf;
        if (vcf.getName().endsWith(".bgz")) {
            actualVcf = File.createTempFile(vcf.getName(), ".gz");
            actualVcf.deleteOnExit();
            Files.copy((File)vcf, (File)actualVcf);
        } else {
            actualVcf = vcf;
        }
        return new VCFFileReader(actualVcf, false);
    }

    static class VCFTestNoHeaderOutputFormat
    extends KeyIgnoringVCFOutputFormat<NullWritable> {
        public static final String READ_HEADER_FROM_FILE = "TestVCF.header";

        public VCFTestNoHeaderOutputFormat() {
            super(VCFFormat.VCF);
        }

        public RecordWriter<NullWritable, VariantContextWritable> getRecordWriter(TaskAttemptContext ctx) throws IOException {
            Path vcfPath = new Path(conf.get(READ_HEADER_FROM_FILE));
            this.readHeaderFrom(vcfPath, vcfPath.getFileSystem(conf));
            ctx.getConfiguration().setBoolean("hadoopbam.vcf.write-header", false);
            return super.getRecordWriter(ctx);
        }
    }

    static class VCFTestWithHeaderOutputFormat
    extends KeyIgnoringVCFOutputFormat<NullWritable> {
        public static final String READ_HEADER_FROM_FILE = "TestVCF.header";

        public VCFTestWithHeaderOutputFormat() {
            super(VCFFormat.VCF);
        }

        public RecordWriter<NullWritable, VariantContextWritable> getRecordWriter(TaskAttemptContext ctx) throws IOException {
            Path vcfPath = new Path(conf.get(READ_HEADER_FROM_FILE));
            this.readHeaderFrom(vcfPath, vcfPath.getFileSystem(conf));
            return super.getRecordWriter(ctx);
        }
    }
}

