/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;
import org.seqdoop.hadoop_bam.VCFFormat;

public class TestVCFFormat {
    @Test
    public void testInferFromFilePath() throws IOException {
        Assert.assertEquals((Object)VCFFormat.VCF, (Object)VCFFormat.inferFromFilePath((String)"test.vcf"));
        Assert.assertEquals((Object)VCFFormat.VCF, (Object)VCFFormat.inferFromFilePath((String)"test.vcf.gz"));
        Assert.assertEquals((Object)VCFFormat.VCF, (Object)VCFFormat.inferFromFilePath((String)"test.vcf.bgzf.gz"));
        Assert.assertEquals((Object)VCFFormat.VCF, (Object)VCFFormat.inferFromFilePath((String)"test.vcf.bgz"));
        Assert.assertEquals((Object)VCFFormat.BCF, (Object)VCFFormat.inferFromFilePath((String)"test.uncompressed.bcf"));
        Assert.assertEquals((Object)VCFFormat.BCF, (Object)VCFFormat.inferFromFilePath((String)"test.bgzf.bcf"));
        Assert.assertNull((Object)VCFFormat.inferFromFilePath((String)"test.sam"));
    }

    @Test
    public void testInferFromData() throws IOException {
        Assert.assertEquals((Object)VCFFormat.VCF, (Object)VCFFormat.inferFromData((InputStream)this.stream("test.vcf")));
        Assert.assertEquals((Object)VCFFormat.VCF, (Object)VCFFormat.inferFromData((InputStream)this.stream("test.vcf.gz")));
        Assert.assertEquals((Object)VCFFormat.VCF, (Object)VCFFormat.inferFromData((InputStream)this.stream("test.vcf.bgzf.gz")));
        Assert.assertEquals((Object)VCFFormat.VCF, (Object)VCFFormat.inferFromData((InputStream)this.stream("test.vcf.bgz")));
        Assert.assertEquals((Object)VCFFormat.BCF, (Object)VCFFormat.inferFromData((InputStream)this.stream("test.uncompressed.bcf")));
        Assert.assertEquals((Object)VCFFormat.BCF, (Object)VCFFormat.inferFromData((InputStream)this.stream("test.bgzf.bcf")));
        Assert.assertNull((Object)VCFFormat.inferFromData((InputStream)this.stream("test.sam")));
    }

    private InputStream stream(String resource) throws IOException {
        return ClassLoader.getSystemClassLoader().getResource(resource).openStream();
    }
}

