/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.seqdoop.hadoop_bam.QseqOutputFormat;
import org.seqdoop.hadoop_bam.SequencedFragment;

public class TestQseqOutputFormat {
    private SequencedFragment fragment;
    private ByteArrayOutputStream outputBuffer;
    private DataOutputStream dataOutput;
    private QseqOutputFormat.QseqRecordWriter writer;

    @Before
    public void setup() throws IOException {
        this.fragment = new SequencedFragment();
        this.fragment.setInstrument("instrument");
        this.fragment.setRunNumber(Integer.valueOf(1));
        this.fragment.setFlowcellId("xyz");
        this.fragment.setLane(Integer.valueOf(2));
        this.fragment.setTile(Integer.valueOf(1001));
        this.fragment.setXpos(Integer.valueOf(10000));
        this.fragment.setYpos(Integer.valueOf(9999));
        this.fragment.setRead(Integer.valueOf(1));
        this.fragment.setFilterPassed(Boolean.valueOf(true));
        this.fragment.setIndexSequence("CATCAT");
        this.fragment.setSequence(new Text("AAAAAAAAAA"));
        this.fragment.setQuality(new Text("##########"));
        this.outputBuffer = new ByteArrayOutputStream();
        this.dataOutput = new DataOutputStream(this.outputBuffer);
        this.writer = new QseqOutputFormat.QseqRecordWriter(new Configuration(), (OutputStream)this.dataOutput);
    }

    @Test
    public void testSimple() throws IOException {
        this.writer.write(null, this.fragment);
        this.writer.close(null);
        String[] fields = new String(this.outputBuffer.toByteArray(), "US-ASCII").split("\t");
        Assert.assertEquals((long)11L, (long)fields.length);
        Assert.assertEquals((Object)this.fragment.getInstrument(), (Object)fields[0]);
        Assert.assertEquals((Object)this.fragment.getRunNumber().toString(), (Object)fields[1]);
        Assert.assertEquals((Object)this.fragment.getLane().toString(), (Object)fields[2]);
        Assert.assertEquals((Object)this.fragment.getTile().toString(), (Object)fields[3]);
        Assert.assertEquals((Object)this.fragment.getXpos().toString(), (Object)fields[4]);
        Assert.assertEquals((Object)this.fragment.getYpos().toString(), (Object)fields[5]);
        Assert.assertEquals((Object)this.fragment.getIndexSequence().toString(), (Object)fields[6]);
        Assert.assertEquals((Object)this.fragment.getRead().toString(), (Object)fields[7]);
        Assert.assertEquals((Object)this.fragment.getSequence().toString(), (Object)fields[8]);
        Assert.assertEquals((Object)this.fragment.getQuality().toString().replace('#', 'B'), (Object)fields[9]);
        Assert.assertEquals((Object)(this.fragment.getFilterPassed() != false ? "1\n" : "0\n"), (Object)fields[10]);
    }

    @Test
    public void testConvertUnknowns() throws IOException, UnsupportedEncodingException {
        String seq = "AAAAANNNNN";
        this.fragment.setSequence(new Text(seq));
        this.writer.write(null, this.fragment);
        this.writer.close(null);
        String[] fields = new String(this.outputBuffer.toByteArray(), "US-ASCII").split("\t");
        Assert.assertEquals((Object)seq.replace("N", "."), (Object)fields[8]);
    }

    @Test
    public void testConvertUnknownsInIndexSequence() throws IOException, UnsupportedEncodingException {
        String index = "CATNNN";
        this.fragment.setIndexSequence(index);
        this.writer.write(null, this.fragment);
        this.writer.close(null);
        String[] fields = new String(this.outputBuffer.toByteArray(), "US-ASCII").split("\t");
        Assert.assertEquals((Object)index.replace("N", "."), (Object)fields[6]);
    }

    @Test
    public void testBaseQualities() throws IOException {
        String seq = "AAAAAAAAAA";
        String qual = "##########";
        this.fragment.setSequence(new Text(seq));
        this.fragment.setQuality(new Text(qual));
        this.writer.write(null, this.fragment);
        this.writer.close(null);
        String[] fields = new String(this.outputBuffer.toByteArray(), "US-ASCII").split("\t");
        Assert.assertEquals((Object)qual.replace("#", "B"), (Object)fields[9]);
    }

    @Test
    public void testConfigureOutputInSanger() throws IOException {
        String seq = "AAAAAAAAAA";
        String qual = "##########";
        this.fragment.setSequence(new Text(seq));
        this.fragment.setQuality(new Text(qual));
        Configuration conf = new Configuration();
        conf.set("hbam.qseq-output.base-quality-encoding", "sanger");
        this.writer.setConf(conf);
        this.writer.write(null, this.fragment);
        this.writer.close(null);
        String[] fields = new String(this.outputBuffer.toByteArray(), "US-ASCII").split("\t");
        Assert.assertEquals((Object)qual, (Object)fields[9]);
    }

    @Test
    public void testClose() throws IOException {
        this.writer.close(null);
    }

    @Test
    public void testNoIndex() throws IOException {
        this.fragment.setIndexSequence(null);
        this.writer.write(null, this.fragment);
        this.writer.close(null);
        String[] fields = new String(this.outputBuffer.toByteArray(), "US-ASCII").split("\t");
        Assert.assertEquals((long)11L, (long)fields.length);
        Assert.assertEquals((Object)"0", (Object)fields[6]);
    }
}

