/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.seqdoop.hadoop_bam.FastqOutputFormat;
import org.seqdoop.hadoop_bam.SequencedFragment;

public class TestFastqOutputFormat {
    private SequencedFragment fragment;
    private ByteArrayOutputStream outputBuffer;
    private DataOutputStream dataOutput;
    private FastqOutputFormat.FastqRecordWriter writer;

    @Before
    public void setup() throws IOException {
        this.fragment = new SequencedFragment();
        this.fragment.setInstrument("instrument");
        this.fragment.setRunNumber(Integer.valueOf(1));
        this.fragment.setFlowcellId("xyz");
        this.fragment.setLane(Integer.valueOf(2));
        this.fragment.setTile(Integer.valueOf(1001));
        this.fragment.setXpos(Integer.valueOf(10000));
        this.fragment.setYpos(Integer.valueOf(9999));
        this.fragment.setRead(Integer.valueOf(1));
        this.fragment.setFilterPassed(Boolean.valueOf(true));
        this.fragment.setControlNumber(Integer.valueOf(33));
        this.fragment.setIndexSequence("CATCAT");
        this.fragment.setSequence(new Text("AAAAAAAAAA"));
        this.fragment.setQuality(new Text("##########"));
        this.outputBuffer = new ByteArrayOutputStream();
        this.dataOutput = new DataOutputStream(this.outputBuffer);
        this.writer = new FastqOutputFormat.FastqRecordWriter(new Configuration(), (OutputStream)this.dataOutput);
    }

    @Test
    public void testSimple() throws IOException {
        this.writer.write(null, this.fragment);
        this.writer.close(null);
        String[] lines = new String(this.outputBuffer.toByteArray(), "US-ASCII").split("\n");
        Assert.assertEquals((long)4L, (long)lines.length);
        String idLine = lines[0];
        Assert.assertTrue((boolean)idLine.startsWith("@"));
        TestFastqOutputFormat.compareMetadata(this.fragment, idLine);
        Assert.assertEquals((Object)this.fragment.getSequence().toString(), (Object)lines[1]);
        Assert.assertEquals((Object)"+", (Object)lines[2]);
        Assert.assertEquals((Object)this.fragment.getQuality().toString(), (Object)lines[3]);
    }

    @Test
    public void testNullControlNumber() throws IOException {
        this.fragment.setControlNumber(null);
        this.writer.write(null, this.fragment);
        this.writer.close(null);
        String[] lines = new String(this.outputBuffer.toByteArray(), "US-ASCII").split("\n");
        Assert.assertEquals((long)4L, (long)lines.length);
        String idLine = lines[0];
        Assert.assertTrue((boolean)idLine.startsWith("@"));
        this.fragment.setControlNumber(Integer.valueOf(0));
        TestFastqOutputFormat.compareMetadata(this.fragment, idLine);
    }

    @Test
    public void testNullFilter() throws IOException {
        this.fragment.setFilterPassed(null);
        this.writer.write(null, this.fragment);
        this.writer.close(null);
        String[] lines = new String(this.outputBuffer.toByteArray(), "US-ASCII").split("\n");
        Assert.assertEquals((long)4L, (long)lines.length);
        String idLine = lines[0];
        Assert.assertTrue((boolean)idLine.startsWith("@"));
        this.fragment.setFilterPassed(Boolean.valueOf(true));
        TestFastqOutputFormat.compareMetadata(this.fragment, idLine);
    }

    @Test
    public void testCustomId() throws IOException {
        String customKey = "hello";
        this.writer.write(new Text(customKey), this.fragment);
        this.writer.close(null);
        String[] lines = new String(this.outputBuffer.toByteArray(), "US-ASCII").split("\n");
        Assert.assertEquals((long)4L, (long)lines.length);
        String idLine = lines[0];
        Assert.assertTrue((boolean)idLine.startsWith("@"));
        Assert.assertEquals((Object)customKey, (Object)idLine.substring(1));
    }

    @Test
    public void testBaseQualitiesInIllumina() throws IOException {
        Configuration conf = new Configuration();
        conf.set("hbam.fastq-output.base-quality-encoding", "illumina");
        this.writer.setConf(conf);
        String seq = "AAAAAAAAAA";
        String qual = "##########";
        this.fragment.setSequence(new Text(seq));
        this.fragment.setQuality(new Text(qual));
        this.writer.write(null, this.fragment);
        this.writer.close(null);
        String[] lines = new String(this.outputBuffer.toByteArray(), "US-ASCII").split("\n");
        Assert.assertEquals((Object)qual.replace("#", "B"), (Object)lines[3]);
    }

    @Test
    public void testConfigureOutputInSanger() throws IOException {
        Configuration conf = new Configuration();
        conf.set("hbam.fastq-output.base-quality-encoding", "sanger");
        this.writer.setConf(conf);
        this.testSimple();
    }

    @Test(expected=RuntimeException.class)
    public void testBadConfig() throws IOException {
        Configuration conf = new Configuration();
        conf.set("hbam.fastq-output.base-quality-encoding", "blalbal");
        this.writer.setConf(conf);
    }

    @Test
    public void testClose() throws IOException {
        this.writer.close(null);
    }

    private static void compareMetadata(SequencedFragment fragment, String idLine) {
        idLine = idLine.substring(1);
        String[] pieces = idLine.split(" ")[0].split(":");
        Assert.assertEquals((Object)fragment.getInstrument(), (Object)pieces[0]);
        Assert.assertEquals((Object)fragment.getRunNumber().toString(), (Object)pieces[1]);
        Assert.assertEquals((Object)fragment.getFlowcellId(), (Object)pieces[2]);
        Assert.assertEquals((Object)fragment.getLane().toString(), (Object)pieces[3]);
        Assert.assertEquals((Object)fragment.getTile().toString(), (Object)pieces[4]);
        Assert.assertEquals((Object)fragment.getXpos().toString(), (Object)pieces[5]);
        Assert.assertEquals((Object)fragment.getYpos().toString(), (Object)pieces[6]);
        pieces = idLine.split(" ")[1].split(":");
        Assert.assertEquals((Object)fragment.getRead().toString(), (Object)pieces[0]);
        Assert.assertEquals((Object)(fragment.getFilterPassed() != false ? "N" : "Y"), (Object)pieces[1]);
        Assert.assertEquals((Object)fragment.getControlNumber().toString(), (Object)pieces[2]);
        Assert.assertEquals((Object)fragment.getIndexSequence().toString(), (Object)pieces[3]);
    }

    public static void main(String[] args) {
        JUnitCore.main((String[])new String[]{TestFastqOutputFormat.class.getName()});
    }
}

