/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.seqdoop.hadoop_bam.FastqInputFormat;
import org.seqdoop.hadoop_bam.SequencedFragment;

public class TestFastqInputFormat {
    public static final String oneFastq = "@ERR020229.10880 HWI-ST168_161:1:1:1373:2042/1\nTTGGATGATAGGGATTATTTGACTCGAATATTGGAAATAGCTGTTTATATTTTTTAAAAATGGTCTGTAACTGGTGACAGGACGCTTCGAT\n+\n###########################################################################################";
    public static final String twoFastq = "@ERR020229.10880 HWI-ST168_161:1:1:1373:2042/1\nTTGGATGATAGGGATTATTTGACTCGAATATTGGAAATAGCTGTTTATATTTTTTAAAAATGGTCTGTAACTGGTGACAGGACGCTTCGAT\n+\n###########################################################################################\n@ERR020229.10883 HWI-ST168_161:1:1:1796:2044/1\nTGAGCAGATGTGCTAAAGCTGCTTCTCCCCTAGGATCATTTGTACCTACCAGACTCAGGGAAAGGGGTGAGAATTGGGCCGTGGGGCAAGG\n+\nBDDCDBDD?A=?=:=7,7*@A;;53/53.:@>@@4=>@@@=?1?###############################################";
    public static final String illuminaFastq = "@EAS139:136:FC706VJ:2:5:1000:12850 1:Y:18:ATCACG\nTTGGATGATAGGGATTATTTGACTCGAATATTGGAAATAGCTGTTTATATTTTTTAAAAATGGTCTGTAACTGGTGACAGGACGCTTCGAT\n+\n##########################################################################################~";
    public static final String illuminaFastqWithPhred64Quality = "@EAS139:136:FC706VJ:2:5:1000:12850 1:Y:18:ATCACG\nTTGGATGATAGGGATTATTTGACTCGAATATTGGAAATAGCTGTTTATATTTTTTAAAAATGGTCTGTAACTGGTGACAGGACGCTTCGAT\n+\nbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb";
    public static final String oneFastqWithoutRead = "@ERR020229.10880 HWI-ST168_161:1:1:1373:2042\nTTGGATGATAGGGATTATTTGACTCGAATATTGGAAATAGCTGTTTATATTTTTTAAAAATGGTCTGTAACTGGTGACAGGACGCTTCGAT\n+\n###########################################################################################";
    public static final String fastqWithIdTwice = "@ERR020229.10880 HWI-ST168_161:1:1:1373:2042/1\nTTGGATGATAGGGATTATTTGACTCGAATATTGGAAATAGCTGTTTATATTTTTTAAAAATGGTCTGTAACTGGTGACAGGACGCTTCGAT\n+ERR020229.10880 HWI-ST168_161:1:1:1373:2042/1\n###########################################################################################";
    public static final String fastqWithAmpersandQuality = "+lousy.id HWI-ST168_161:1:1:1373:2042/1\n@##########################################################################################\n@ERR020229.10880 HWI-ST168_161:1:1:1373:2042/1\nTTGGATGATAGGGATTATTTGACTCGAATATTGGAAATAGCTGTTTATATTTTTTAAAAATGGTCTGTAACTGGTGACAGGACGCTTCGAT\n+ERR020229.10880 HWI-ST168_161:1:1:1373:2042/1\n###########################################################################################";
    public static final String illuminaFastqNoFlowCellID = "@EAS139:136::2:5:1000:12850 1:Y:18:ATCACG\nTTGGATGATAGGGATTATTTGACTCGAATATTGGAAATAGCTGTTTATATTTTTTAAAAATGGTCTGTAACTGGTGACAGGACGCTTCGAT\n+\n###########################################################################################";
    public static final String illuminaFastqNegativeXYPos = "@EAS139:136:FC706VJ:2:5:-1000:-12850 1:Y:18:ATCACG\nTTGGATGATAGGGATTATTTGACTCGAATATTGGAAATAGCTGTTTATATTTTTTAAAAATGGTCTGTAACTGGTGACAGGACGCTTCGAT\n+\n###########################################################################################";
    public static final String illuminaFastqNoIndex = "@EAS139:136::2:5:1000:12850 1:Y:18:\nTTGGATGATAGGGATTATTTGACTCGAATATTGGAAATAGCTGTTTATATTTTTTAAAAATGGTCTGTAACTGGTGACAGGACGCTTCGAT\n+\n###########################################################################################";
    public static final String twoFastqWithIllumina = "@EAS139:136:FC706VJ:2:5:1000:12850 1:Y:18:ATCACG\nTTGGATGATAGGGATTATTTGACTCGAATATTGGAAATAGCTGTTTATATTTTTTAAAAATGGTCTGTAACTGGTGACAGGACGCTTCGAT\n+\n###########################################################################################\n@EAS139:136:FC706VJ:2:5:1000:12850 2:N:18:ATCACG\nTTGGATGATAGGGATTATTTGACTCGAATATTGGAAATAGCTGTTTATATTTTTTAAAAATGGTCTGTAACTGGTGACAGGACGCTTCGAT\n+\n###########################################################################################\n@EAS139:136:FC706VJ:2:5:1000:12850 3:N:18:ATCACG\nTGAGCAGATGTGCTAAAGCTGCTTCTCCCCTAGGATCATTTGTACCTACCAGACTCAGGGAAAGGGGTGAGAATTGGGCCGTGGGGCAAGG\n+\nBDDCDBDD?A=?=:=7,7*@A;;53/53.:@>@@4=>@@@=?1?###############################################";
    private JobConf conf;
    private FileSplit split;
    private File tempFastq;
    private File tempGz;
    private Text key;
    private SequencedFragment fragment;

    @Before
    public void setup() throws IOException {
        this.tempFastq = File.createTempFile("test_fastq_input_format", "fastq");
        this.tempGz = File.createTempFile("test_fastq_input_format", ".gz");
        this.conf = new JobConf();
        this.key = new Text();
        this.fragment = new SequencedFragment();
    }

    @After
    public void tearDown() {
        this.tempFastq.delete();
        this.tempGz.delete();
        this.split = null;
    }

    private void writeToTempFastq(String s) throws IOException {
        PrintWriter fastqOut = new PrintWriter(new BufferedWriter(new FileWriter(this.tempFastq)));
        fastqOut.write(s);
        fastqOut.close();
    }

    private FastqInputFormat.FastqRecordReader createReaderForOneFastq() throws IOException {
        this.writeToTempFastq(oneFastq);
        this.split = new FileSplit(new Path(this.tempFastq.toURI().toString()), 0L, (long)oneFastq.length(), null);
        return new FastqInputFormat.FastqRecordReader((Configuration)this.conf, this.split);
    }

    @Test
    public void testReadFromStart() throws IOException {
        FastqInputFormat.FastqRecordReader reader = this.createReaderForOneFastq();
        Assert.assertEquals((long)0L, (long)reader.getPos());
        Assert.assertEquals((double)0.0, (double)reader.getProgress(), (double)0.01);
        boolean retval = reader.next(this.key, this.fragment);
        Assert.assertTrue((boolean)retval);
        Assert.assertEquals((Object)"ERR020229.10880 HWI-ST168_161:1:1:1373:2042/1", (Object)this.key.toString());
        Assert.assertEquals((Object)"TTGGATGATAGGGATTATTTGACTCGAATATTGGAAATAGCTGTTTATATTTTTTAAAAATGGTCTGTAACTGGTGACAGGACGCTTCGAT", (Object)this.fragment.getSequence().toString());
        Assert.assertEquals((Object)"###########################################################################################", (Object)this.fragment.getQuality().toString());
        Assert.assertEquals((long)oneFastq.length(), (long)reader.getPos());
        Assert.assertEquals((double)1.0, (double)reader.getProgress(), (double)0.01);
        retval = reader.next(this.key, this.fragment);
        Assert.assertFalse((boolean)retval);
    }

    @Test
    public void testReadStartInMiddle() throws IOException {
        this.writeToTempFastq(twoFastq);
        this.split = new FileSplit(new Path(this.tempFastq.toURI().toString()), 10L, (long)(twoFastq.length() - 10), null);
        FastqInputFormat.FastqRecordReader reader = new FastqInputFormat.FastqRecordReader((Configuration)this.conf, this.split);
        Assert.assertEquals((long)(oneFastq.length() + 1), (long)reader.getPos());
        Assert.assertEquals((double)0.0, (double)reader.getProgress(), (double)0.01);
        boolean retval = reader.next(this.key, this.fragment);
        Assert.assertTrue((boolean)retval);
        Assert.assertEquals((Object)"ERR020229.10883 HWI-ST168_161:1:1:1796:2044/1", (Object)this.key.toString());
        Assert.assertEquals((Object)"TGAGCAGATGTGCTAAAGCTGCTTCTCCCCTAGGATCATTTGTACCTACCAGACTCAGGGAAAGGGGTGAGAATTGGGCCGTGGGGCAAGG", (Object)this.fragment.getSequence().toString());
        Assert.assertEquals((Object)"BDDCDBDD?A=?=:=7,7*@A;;53/53.:@>@@4=>@@@=?1?###############################################", (Object)this.fragment.getQuality().toString());
        Assert.assertEquals((long)twoFastq.length(), (long)reader.getPos());
        Assert.assertEquals((double)1.0, (double)reader.getProgress(), (double)0.01);
        retval = reader.next(this.key, this.fragment);
        Assert.assertFalse((boolean)retval);
    }

    @Test
    public void testSliceEndsBeforeEndOfFile() throws IOException {
        this.writeToTempFastq(twoFastq);
        this.split = new FileSplit(new Path(this.tempFastq.toURI().toString()), 0L, 10L, null);
        FastqInputFormat.FastqRecordReader reader = new FastqInputFormat.FastqRecordReader((Configuration)this.conf, this.split);
        boolean retval = reader.next(this.key, this.fragment);
        Assert.assertTrue((boolean)retval);
        Assert.assertEquals((Object)"ERR020229.10880 HWI-ST168_161:1:1:1373:2042/1", (Object)this.key.toString());
        Assert.assertFalse((String)"FastqRecordReader is reading a record that starts after the end of the slice", (boolean)reader.next(this.key, this.fragment));
    }

    @Test
    public void testGetReadNumFromName() throws IOException {
        FastqInputFormat.FastqRecordReader reader = this.createReaderForOneFastq();
        boolean retval = reader.next(this.key, this.fragment);
        Assert.assertTrue((boolean)retval);
        Assert.assertEquals((long)1L, (long)this.fragment.getRead().intValue());
    }

    @Test
    public void testNameWithoutReadNum() throws IOException {
        this.writeToTempFastq(oneFastqWithoutRead);
        this.split = new FileSplit(new Path(this.tempFastq.toURI().toString()), 0L, (long)oneFastqWithoutRead.length(), null);
        FastqInputFormat.FastqRecordReader reader = new FastqInputFormat.FastqRecordReader((Configuration)this.conf, this.split);
        boolean retval = reader.next(this.key, this.fragment);
        Assert.assertTrue((boolean)retval);
        Assert.assertNull((String)"Read is not null", (Object)this.fragment.getRead());
    }

    @Test
    public void testIlluminaMetaInfo() throws IOException {
        this.writeToTempFastq(illuminaFastq);
        this.split = new FileSplit(new Path(this.tempFastq.toURI().toString()), 0L, (long)illuminaFastq.length(), null);
        FastqInputFormat.FastqRecordReader reader = new FastqInputFormat.FastqRecordReader((Configuration)this.conf, this.split);
        boolean found = reader.next(this.key, this.fragment);
        Assert.assertTrue((boolean)found);
        Assert.assertEquals((Object)"EAS139", (Object)this.fragment.getInstrument());
        Assert.assertEquals((long)136L, (long)this.fragment.getRunNumber().intValue());
        Assert.assertEquals((Object)"FC706VJ", (Object)this.fragment.getFlowcellId());
        Assert.assertEquals((long)2L, (long)this.fragment.getLane().intValue());
        Assert.assertEquals((long)5L, (long)this.fragment.getTile().intValue());
        Assert.assertEquals((long)1000L, (long)this.fragment.getXpos().intValue());
        Assert.assertEquals((long)12850L, (long)this.fragment.getYpos().intValue());
        Assert.assertEquals((long)1L, (long)this.fragment.getRead().intValue());
        Assert.assertEquals((Object)false, (Object)this.fragment.getFilterPassed());
        Assert.assertEquals((long)18L, (long)this.fragment.getControlNumber().intValue());
        Assert.assertEquals((Object)"ATCACG", (Object)this.fragment.getIndexSequence());
    }

    @Test
    public void testIlluminaMetaInfoNullFC() throws IOException {
        this.writeToTempFastq(illuminaFastqNoFlowCellID);
        this.split = new FileSplit(new Path(this.tempFastq.toURI().toString()), 0L, (long)illuminaFastqNoFlowCellID.length(), null);
        FastqInputFormat.FastqRecordReader reader = new FastqInputFormat.FastqRecordReader((Configuration)this.conf, this.split);
        boolean found = reader.next(this.key, this.fragment);
        Assert.assertTrue((boolean)found);
        Assert.assertEquals((Object)"EAS139", (Object)this.fragment.getInstrument());
        Assert.assertEquals((long)136L, (long)this.fragment.getRunNumber().intValue());
        Assert.assertEquals((Object)"", (Object)this.fragment.getFlowcellId());
        Assert.assertEquals((long)2L, (long)this.fragment.getLane().intValue());
        Assert.assertEquals((long)5L, (long)this.fragment.getTile().intValue());
        Assert.assertEquals((long)1000L, (long)this.fragment.getXpos().intValue());
        Assert.assertEquals((long)12850L, (long)this.fragment.getYpos().intValue());
        Assert.assertEquals((long)1L, (long)this.fragment.getRead().intValue());
        Assert.assertEquals((Object)false, (Object)this.fragment.getFilterPassed());
        Assert.assertEquals((long)18L, (long)this.fragment.getControlNumber().intValue());
        Assert.assertEquals((Object)"ATCACG", (Object)this.fragment.getIndexSequence());
    }

    @Test
    public void testIlluminaMetaInfoNegativeXYpos() throws IOException {
        this.writeToTempFastq(illuminaFastqNegativeXYPos);
        this.split = new FileSplit(new Path(this.tempFastq.toURI().toString()), 0L, (long)illuminaFastqNegativeXYPos.length(), null);
        FastqInputFormat.FastqRecordReader reader = new FastqInputFormat.FastqRecordReader((Configuration)this.conf, this.split);
        boolean found = reader.next(this.key, this.fragment);
        Assert.assertTrue((boolean)found);
        Assert.assertEquals((Object)"EAS139", (Object)this.fragment.getInstrument());
        Assert.assertEquals((long)136L, (long)this.fragment.getRunNumber().intValue());
        Assert.assertEquals((Object)"FC706VJ", (Object)this.fragment.getFlowcellId());
        Assert.assertEquals((long)2L, (long)this.fragment.getLane().intValue());
        Assert.assertEquals((long)5L, (long)this.fragment.getTile().intValue());
        Assert.assertEquals((long)-1000L, (long)this.fragment.getXpos().intValue());
        Assert.assertEquals((long)-12850L, (long)this.fragment.getYpos().intValue());
        Assert.assertEquals((long)1L, (long)this.fragment.getRead().intValue());
        Assert.assertEquals((Object)false, (Object)this.fragment.getFilterPassed());
        Assert.assertEquals((long)18L, (long)this.fragment.getControlNumber().intValue());
        Assert.assertEquals((Object)"ATCACG", (Object)this.fragment.getIndexSequence());
    }

    @Test
    public void testOneIlluminaThenNot() throws IOException {
        this.writeToTempFastq("@EAS139:136:FC706VJ:2:5:1000:12850 1:Y:18:ATCACG\nTTGGATGATAGGGATTATTTGACTCGAATATTGGAAATAGCTGTTTATATTTTTTAAAAATGGTCTGTAACTGGTGACAGGACGCTTCGAT\n+\n##########################################################################################~\n@ERR020229.10880 HWI-ST168_161:1:1:1373:2042/1\nTTGGATGATAGGGATTATTTGACTCGAATATTGGAAATAGCTGTTTATATTTTTTAAAAATGGTCTGTAACTGGTGACAGGACGCTTCGAT\n+\n###########################################################################################");
        this.split = new FileSplit(new Path(this.tempFastq.toURI().toString()), 0L, (long)(illuminaFastq.length() + oneFastq.length() + 1), null);
        FastqInputFormat.FastqRecordReader reader = new FastqInputFormat.FastqRecordReader((Configuration)this.conf, this.split);
        Assert.assertTrue((boolean)reader.next(this.key, this.fragment));
        Assert.assertEquals((Object)"EAS139", (Object)this.fragment.getInstrument());
        Assert.assertTrue((boolean)reader.next(this.key, this.fragment));
        Assert.assertNull((Object)this.fragment.getInstrument());
        Assert.assertFalse((boolean)reader.next(this.key, this.fragment));
    }

    @Test
    public void testOneNotThenIllumina() throws IOException {
        this.writeToTempFastq("@ERR020229.10880 HWI-ST168_161:1:1:1373:2042/1\nTTGGATGATAGGGATTATTTGACTCGAATATTGGAAATAGCTGTTTATATTTTTTAAAAATGGTCTGTAACTGGTGACAGGACGCTTCGAT\n+\n###########################################################################################\n@EAS139:136:FC706VJ:2:5:1000:12850 1:Y:18:ATCACG\nTTGGATGATAGGGATTATTTGACTCGAATATTGGAAATAGCTGTTTATATTTTTTAAAAATGGTCTGTAACTGGTGACAGGACGCTTCGAT\n+\n##########################################################################################~");
        this.split = new FileSplit(new Path(this.tempFastq.toURI().toString()), 0L, (long)(illuminaFastq.length() + oneFastq.length() + 1), null);
        FastqInputFormat.FastqRecordReader reader = new FastqInputFormat.FastqRecordReader((Configuration)this.conf, this.split);
        Assert.assertTrue((boolean)reader.next(this.key, this.fragment));
        Assert.assertNull((Object)this.fragment.getInstrument());
        Assert.assertTrue((boolean)reader.next(this.key, this.fragment));
        Assert.assertNull((Object)this.fragment.getInstrument());
        Assert.assertFalse((boolean)reader.next(this.key, this.fragment));
    }

    @Test
    public void testProgress() throws IOException {
        this.writeToTempFastq(twoFastq);
        this.split = new FileSplit(new Path(this.tempFastq.toURI().toString()), 0L, (long)twoFastq.length(), null);
        FastqInputFormat.FastqRecordReader reader = new FastqInputFormat.FastqRecordReader((Configuration)this.conf, this.split);
        Assert.assertEquals((double)0.0, (double)reader.getProgress(), (double)0.01);
        reader.next(this.key, this.fragment);
        Assert.assertEquals((double)0.5, (double)reader.getProgress(), (double)0.01);
        reader.next(this.key, this.fragment);
        Assert.assertEquals((double)1.0, (double)reader.getProgress(), (double)0.01);
    }

    @Test
    public void testCreateKey() throws IOException {
        FastqInputFormat.FastqRecordReader reader = this.createReaderForOneFastq();
        Assert.assertTrue((boolean)(reader.createKey() instanceof Text));
    }

    @Test
    public void testCreateValue() throws IOException {
        FastqInputFormat.FastqRecordReader reader = this.createReaderForOneFastq();
        Assert.assertTrue((boolean)(reader.createValue() instanceof SequencedFragment));
    }

    @Test
    public void testClose() throws IOException {
        FastqInputFormat.FastqRecordReader reader = this.createReaderForOneFastq();
        reader.close();
    }

    @Test
    public void testReadFastqWithIdTwice() throws IOException {
        this.writeToTempFastq(fastqWithIdTwice);
        this.split = new FileSplit(new Path(this.tempFastq.toURI().toString()), 0L, (long)fastqWithIdTwice.length(), null);
        FastqInputFormat.FastqRecordReader reader = new FastqInputFormat.FastqRecordReader((Configuration)this.conf, this.split);
        boolean retval = reader.next(this.key, this.fragment);
        Assert.assertTrue((boolean)retval);
        Assert.assertEquals((Object)"ERR020229.10880 HWI-ST168_161:1:1:1373:2042/1", (Object)this.key.toString());
        Assert.assertEquals((Object)"TTGGATGATAGGGATTATTTGACTCGAATATTGGAAATAGCTGTTTATATTTTTTAAAAATGGTCTGTAACTGGTGACAGGACGCTTCGAT", (Object)this.fragment.getSequence().toString());
        Assert.assertEquals((Object)"###########################################################################################", (Object)this.fragment.getQuality().toString());
        retval = reader.next(this.key, this.fragment);
        Assert.assertFalse((boolean)retval);
    }

    @Test
    public void testReadFastqWithAmpersandQuality() throws IOException {
        this.writeToTempFastq(fastqWithAmpersandQuality);
        this.split = new FileSplit(new Path(this.tempFastq.toURI().toString()), 3L, (long)fastqWithAmpersandQuality.length(), null);
        FastqInputFormat.FastqRecordReader reader = new FastqInputFormat.FastqRecordReader((Configuration)this.conf, this.split);
        boolean retval = reader.next(this.key, this.fragment);
        Assert.assertTrue((boolean)retval);
        Assert.assertEquals((Object)"ERR020229.10880 HWI-ST168_161:1:1:1373:2042/1", (Object)this.key.toString());
        Assert.assertEquals((Object)"TTGGATGATAGGGATTATTTGACTCGAATATTGGAAATAGCTGTTTATATTTTTTAAAAATGGTCTGTAACTGGTGACAGGACGCTTCGAT", (Object)this.fragment.getSequence().toString());
        Assert.assertEquals((Object)"###########################################################################################", (Object)this.fragment.getQuality().toString());
        retval = reader.next(this.key, this.fragment);
        Assert.assertFalse((boolean)retval);
    }

    @Test
    public void testMakePositionMessage() throws IOException {
        this.writeToTempFastq(fastqWithIdTwice);
        this.split = new FileSplit(new Path(this.tempFastq.toURI().toString()), 0L, (long)fastqWithIdTwice.length(), null);
        FastqInputFormat.FastqRecordReader reader = new FastqInputFormat.FastqRecordReader((Configuration)this.conf, this.split);
        Assert.assertNotNull((Object)reader.makePositionMessage());
    }

    @Test
    public void testFastqWithIlluminaEncoding() throws IOException {
        this.conf.set("hbam.fastq-input.base-quality-encoding", "illumina");
        this.verifyInputQualityConfig();
    }

    @Test
    public void testFastqWithIlluminaEncodingAndGenericInputConfig() throws IOException {
        this.conf.set("hbam.input.base-quality-encoding", "illumina");
        this.verifyInputQualityConfig();
    }

    private void verifyInputQualityConfig() throws IOException {
        this.writeToTempFastq(illuminaFastqWithPhred64Quality);
        this.split = new FileSplit(new Path(this.tempFastq.toURI().toString()), 0L, (long)illuminaFastqWithPhred64Quality.length(), null);
        FastqInputFormat.FastqRecordReader reader = new FastqInputFormat.FastqRecordReader((Configuration)this.conf, this.split);
        boolean found = reader.next(this.key, this.fragment);
        Assert.assertTrue((boolean)found);
        Assert.assertEquals((Object)"CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", (Object)this.fragment.getQuality().toString());
    }

    @Test
    public void testGzCompressedInput() throws IOException {
        GzipCodec codec = new GzipCodec();
        PrintWriter fastqOut = new PrintWriter(new BufferedOutputStream((OutputStream)codec.createOutputStream((OutputStream)new FileOutputStream(this.tempGz))));
        fastqOut.write(twoFastq);
        fastqOut.close();
        this.split = new FileSplit(new Path(this.tempGz.toURI().toString()), 0L, (long)twoFastq.length(), null);
        FastqInputFormat.FastqRecordReader reader = new FastqInputFormat.FastqRecordReader((Configuration)this.conf, this.split);
        boolean retval = reader.next(this.key, this.fragment);
        Assert.assertTrue((boolean)retval);
        Assert.assertEquals((Object)"ERR020229.10880 HWI-ST168_161:1:1:1373:2042/1", (Object)this.key.toString());
        Assert.assertEquals((Object)"TTGGATGATAGGGATTATTTGACTCGAATATTGGAAATAGCTGTTTATATTTTTTAAAAATGGTCTGTAACTGGTGACAGGACGCTTCGAT", (Object)this.fragment.getSequence().toString());
        retval = reader.next(this.key, this.fragment);
        Assert.assertTrue((boolean)retval);
        Assert.assertEquals((Object)"ERR020229.10883 HWI-ST168_161:1:1:1796:2044/1", (Object)this.key.toString());
        Assert.assertEquals((Object)"TGAGCAGATGTGCTAAAGCTGCTTCTCCCCTAGGATCATTTGTACCTACCAGACTCAGGGAAAGGGGTGAGAATTGGGCCGTGGGGCAAGG", (Object)this.fragment.getSequence().toString());
    }

    @Test(expected=RuntimeException.class)
    public void testCompressedSplit() throws IOException {
        GzipCodec codec = new GzipCodec();
        PrintWriter fastqOut = new PrintWriter(new BufferedOutputStream((OutputStream)codec.createOutputStream((OutputStream)new FileOutputStream(this.tempGz))));
        fastqOut.write(twoFastq);
        fastqOut.close();
        this.split = new FileSplit(new Path(this.tempGz.toURI().toString()), 10L, (long)twoFastq.length(), null);
        FastqInputFormat.FastqRecordReader reader = new FastqInputFormat.FastqRecordReader((Configuration)this.conf, this.split);
    }

    @Test
    public void testIlluminaNoIndex() throws IOException {
        this.writeToTempFastq(illuminaFastqNoIndex);
        this.split = new FileSplit(new Path(this.tempFastq.toURI().toString()), 0L, (long)illuminaFastqNoIndex.length(), null);
        FastqInputFormat.FastqRecordReader reader = new FastqInputFormat.FastqRecordReader((Configuration)this.conf, this.split);
        boolean found = reader.next(this.key, this.fragment);
        Assert.assertTrue((boolean)found);
        Assert.assertEquals((Object)"EAS139", (Object)this.fragment.getInstrument());
        Assert.assertEquals((long)136L, (long)this.fragment.getRunNumber().intValue());
        Assert.assertEquals((Object)"", (Object)this.fragment.getIndexSequence());
    }

    @Test
    public void testSkipFailedQC() throws IOException {
        this.conf.set("hbam.fastq-input.filter-failed-qc", "true");
        this.verifySkipFailedQC();
    }

    @Test
    public void testSkipFailedQCGenericConfig() throws IOException {
        this.conf.set("hbam.input.filter-failed-qc", "true");
        this.verifySkipFailedQC();
    }

    private void verifySkipFailedQC() throws IOException {
        this.writeToTempFastq(twoFastqWithIllumina);
        this.split = new FileSplit(new Path(this.tempFastq.toURI().toString()), 0L, (long)twoFastqWithIllumina.length(), null);
        FastqInputFormat.FastqRecordReader reader = new FastqInputFormat.FastqRecordReader((Configuration)this.conf, this.split);
        boolean found = reader.next(this.key, this.fragment);
        Assert.assertTrue((boolean)found);
        Assert.assertEquals((long)2L, (long)this.fragment.getRead().intValue());
        found = reader.next(this.key, this.fragment);
        Assert.assertTrue((boolean)found);
        Assert.assertEquals((long)3L, (long)this.fragment.getRead().intValue());
        found = reader.next(this.key, this.fragment);
        Assert.assertFalse((boolean)found);
    }

    public static void main(String[] args) {
        JUnitCore.main((String[])new String[]{TestFastqInputFormat.class.getName()});
    }
}

