/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.seqdoop.hadoop_bam.FastaInputFormat;
import org.seqdoop.hadoop_bam.ReferenceFragment;

public class TestFastaInputFormat {
    private String input;
    private TaskAttemptContext taskAttemptContext;
    private JobContext jobContext;

    @Before
    public void setup() throws Exception {
        Configuration conf = new Configuration();
        this.input = ClassLoader.getSystemClassLoader().getResource("mini-chr1-chr2.fasta").getFile();
        conf.set("mapred.input.dir", "file://" + this.input);
        conf.set("mapreduce.input.fileinputformat.split.maxsize", "200");
        this.taskAttemptContext = new TaskAttemptContextImpl(conf, (TaskAttemptID)Mockito.mock(TaskAttemptID.class));
        this.jobContext = new JobContextImpl(conf, this.taskAttemptContext.getJobID());
    }

    @Test
    public void testReader() throws Exception {
        FastaInputFormat inputFormat = new FastaInputFormat();
        List splits = inputFormat.getSplits(this.jobContext);
        Assert.assertEquals((long)2L, (long)splits.size());
        RecordReader reader = inputFormat.createRecordReader((InputSplit)splits.get(0), this.taskAttemptContext);
        reader.initialize((InputSplit)splits.get(0), this.taskAttemptContext);
        Assert.assertTrue((boolean)reader.nextKeyValue());
        Assert.assertEquals((Object)new Text("chr1 dna:chromosome chromosome:GRCh37:1:1:249250621:11"), (Object)reader.getCurrentKey());
        Assert.assertEquals((Object)new Text("TAACCCTAACCCTAACCCTAACCCTAACCCTAACCCTAACCCTAACCCTAACCCTAACCCTAACCCTAACCCTAACCCTA"), (Object)((ReferenceFragment)reader.getCurrentValue()).getSequence());
        Assert.assertTrue((boolean)reader.nextKeyValue());
        Assert.assertEquals((Object)new Text("chr1 dna:chromosome chromosome:GRCh37:1:1:249250621:182"), (Object)reader.getCurrentKey());
        Assert.assertEquals((Object)new Text("ACCCTAACCCTAACCCTAACCCTAACCCAACCCTAACCCTAACCCTAACCCTAACCCTAACCCTAACCCCTAACCCTAAC"), (Object)((ReferenceFragment)reader.getCurrentValue()).getSequence());
        Assert.assertTrue((boolean)reader.nextKeyValue());
        Assert.assertEquals((Object)new Text("chr1 dna:chromosome chromosome:GRCh37:1:1:249250621:1163"), (Object)reader.getCurrentKey());
        Assert.assertEquals((Object)new Text("CCTAACCCTAACCCTAACCTAACCCTAACCCTAACCCTAACCCTAACCCTAACCCTAACCCTAACCCTAACCCCTAACCC"), (Object)((ReferenceFragment)reader.getCurrentValue()).getSequence());
        Assert.assertTrue((boolean)reader.nextKeyValue());
        Assert.assertEquals((Object)new Text("chr1 dna:chromosome chromosome:GRCh37:1:1:249250621:1244"), (Object)reader.getCurrentKey());
        Assert.assertEquals((Object)new Text("TAACCCTAAACCCTAAACCCTAACCCTAACCCTAACCCTAACCCTAACCCCAACCCCAACCCCAACCCCAACCCCAACCC"), (Object)((ReferenceFragment)reader.getCurrentValue()).getSequence());
        Assert.assertTrue((boolean)reader.nextKeyValue());
        Assert.assertEquals((Object)new Text("chr1 dna:chromosome chromosome:GRCh37:1:1:249250621:1325"), (Object)reader.getCurrentKey());
        Assert.assertEquals((Object)new Text("CAACCCTAACCCCTAACCCTAACCCTAACCCTACCCTAACCCTAACCCTAACCCTAACCCTAACCCTAACCCCTAACCCC"), (Object)((ReferenceFragment)reader.getCurrentValue()).getSequence());
        Assert.assertFalse((boolean)reader.nextKeyValue());
        reader = inputFormat.createRecordReader((InputSplit)splits.get(1), this.taskAttemptContext);
        reader.initialize((InputSplit)splits.get(1), this.taskAttemptContext);
        Assert.assertTrue((boolean)reader.nextKeyValue());
        Assert.assertEquals((Object)new Text("chr2 dna:chromosome chromosome:GRCh37:2:1:243199373:11"), (Object)reader.getCurrentKey());
        Assert.assertEquals((Object)new Text("TAACCCTAACCCTAACCCTAACCCTAACCCTAACCCTAACCCCTAACCCTAACCCTAACCCTAACCCTCGCGGTACCCTC"), (Object)((ReferenceFragment)reader.getCurrentValue()).getSequence());
        Assert.assertFalse((boolean)reader.nextKeyValue());
        reader.close();
    }
}

