/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.seqdoop.hadoop_bam.util.ConfHelper;

public class TestConfHelper {
    @Test
    public void testParseBooleanValidValues() {
        Assert.assertTrue((boolean)ConfHelper.parseBoolean((String)"true", (boolean)false));
        Assert.assertTrue((boolean)ConfHelper.parseBoolean((String)"tRuE", (boolean)false));
        Assert.assertTrue((boolean)ConfHelper.parseBoolean((String)"TRUE", (boolean)false));
        Assert.assertTrue((boolean)ConfHelper.parseBoolean((String)"t", (boolean)false));
        Assert.assertTrue((boolean)ConfHelper.parseBoolean((String)"yes", (boolean)false));
        Assert.assertTrue((boolean)ConfHelper.parseBoolean((String)"y", (boolean)false));
        Assert.assertTrue((boolean)ConfHelper.parseBoolean((String)"Y", (boolean)false));
        Assert.assertTrue((boolean)ConfHelper.parseBoolean((String)"1", (boolean)false));
        Assert.assertFalse((boolean)ConfHelper.parseBoolean((String)"false", (boolean)true));
        Assert.assertFalse((boolean)ConfHelper.parseBoolean((String)"faLse", (boolean)true));
        Assert.assertFalse((boolean)ConfHelper.parseBoolean((String)"FALSE", (boolean)true));
        Assert.assertFalse((boolean)ConfHelper.parseBoolean((String)"f", (boolean)true));
        Assert.assertFalse((boolean)ConfHelper.parseBoolean((String)"no", (boolean)true));
        Assert.assertFalse((boolean)ConfHelper.parseBoolean((String)"n", (boolean)true));
        Assert.assertFalse((boolean)ConfHelper.parseBoolean((String)"N", (boolean)true));
        Assert.assertFalse((boolean)ConfHelper.parseBoolean((String)"0", (boolean)true));
    }

    @Test
    public void testParseBooleanNull() {
        Assert.assertTrue((boolean)ConfHelper.parseBoolean(null, (boolean)true));
        Assert.assertFalse((boolean)ConfHelper.parseBoolean(null, (boolean)false));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseBooleanInvalidValue() {
        ConfHelper.parseBoolean((String)"dodo", (boolean)true);
    }

    @Test
    public void testParseBooleanFromConfValue() {
        String propName = "my.property";
        Configuration conf = new Configuration();
        conf.set("my.property", "t");
        Assert.assertTrue((boolean)ConfHelper.parseBoolean((Configuration)conf, (String)"my.property", (boolean)false));
    }

    @Test
    public void testParseBooleanFromConfNull() {
        Configuration conf = new Configuration();
        Assert.assertTrue((boolean)ConfHelper.parseBoolean((Configuration)conf, (String)"my.property", (boolean)true));
        Assert.assertFalse((boolean)ConfHelper.parseBoolean((Configuration)conf, (String)"my.property", (boolean)false));
    }

    public static void main(String[] args) {
        JUnitCore.main((String[])new String[]{TestConfHelper.class.getName()});
    }
}

