/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.Interval;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.seqdoop.hadoop_bam.BAMInputFormat;
import org.seqdoop.hadoop_bam.BAMTestUtil;
import org.seqdoop.hadoop_bam.SAMRecordWritable;

public class TestBAMInputFormat {
    private String input;
    private TaskAttemptContext taskAttemptContext;
    private JobContext jobContext;

    private void completeSetup() {
        this.completeSetup(false, null, true);
    }

    private void completeSetupWithIntervals(List<Interval> intervals) {
        this.completeSetupWithBoundedTraversal(intervals, false);
    }

    private void completeSetupWithBoundedTraversal(List<Interval> intervals, boolean traverseUnplacedUnmapped) {
        this.completeSetup(true, intervals, traverseUnplacedUnmapped);
    }

    private void completeSetup(boolean boundedTraversal, List<Interval> intervals, boolean traverseUnplacedUnmapped) {
        Configuration conf = new Configuration();
        conf.set("mapred.input.dir", "file://" + this.input);
        if (boundedTraversal) {
            BAMInputFormat.setTraversalParameters((Configuration)conf, intervals, (boolean)traverseUnplacedUnmapped);
        }
        this.taskAttemptContext = new TaskAttemptContextImpl(conf, (TaskAttemptID)Mockito.mock(TaskAttemptID.class));
        this.jobContext = new JobContextImpl(conf, this.taskAttemptContext.getJobID());
    }

    @Test
    public void testNoReadsInFirstSplitBug() throws Exception {
        this.input = BAMTestUtil.writeBamFileWithLargeHeader().getAbsolutePath();
        this.completeSetup();
        BAMInputFormat inputFormat = new BAMInputFormat();
        List splits = inputFormat.getSplits(this.jobContext);
        Assert.assertEquals((long)1L, (long)splits.size());
    }

    @Test
    public void testMultipleSplits() throws Exception {
        this.input = BAMTestUtil.writeBamFile(1000, SAMFileHeader.SortOrder.queryname).getAbsolutePath();
        this.completeSetup();
        this.jobContext.getConfiguration().setInt("mapreduce.input.fileinputformat.split.maxsize", 40000);
        BAMInputFormat inputFormat = new BAMInputFormat();
        List splits = inputFormat.getSplits(this.jobContext);
        Assert.assertEquals((long)2L, (long)splits.size());
        List<SAMRecord> split0Records = this.getSAMRecordsFromSplit(inputFormat, (InputSplit)splits.get(0));
        List<SAMRecord> split1Records = this.getSAMRecordsFromSplit(inputFormat, (InputSplit)splits.get(1));
        Assert.assertEquals((long)1577L, (long)split0Records.size());
        Assert.assertEquals((long)425L, (long)split1Records.size());
        SAMRecord lastRecordOfSplit0 = split0Records.get(split0Records.size() - 1);
        SAMRecord firstRecordOfSplit1 = split1Records.get(0);
        Assert.assertEquals((Object)lastRecordOfSplit0.getReadName(), (Object)firstRecordOfSplit1.getReadName());
        Assert.assertTrue((boolean)lastRecordOfSplit0.getFirstOfPairFlag());
        Assert.assertTrue((boolean)firstRecordOfSplit1.getSecondOfPairFlag());
    }

    @Test
    public void testMultipleSplitsBaiEnabled() throws Exception {
        this.input = BAMTestUtil.writeBamFile(1000, SAMFileHeader.SortOrder.coordinate).getAbsolutePath();
        this.completeSetup();
        BAMInputFormat.setEnableBAISplitCalculator((Configuration)this.jobContext.getConfiguration(), (boolean)true);
        this.jobContext.getConfiguration().setInt("mapreduce.input.fileinputformat.split.maxsize", 40000);
        BAMInputFormat inputFormat = new BAMInputFormat();
        List splits = inputFormat.getSplits(this.jobContext);
        Assert.assertEquals((long)3L, (long)splits.size());
        List<SAMRecord> split0Records = this.getSAMRecordsFromSplit(inputFormat, (InputSplit)splits.get(0));
        List<SAMRecord> split1Records = this.getSAMRecordsFromSplit(inputFormat, (InputSplit)splits.get(1));
        List<SAMRecord> split2Records = this.getSAMRecordsFromSplit(inputFormat, (InputSplit)splits.get(2));
        Assert.assertEquals((long)1080L, (long)split0Records.size());
        Assert.assertEquals((long)524L, (long)split1Records.size());
        Assert.assertEquals((long)398L, (long)split2Records.size());
    }

    @Test
    public void testMultipleSplitsBaiEnabledSuffixPath() throws Exception {
        this.input = BAMTestUtil.writeBamFile(1000, SAMFileHeader.SortOrder.coordinate).getAbsolutePath();
        File index = new File(this.input.replaceFirst("\\.bam$", ".bai"));
        index.renameTo(new File(this.input + ".bai"));
        this.completeSetup();
        BAMInputFormat.setEnableBAISplitCalculator((Configuration)this.jobContext.getConfiguration(), (boolean)true);
        this.jobContext.getConfiguration().setInt("mapreduce.input.fileinputformat.split.maxsize", 40000);
        BAMInputFormat inputFormat = new BAMInputFormat();
        List splits = inputFormat.getSplits(this.jobContext);
        Assert.assertEquals((long)3L, (long)splits.size());
        List<SAMRecord> split0Records = this.getSAMRecordsFromSplit(inputFormat, (InputSplit)splits.get(0));
        List<SAMRecord> split1Records = this.getSAMRecordsFromSplit(inputFormat, (InputSplit)splits.get(1));
        List<SAMRecord> split2Records = this.getSAMRecordsFromSplit(inputFormat, (InputSplit)splits.get(2));
        Assert.assertEquals((long)1080L, (long)split0Records.size());
        Assert.assertEquals((long)524L, (long)split1Records.size());
        Assert.assertEquals((long)398L, (long)split2Records.size());
    }

    @Test
    public void testMultipleSplitsBaiEnabledNoIndex() throws Exception {
        this.input = BAMTestUtil.writeBamFile(1000, SAMFileHeader.SortOrder.queryname).getAbsolutePath();
        this.completeSetup();
        BAMInputFormat.setEnableBAISplitCalculator((Configuration)this.jobContext.getConfiguration(), (boolean)true);
        this.jobContext.getConfiguration().setInt("mapreduce.input.fileinputformat.split.maxsize", 40000);
        BAMInputFormat inputFormat = new BAMInputFormat();
        List splits = inputFormat.getSplits(this.jobContext);
        Assert.assertEquals((long)2L, (long)splits.size());
        List<SAMRecord> split0Records = this.getSAMRecordsFromSplit(inputFormat, (InputSplit)splits.get(0));
        List<SAMRecord> split1Records = this.getSAMRecordsFromSplit(inputFormat, (InputSplit)splits.get(1));
        Assert.assertEquals((long)1577L, (long)split0Records.size());
        Assert.assertEquals((long)425L, (long)split1Records.size());
        SAMRecord lastRecordOfSplit0 = split0Records.get(split0Records.size() - 1);
        SAMRecord firstRecordOfSplit1 = split1Records.get(0);
        Assert.assertEquals((Object)lastRecordOfSplit0.getReadName(), (Object)firstRecordOfSplit1.getReadName());
        Assert.assertTrue((boolean)lastRecordOfSplit0.getFirstOfPairFlag());
        Assert.assertTrue((boolean)firstRecordOfSplit1.getSecondOfPairFlag());
    }

    @Test
    public void testIntervals() throws Exception {
        this.input = BAMTestUtil.writeBamFile(1000, SAMFileHeader.SortOrder.coordinate).getAbsolutePath();
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        intervals.add(new Interval("chr21", 5000, 9999));
        intervals.add(new Interval("chr21", 20000, 22999));
        this.completeSetupWithIntervals(intervals);
        this.jobContext.getConfiguration().setInt("mapreduce.input.fileinputformat.split.maxsize", 40000);
        BAMInputFormat inputFormat = new BAMInputFormat();
        List splits = inputFormat.getSplits(this.jobContext);
        Assert.assertEquals((long)1L, (long)splits.size());
        List<SAMRecord> split0Records = this.getSAMRecordsFromSplit(inputFormat, (InputSplit)splits.get(0));
        Assert.assertEquals((long)16L, (long)split0Records.size());
    }

    @Test
    public void testIntervalCoveringWholeChromosome() throws Exception {
        this.input = BAMTestUtil.writeBamFile(1000, SAMFileHeader.SortOrder.coordinate).getAbsolutePath();
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        intervals.add(new Interval("chr21", 1, 1000135));
        this.completeSetupWithIntervals(intervals);
        this.jobContext.getConfiguration().setInt("mapreduce.input.fileinputformat.split.maxsize", 40000);
        BAMInputFormat inputFormat = new BAMInputFormat();
        List splits = inputFormat.getSplits(this.jobContext);
        Assert.assertEquals((long)2L, (long)splits.size());
        List<SAMRecord> split0Records = this.getSAMRecordsFromSplit(inputFormat, (InputSplit)splits.get(0));
        List<SAMRecord> split1Records = this.getSAMRecordsFromSplit(inputFormat, (InputSplit)splits.get(1));
        Assert.assertEquals((long)1577L, (long)split0Records.size());
        Assert.assertEquals((long)423L, (long)split1Records.size());
    }

    @Test
    public void testIntervalsAndUnmapped() throws Exception {
        this.input = BAMTestUtil.writeBamFile(1000, SAMFileHeader.SortOrder.coordinate).getAbsolutePath();
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        intervals.add(new Interval("chr21", 5000, 9999));
        intervals.add(new Interval("chr21", 20000, 22999));
        this.completeSetupWithBoundedTraversal(intervals, true);
        this.jobContext.getConfiguration().setInt("mapreduce.input.fileinputformat.split.maxsize", 40000);
        BAMInputFormat inputFormat = new BAMInputFormat();
        List splits = inputFormat.getSplits(this.jobContext);
        Assert.assertEquals((long)2L, (long)splits.size());
        List<SAMRecord> split0Records = this.getSAMRecordsFromSplit(inputFormat, (InputSplit)splits.get(0));
        List<SAMRecord> split1Records = this.getSAMRecordsFromSplit(inputFormat, (InputSplit)splits.get(1));
        Assert.assertEquals((long)16L, (long)split0Records.size());
        Assert.assertEquals((long)2L, (long)split1Records.size());
    }

    @Test
    public void testUnmapped() throws Exception {
        this.input = BAMTestUtil.writeBamFile(1000, SAMFileHeader.SortOrder.coordinate).getAbsolutePath();
        this.completeSetupWithBoundedTraversal(null, true);
        this.jobContext.getConfiguration().setInt("mapreduce.input.fileinputformat.split.maxsize", 40000);
        BAMInputFormat inputFormat = new BAMInputFormat();
        List splits = inputFormat.getSplits(this.jobContext);
        Assert.assertEquals((long)1L, (long)splits.size());
        List<SAMRecord> split0Records = this.getSAMRecordsFromSplit(inputFormat, (InputSplit)splits.get(0));
        Assert.assertEquals((long)2L, (long)split0Records.size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMappedOnly() throws Exception {
        this.input = BAMTestUtil.writeBamFile(1000, SAMFileHeader.SortOrder.coordinate).getAbsolutePath();
        this.completeSetupWithBoundedTraversal(null, false);
    }

    private List<SAMRecord> getSAMRecordsFromSplit(BAMInputFormat inputFormat, InputSplit split) throws Exception {
        RecordReader reader = inputFormat.createRecordReader(split, this.taskAttemptContext);
        reader.initialize(split, this.taskAttemptContext);
        ArrayList<SAMRecord> records = new ArrayList<SAMRecord>();
        while (reader.nextKeyValue()) {
            SAMRecord r = ((SAMRecordWritable)reader.getCurrentValue()).get();
            records.add(r);
        }
        return records;
    }
}

