/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathNotFoundException;
import org.junit.Assert;
import org.junit.Test;
import org.seqdoop.hadoop_bam.AnySAMInputFormat;
import org.seqdoop.hadoop_bam.SAMFormat;

public class TestAnySAMInputFormat {
    @Test
    public void testHeaderlessSamFormat() throws PathNotFoundException {
        SAMFormat result = this.getSamFormat(new Configuration(), "test_headerless.sam");
        Assert.assertEquals((Object)SAMFormat.SAM, (Object)result);
    }

    @Test
    public void testTrustExtensionsIsHonored() throws PathNotFoundException {
        Configuration conf = new Configuration();
        Assert.assertEquals((Object)SAMFormat.SAM, (Object)this.getSamFormat(conf, "misnamedBam.sam"));
        conf.set("hadoopbam.anysam.trust-exts", "false");
        SAMFormat result = this.getSamFormat(conf, "misnamedBam.sam");
        Assert.assertEquals((Object)SAMFormat.BAM, (Object)result);
    }

    private SAMFormat getSamFormat(Configuration conf, String file) throws PathNotFoundException {
        String filePath = this.getClass().getClassLoader().getResource(file).getFile();
        return new AnySAMInputFormat(conf).getFormat(new Path(filePath));
    }
}

